/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.pool;

import com.aliyun.openservices.shade.io.netty.bootstrap.Bootstrap;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.EventLoop;
import com.aliyun.openservices.shade.io.netty.channel.pool.ChannelHealthChecker;
import com.aliyun.openservices.shade.io.netty.channel.pool.ChannelPool;
import com.aliyun.openservices.shade.io.netty.channel.pool.ChannelPoolHandler;
import com.aliyun.openservices.shade.io.netty.channel.pool.SimpleChannelPool$1;
import com.aliyun.openservices.shade.io.netty.channel.pool.SimpleChannelPool$2;
import com.aliyun.openservices.shade.io.netty.channel.pool.SimpleChannelPool$3;
import com.aliyun.openservices.shade.io.netty.channel.pool.SimpleChannelPool$4;
import com.aliyun.openservices.shade.io.netty.channel.pool.SimpleChannelPool$5;
import com.aliyun.openservices.shade.io.netty.channel.pool.SimpleChannelPool$6;
import com.aliyun.openservices.shade.io.netty.util.AttributeKey;
import com.aliyun.openservices.shade.io.netty.util.concurrent.Future;
import com.aliyun.openservices.shade.io.netty.util.concurrent.Promise;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.ThrowableUtil;
import java.util.Deque;

public class SimpleChannelPool
implements ChannelPool {
    private static final AttributeKey<SimpleChannelPool> POOL_KEY = AttributeKey.newInstance("channelPool");
    private static final IllegalStateException FULL_EXCEPTION = ThrowableUtil.unknownStackTrace(new IllegalStateException("ChannelPool full"), SimpleChannelPool.class, "releaseAndOffer(...)");
    private static final IllegalStateException UNHEALTHY_NON_OFFERED_TO_POOL = ThrowableUtil.unknownStackTrace(new IllegalStateException("Channel is unhealthy not offering it back to pool"), SimpleChannelPool.class, "releaseAndOffer(...)");
    private final Deque<Channel> deque = PlatformDependent.newConcurrentDeque();
    private final ChannelPoolHandler handler;
    private final ChannelHealthChecker healthCheck;
    private final Bootstrap bootstrap;
    private final boolean releaseHealthCheck;

    public SimpleChannelPool(Bootstrap bootstrap, ChannelPoolHandler channelPoolHandler) {
        this(bootstrap, channelPoolHandler, ChannelHealthChecker.ACTIVE);
    }

    public SimpleChannelPool(Bootstrap bootstrap, ChannelPoolHandler channelPoolHandler, ChannelHealthChecker channelHealthChecker) {
        this(bootstrap, channelPoolHandler, channelHealthChecker, true);
    }

    public SimpleChannelPool(Bootstrap bootstrap, ChannelPoolHandler channelPoolHandler, ChannelHealthChecker channelHealthChecker, boolean bl) {
        this.handler = ObjectUtil.checkNotNull(channelPoolHandler, "handler");
        this.healthCheck = ObjectUtil.checkNotNull(channelHealthChecker, "healthCheck");
        this.releaseHealthCheck = bl;
        this.bootstrap = ObjectUtil.checkNotNull(bootstrap, "bootstrap").clone();
        this.bootstrap.handler(new SimpleChannelPool$1(this, channelPoolHandler));
    }

    @Override
    public final Future<Channel> acquire() {
        SimpleChannelPool simpleChannelPool = this;
        return simpleChannelPool.acquire(simpleChannelPool.bootstrap.group().next().newPromise());
    }

    @Override
    public Future<Channel> acquire(Promise<Channel> promise) {
        ObjectUtil.checkNotNull(promise, "promise");
        return this.acquireHealthyFromPoolOrNew(promise);
    }

    private Future<Channel> acquireHealthyFromPoolOrNew(Promise<Channel> promise) {
        try {
            Object object = this.pollChannel();
            if (object == null) {
                Bootstrap bootstrap = this.bootstrap.clone();
                bootstrap.attr(POOL_KEY, this);
                object = this.connectChannel(bootstrap);
                if (object.isDone()) {
                    this.notifyConnect((ChannelFuture)object, promise);
                } else {
                    object.addListener(new SimpleChannelPool$2(this, promise));
                }
                return promise;
            }
            EventLoop eventLoop = object.eventLoop();
            if (eventLoop.inEventLoop()) {
                this.doHealthCheck((Channel)object, promise);
            } else {
                eventLoop.execute(new SimpleChannelPool$3(this, (Channel)object, promise));
            }
        }
        catch (Throwable throwable) {
            promise.tryFailure(throwable);
        }
        return promise;
    }

    private void notifyConnect(ChannelFuture object, Promise<Channel> promise) {
        if (object.isSuccess()) {
            if (!promise.trySuccess((Channel)(object = object.channel()))) {
                this.release((Channel)object);
            }
            return;
        }
        promise.tryFailure(object.cause());
    }

    private void doHealthCheck(Channel channel, Promise<Channel> promise) {
        assert (channel.eventLoop().inEventLoop());
        Future<Boolean> future = this.healthCheck.isHealthy(channel);
        if (future.isDone()) {
            this.notifyHealthCheck(future, channel, promise);
            return;
        }
        future.addListener(new SimpleChannelPool$4(this, channel, promise));
    }

    private void notifyHealthCheck(Future<Boolean> future, Channel channel, Promise<Channel> promise) {
        assert (channel.eventLoop().inEventLoop());
        if (future.isSuccess()) {
            if (future.getNow() == Boolean.TRUE) {
                try {
                    channel.attr(POOL_KEY).set(this);
                    this.handler.channelAcquired(channel);
                    promise.setSuccess(channel);
                    return;
                }
                catch (Throwable throwable) {
                    SimpleChannelPool.closeAndFail(channel, throwable, promise);
                    return;
                }
            }
            SimpleChannelPool.closeChannel(channel);
            this.acquireHealthyFromPoolOrNew(promise);
            return;
        }
        SimpleChannelPool.closeChannel(channel);
        this.acquireHealthyFromPoolOrNew(promise);
    }

    protected ChannelFuture connectChannel(Bootstrap bootstrap) {
        return bootstrap.connect();
    }

    @Override
    public final Future<Void> release(Channel channel) {
        Channel channel2 = channel;
        return this.release(channel2, channel2.eventLoop().newPromise());
    }

    @Override
    public Future<Void> release(Channel channel, Promise<Void> promise) {
        ObjectUtil.checkNotNull(channel, "channel");
        ObjectUtil.checkNotNull(promise, "promise");
        try {
            EventLoop eventLoop = channel.eventLoop();
            if (eventLoop.inEventLoop()) {
                this.doReleaseChannel(channel, promise);
            } else {
                eventLoop.execute(new SimpleChannelPool$5(this, channel, promise));
            }
        }
        catch (Throwable throwable) {
            SimpleChannelPool.closeAndFail(channel, throwable, promise);
        }
        return promise;
    }

    private void doReleaseChannel(Channel channel, Promise<Void> promise) {
        assert (channel.eventLoop().inEventLoop());
        if (channel.attr(POOL_KEY).getAndSet(null) != this) {
            SimpleChannelPool.closeAndFail(channel, new IllegalArgumentException("Channel " + channel + " was not acquired from this ChannelPool"), promise);
            return;
        }
        try {
            if (!this.releaseHealthCheck) {
                this.releaseAndOffer(channel, promise);
                return;
            }
            this.doHealthCheckOnRelease(channel, promise);
        }
        catch (Throwable throwable) {
            SimpleChannelPool.closeAndFail(channel, throwable, promise);
        }
    }

    private void doHealthCheckOnRelease(Channel channel, Promise<Void> promise) {
        Future<Boolean> future = this.healthCheck.isHealthy(channel);
        if (future.isDone()) {
            this.releaseAndOfferIfHealthy(channel, promise, future);
            return;
        }
        future.addListener(new SimpleChannelPool$6(this, channel, promise, future));
    }

    private void releaseAndOfferIfHealthy(Channel channel, Promise<Void> promise, Future<Boolean> future) {
        if (future.getNow().booleanValue()) {
            this.releaseAndOffer(channel, promise);
            return;
        }
        this.handler.channelReleased(channel);
        SimpleChannelPool.closeAndFail(channel, UNHEALTHY_NON_OFFERED_TO_POOL, promise);
    }

    private void releaseAndOffer(Channel channel, Promise<Void> promise) {
        if (this.offerChannel(channel)) {
            this.handler.channelReleased(channel);
            promise.setSuccess(null);
            return;
        }
        SimpleChannelPool.closeAndFail(channel, FULL_EXCEPTION, promise);
    }

    private static void closeChannel(Channel channel) {
        channel.attr(POOL_KEY).getAndSet(null);
        channel.close();
    }

    private static void closeAndFail(Channel channel, Throwable throwable, Promise<?> promise) {
        SimpleChannelPool.closeChannel(channel);
        promise.tryFailure(throwable);
    }

    protected Channel pollChannel() {
        return this.deque.pollLast();
    }

    protected boolean offerChannel(Channel channel) {
        return this.deque.offer(channel);
    }

    @Override
    public void close() {
        Channel channel;
        while ((channel = this.pollChannel()) != null) {
            channel.close();
        }
    }

    static /* synthetic */ void access$000(SimpleChannelPool simpleChannelPool, ChannelFuture channelFuture, Promise promise) {
        simpleChannelPool.notifyConnect(channelFuture, promise);
    }

    static /* synthetic */ void access$100(SimpleChannelPool simpleChannelPool, Channel channel, Promise promise) {
        simpleChannelPool.doHealthCheck(channel, promise);
    }

    static /* synthetic */ void access$200(SimpleChannelPool simpleChannelPool, Future future, Channel channel, Promise promise) {
        simpleChannelPool.notifyHealthCheck(future, channel, promise);
    }

    static /* synthetic */ void access$300(SimpleChannelPool simpleChannelPool, Channel channel, Promise promise) {
        simpleChannelPool.doReleaseChannel(channel, promise);
    }

    static /* synthetic */ void access$400(SimpleChannelPool simpleChannelPool, Channel channel, Promise promise, Future future) {
        simpleChannelPool.releaseAndOfferIfHealthy(channel, promise, future);
    }
}

