/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.rxtx;

import com.aliyun.openservices.shade.io.netty.channel.AbstractChannel$AbstractUnsafe;
import com.aliyun.openservices.shade.io.netty.channel.oio.OioByteStreamChannel;
import com.aliyun.openservices.shade.io.netty.channel.rxtx.DefaultRxtxChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.rxtx.RxtxChannel$RxtxUnsafe;
import com.aliyun.openservices.shade.io.netty.channel.rxtx.RxtxChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.rxtx.RxtxChannelOption;
import com.aliyun.openservices.shade.io.netty.channel.rxtx.RxtxDeviceAddress;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.net.SocketAddress;

public class RxtxChannel
extends OioByteStreamChannel {
    private static final RxtxDeviceAddress LOCAL_ADDRESS = new RxtxDeviceAddress("localhost");
    private final RxtxChannelConfig config = new DefaultRxtxChannelConfig(this);
    private boolean open = true;
    private RxtxDeviceAddress deviceAddress;
    private SerialPort serialPort;

    public RxtxChannel() {
        super(null);
    }

    @Override
    public RxtxChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public AbstractChannel$AbstractUnsafe newUnsafe() {
        return new RxtxChannel$RxtxUnsafe(this, null);
    }

    @Override
    public void doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        socketAddress = (RxtxDeviceAddress)socketAddress;
        socketAddress2 = CommPortIdentifier.getPortIdentifier((String)((RxtxDeviceAddress)socketAddress).value());
        socketAddress2 = socketAddress2.open(this.getClass().getName(), 1000);
        socketAddress2.enableReceiveTimeout(this.config().getOption(RxtxChannelOption.READ_TIMEOUT));
        this.deviceAddress = socketAddress;
        this.serialPort = (SerialPort)socketAddress2;
    }

    protected void doInit() {
        this.serialPort.setSerialPortParams(this.config().getOption(RxtxChannelOption.BAUD_RATE).intValue(), this.config().getOption(RxtxChannelOption.DATA_BITS).value(), this.config().getOption(RxtxChannelOption.STOP_BITS).value(), this.config().getOption(RxtxChannelOption.PARITY_BIT).value());
        this.serialPort.setDTR(this.config().getOption(RxtxChannelOption.DTR).booleanValue());
        this.serialPort.setRTS(this.config().getOption(RxtxChannelOption.RTS).booleanValue());
        RxtxChannel rxtxChannel = this;
        rxtxChannel.activate(rxtxChannel.serialPort.getInputStream(), this.serialPort.getOutputStream());
    }

    @Override
    public RxtxDeviceAddress localAddress() {
        return (RxtxDeviceAddress)super.localAddress();
    }

    @Override
    public RxtxDeviceAddress remoteAddress() {
        return (RxtxDeviceAddress)super.remoteAddress();
    }

    @Override
    protected RxtxDeviceAddress localAddress0() {
        return LOCAL_ADDRESS;
    }

    @Override
    protected RxtxDeviceAddress remoteAddress0() {
        return this.deviceAddress;
    }

    @Override
    public void doBind(SocketAddress socketAddress) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void doDisconnect() {
        ((OioByteStreamChannel)this).doClose();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doClose() {
        this.open = false;
        try {
            super.doClose();
            if (this.serialPort == null) return;
        }
        catch (Throwable throwable) {
            if (this.serialPort == null) throw throwable;
            this.serialPort.removeEventListener();
            this.serialPort.close();
            this.serialPort = null;
            throw throwable;
        }
        this.serialPort.removeEventListener();
        this.serialPort.close();
        this.serialPort = null;
    }
}

