/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.sctp;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.DefaultByteBufHolder;
import com.sun.nio.sctp.MessageInfo;

public final class SctpMessage
extends DefaultByteBufHolder {
    private final int streamIdentifier;
    private final int protocolIdentifier;
    private final boolean unordered;
    private final MessageInfo msgInfo;

    public SctpMessage(int n2, int n3, ByteBuf byteBuf) {
        this(n2, n3, false, byteBuf);
    }

    public SctpMessage(int n2, int n3, boolean bl, ByteBuf byteBuf) {
        super(byteBuf);
        this.protocolIdentifier = n2;
        this.streamIdentifier = n3;
        this.unordered = bl;
        this.msgInfo = null;
    }

    public SctpMessage(MessageInfo messageInfo, ByteBuf byteBuf) {
        super(byteBuf);
        if (messageInfo == null) {
            throw new NullPointerException("msgInfo");
        }
        this.msgInfo = messageInfo;
        this.streamIdentifier = messageInfo.streamNumber();
        this.protocolIdentifier = messageInfo.payloadProtocolID();
        this.unordered = messageInfo.isUnordered();
    }

    public final int streamIdentifier() {
        return this.streamIdentifier;
    }

    public final int protocolIdentifier() {
        return this.protocolIdentifier;
    }

    public final boolean isUnordered() {
        return this.unordered;
    }

    public final MessageInfo messageInfo() {
        return this.msgInfo;
    }

    public final boolean isComplete() {
        if (this.msgInfo != null) {
            return this.msgInfo.isComplete();
        }
        return true;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (SctpMessage)object;
        if (this.protocolIdentifier != ((SctpMessage)object).protocolIdentifier) {
            return false;
        }
        if (this.streamIdentifier != ((SctpMessage)object).streamIdentifier) {
            return false;
        }
        if (this.unordered != ((SctpMessage)object).unordered) {
            return false;
        }
        return this.content().equals(((DefaultByteBufHolder)object).content());
    }

    @Override
    public final int hashCode() {
        int n2 = this.streamIdentifier;
        n2 = n2 * 31 + this.protocolIdentifier;
        n2 = n2 * 31 + (this.unordered ? 1231 : 1237);
        n2 = n2 * 31 + this.content().hashCode();
        return n2;
    }

    @Override
    public final SctpMessage copy() {
        if (this.msgInfo == null) {
            return new SctpMessage(this.protocolIdentifier, this.streamIdentifier, this.unordered, this.content().copy());
        }
        return new SctpMessage(this.msgInfo, this.content().copy());
    }

    @Override
    public final SctpMessage duplicate() {
        if (this.msgInfo == null) {
            return new SctpMessage(this.protocolIdentifier, this.streamIdentifier, this.unordered, this.content().duplicate());
        }
        return new SctpMessage(this.msgInfo, this.content().duplicate());
    }

    @Override
    public final SctpMessage retain() {
        super.retain();
        return this;
    }

    @Override
    public final SctpMessage retain(int n2) {
        super.retain(n2);
        return this;
    }

    @Override
    public final String toString() {
        return "SctpFrame{streamIdentifier=" + this.streamIdentifier + ", protocolIdentifier=" + this.protocolIdentifier + ", unordered=" + this.unordered + ", data=" + this.contentToString() + '}';
    }
}

