/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.sctp.nio;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.DefaultByteBufHolder;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelException;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelMetadata;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundBuffer;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.RecvByteBufAllocator$Handle;
import com.aliyun.openservices.shade.io.netty.channel.nio.AbstractNioChannel;
import com.aliyun.openservices.shade.io.netty.channel.nio.AbstractNioMessageChannel;
import com.aliyun.openservices.shade.io.netty.channel.sctp.SctpChannel;
import com.aliyun.openservices.shade.io.netty.channel.sctp.SctpChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.sctp.SctpMessage;
import com.aliyun.openservices.shade.io.netty.channel.sctp.SctpNotificationHandler;
import com.aliyun.openservices.shade.io.netty.channel.sctp.SctpServerChannel;
import com.aliyun.openservices.shade.io.netty.channel.sctp.nio.NioSctpChannel$1;
import com.aliyun.openservices.shade.io.netty.channel.sctp.nio.NioSctpChannel$2;
import com.aliyun.openservices.shade.io.netty.channel.sctp.nio.NioSctpChannel$NioSctpChannelConfig;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCounted;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import com.sun.nio.sctp.Association;
import com.sun.nio.sctp.MessageInfo;
import com.sun.nio.sctp.NotificationHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class NioSctpChannel
extends AbstractNioMessageChannel
implements SctpChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioSctpChannel.class);
    private final SctpChannelConfig config;
    private final NotificationHandler<?> notificationHandler;
    private RecvByteBufAllocator$Handle allocHandle;

    private static com.sun.nio.sctp.SctpChannel newSctpChannel() {
        try {
            return com.sun.nio.sctp.SctpChannel.open();
        }
        catch (IOException iOException) {
            throw new ChannelException("Failed to open a sctp channel.", iOException);
        }
    }

    public NioSctpChannel() {
        this(NioSctpChannel.newSctpChannel());
    }

    public NioSctpChannel(com.sun.nio.sctp.SctpChannel sctpChannel) {
        this(null, sctpChannel);
    }

    public NioSctpChannel(Channel channel, com.sun.nio.sctp.SctpChannel sctpChannel) {
        super(channel, sctpChannel, 1);
        try {
            sctpChannel.configureBlocking(false);
            NioSctpChannel nioSctpChannel = this;
            this.config = new NioSctpChannel$NioSctpChannelConfig(nioSctpChannel, nioSctpChannel, sctpChannel, null);
            this.notificationHandler = new SctpNotificationHandler(this);
            return;
        }
        catch (IOException iOException) {
            block4: {
                try {
                    sctpChannel.close();
                }
                catch (IOException iOException2) {
                    if (!logger.isWarnEnabled()) break block4;
                    logger.warn("Failed to close a partially initialized sctp channel.", iOException2);
                }
            }
            throw new ChannelException("Failed to enter non-blocking mode.", iOException);
        }
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public SctpServerChannel parent() {
        return (SctpServerChannel)super.parent();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public Association association() {
        try {
            return this.javaChannel().association();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public Set<InetSocketAddress> allLocalAddresses() {
        try {
            Object object = this.javaChannel().getAllLocalAddresses();
            LinkedHashSet<InetSocketAddress> linkedHashSet = new LinkedHashSet<InetSocketAddress>(object.size());
            object = object.iterator();
            while (object.hasNext()) {
                SocketAddress socketAddress = (SocketAddress)object.next();
                linkedHashSet.add((InetSocketAddress)socketAddress);
            }
            return linkedHashSet;
        }
        catch (Throwable throwable) {
            return Collections.emptySet();
        }
    }

    @Override
    public SctpChannelConfig config() {
        return this.config;
    }

    @Override
    public Set<InetSocketAddress> allRemoteAddresses() {
        try {
            Object object = this.javaChannel().getRemoteAddresses();
            HashSet<InetSocketAddress> hashSet = new HashSet<InetSocketAddress>(object.size());
            object = object.iterator();
            while (object.hasNext()) {
                SocketAddress socketAddress = (SocketAddress)object.next();
                hashSet.add((InetSocketAddress)socketAddress);
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            return Collections.emptySet();
        }
    }

    @Override
    protected com.sun.nio.sctp.SctpChannel javaChannel() {
        return (com.sun.nio.sctp.SctpChannel)super.javaChannel();
    }

    @Override
    public boolean isActive() {
        com.sun.nio.sctp.SctpChannel sctpChannel = this.javaChannel();
        return sctpChannel.isOpen() && this.association() != null;
    }

    @Override
    public SocketAddress localAddress0() {
        try {
            Iterator<SocketAddress> iterator = this.javaChannel().getAllLocalAddresses().iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    @Override
    public SocketAddress remoteAddress0() {
        try {
            Iterator<SocketAddress> iterator = this.javaChannel().getRemoteAddresses().iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    @Override
    public void doBind(SocketAddress socketAddress) {
        this.javaChannel().bind(socketAddress);
    }

    @Override
    public boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        if (socketAddress2 != null) {
            this.javaChannel().bind(socketAddress2);
        }
        boolean bl = false;
        try {
            boolean bl2 = this.javaChannel().connect(socketAddress);
            if (!bl2) {
                this.selectionKey().interestOps(8);
            }
            bl = true;
            return bl2;
        }
        catch (Throwable throwable) {
            if (!bl) {
                ((AbstractNioChannel)this).doClose();
            }
            throw throwable;
        }
    }

    @Override
    public void doFinishConnect() {
        if (!this.javaChannel().finishConnect()) {
            throw new Error();
        }
    }

    @Override
    public void doDisconnect() {
        ((AbstractNioChannel)this).doClose();
    }

    @Override
    public void doClose() {
        this.javaChannel().close();
    }

    @Override
    public int doReadMessages(List<Object> list) {
        int n2;
        Object object;
        boolean bl;
        ByteBuf byteBuf;
        RecvByteBufAllocator$Handle recvByteBufAllocator$Handle;
        Object object2;
        block8: {
            object2 = this.javaChannel();
            recvByteBufAllocator$Handle = this.allocHandle;
            if (recvByteBufAllocator$Handle == null) {
                this.allocHandle = recvByteBufAllocator$Handle = this.config().getRecvByteBufAllocator().newHandle();
            }
            byteBuf = recvByteBufAllocator$Handle.allocate(this.config().getAllocator());
            bl = true;
            ByteBuf byteBuf2 = byteBuf;
            object = byteBuf2.internalNioBuffer(byteBuf2.writerIndex(), byteBuf.writableBytes());
            n2 = ((Buffer)object).position();
            object2 = ((com.sun.nio.sctp.SctpChannel)object2).receive((ByteBuffer)object, null, this.notificationHandler);
            if (object2 != null) break block8;
            int n3 = byteBuf.readableBytes();
            recvByteBufAllocator$Handle.record(n3);
            byteBuf.release();
            return 0;
        }
        try {
            ByteBuf byteBuf3 = byteBuf;
            list.add(new SctpMessage((MessageInfo)object2, byteBuf3.writerIndex(byteBuf3.writerIndex() + ((Buffer)object).position() - n2)));
            bl = false;
            int n4 = byteBuf.readableBytes();
            recvByteBufAllocator$Handle.record(n4);
            return 1;
        }
        catch (Throwable throwable) {
            try {
                object = throwable;
                PlatformDependent.throwException(throwable);
                return -1;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                int n5 = byteBuf.readableBytes();
                recvByteBufAllocator$Handle.record(n5);
                if (bl) {
                    byteBuf.release();
                }
            }
        }
    }

    @Override
    public boolean doWriteMessage(Object object, ChannelOutboundBuffer object2) {
        object2 = ((DefaultByteBufHolder)(object = (SctpMessage)object)).content();
        int n2 = ((ByteBuf)object2).readableBytes();
        if (n2 == 0) {
            return true;
        }
        ByteBufAllocator byteBufAllocator = this.alloc();
        boolean bl = ((ByteBuf)object2).nioBufferCount() != 1;
        if (!bl && !((ByteBuf)object2).isDirect() && byteBufAllocator.isDirectBufferPooled()) {
            bl = true;
        }
        if (!bl) {
            object2 = ((ByteBuf)object2).nioBuffer();
        } else {
            object2 = byteBufAllocator.directBuffer(n2).writeBytes((ByteBuf)object2);
            object2 = ((ByteBuf)object2).nioBuffer();
        }
        MessageInfo messageInfo = MessageInfo.createOutgoing(this.association(), null, ((SctpMessage)object).streamIdentifier());
        messageInfo.payloadProtocolID(((SctpMessage)object).protocolIdentifier());
        messageInfo.streamNumber(((SctpMessage)object).streamIdentifier());
        messageInfo.unordered(((SctpMessage)object).isUnordered());
        int n3 = this.javaChannel().send((ByteBuffer)object2, messageInfo);
        return n3 > 0;
    }

    @Override
    public final Object filterOutboundMessage(Object object) {
        if (object instanceof SctpMessage) {
            ByteBuf byteBuf = ((DefaultByteBufHolder)(object = (SctpMessage)object)).content();
            if (byteBuf.isDirect() && byteBuf.nioBufferCount() == 1) {
                return object;
            }
            return new SctpMessage(((SctpMessage)object).protocolIdentifier(), ((SctpMessage)object).streamIdentifier(), ((SctpMessage)object).isUnordered(), this.newDirectBuffer((ReferenceCounted)object, byteBuf));
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(object) + " (expected: " + StringUtil.simpleClassName(SctpMessage.class));
    }

    @Override
    public ChannelFuture bindAddress(InetAddress inetAddress) {
        return this.bindAddress(inetAddress, this.newPromise());
    }

    @Override
    public ChannelFuture bindAddress(InetAddress inetAddress, ChannelPromise channelPromise) {
        if (this.eventLoop().inEventLoop()) {
            try {
                this.javaChannel().bindAddress(inetAddress);
                channelPromise.setSuccess();
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        } else {
            this.eventLoop().execute(new NioSctpChannel$1(this, inetAddress, channelPromise));
        }
        return channelPromise;
    }

    @Override
    public ChannelFuture unbindAddress(InetAddress inetAddress) {
        return this.unbindAddress(inetAddress, this.newPromise());
    }

    @Override
    public ChannelFuture unbindAddress(InetAddress inetAddress, ChannelPromise channelPromise) {
        if (this.eventLoop().inEventLoop()) {
            try {
                this.javaChannel().unbindAddress(inetAddress);
                channelPromise.setSuccess();
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        } else {
            this.eventLoop().execute(new NioSctpChannel$2(this, inetAddress, channelPromise));
        }
        return channelPromise;
    }

    static /* synthetic */ void access$100(NioSctpChannel nioSctpChannel, boolean bl) {
        nioSctpChannel.setReadPending(bl);
    }
}

