/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.sctp.oio;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelException;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelMetadata;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundBuffer;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.RecvByteBufAllocator$Handle;
import com.aliyun.openservices.shade.io.netty.channel.oio.AbstractOioMessageChannel;
import com.aliyun.openservices.shade.io.netty.channel.sctp.SctpChannel;
import com.aliyun.openservices.shade.io.netty.channel.sctp.SctpChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.sctp.SctpMessage;
import com.aliyun.openservices.shade.io.netty.channel.sctp.SctpNotificationHandler;
import com.aliyun.openservices.shade.io.netty.channel.sctp.SctpServerChannel;
import com.aliyun.openservices.shade.io.netty.channel.sctp.oio.OioSctpChannel$1;
import com.aliyun.openservices.shade.io.netty.channel.sctp.oio.OioSctpChannel$2;
import com.aliyun.openservices.shade.io.netty.channel.sctp.oio.OioSctpChannel$OioSctpChannelConfig;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import com.sun.nio.sctp.Association;
import com.sun.nio.sctp.MessageInfo;
import com.sun.nio.sctp.NotificationHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class OioSctpChannel
extends AbstractOioMessageChannel
implements SctpChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OioSctpChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private static final String EXPECTED_TYPE = " (expected: " + StringUtil.simpleClassName(SctpMessage.class) + ')';
    private final com.sun.nio.sctp.SctpChannel ch;
    private final SctpChannelConfig config;
    private final Selector readSelector;
    private final Selector writeSelector;
    private final Selector connectSelector;
    private final NotificationHandler<?> notificationHandler;
    private RecvByteBufAllocator$Handle allocHandle;

    private static com.sun.nio.sctp.SctpChannel openChannel() {
        try {
            return com.sun.nio.sctp.SctpChannel.open();
        }
        catch (IOException iOException) {
            throw new ChannelException("Failed to open a sctp channel.", iOException);
        }
    }

    public OioSctpChannel() {
        this(OioSctpChannel.openChannel());
    }

    public OioSctpChannel(com.sun.nio.sctp.SctpChannel sctpChannel) {
        this(null, sctpChannel);
    }

    public OioSctpChannel(Channel channel, com.sun.nio.sctp.SctpChannel sctpChannel) {
        super(channel);
        this.ch = sctpChannel;
        try {
            try {
                sctpChannel.configureBlocking(false);
                this.readSelector = Selector.open();
                this.writeSelector = Selector.open();
                this.connectSelector = Selector.open();
                sctpChannel.register(this.readSelector, 1);
                sctpChannel.register(this.writeSelector, 4);
                sctpChannel.register(this.connectSelector, 8);
                OioSctpChannel oioSctpChannel = this;
                this.config = new OioSctpChannel$OioSctpChannelConfig(oioSctpChannel, oioSctpChannel, sctpChannel, null);
                this.notificationHandler = new SctpNotificationHandler(this);
                return;
            }
            catch (Exception exception) {
                throw new ChannelException("failed to initialize a sctp channel", exception);
            }
        }
        catch (Throwable throwable) {
            try {
                sctpChannel.close();
            }
            catch (IOException iOException) {
                logger.warn("Failed to close a sctp channel.", iOException);
            }
            throw throwable;
        }
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public SctpServerChannel parent() {
        return (SctpServerChannel)super.parent();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public SctpChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return this.ch.isOpen();
    }

    @Override
    public int doReadMessages(List<Object> list) {
        MessageInfo messageInfo;
        Object object;
        boolean bl;
        ByteBuf byteBuf;
        RecvByteBufAllocator$Handle recvByteBufAllocator$Handle;
        int n2;
        block10: {
            if (!this.readSelector.isOpen()) {
                return 0;
            }
            n2 = 0;
            int n3 = this.readSelector.select(1000L);
            n3 = n3 > 0 ? 1 : 0;
            if (n3 == 0) {
                return 0;
            }
            this.readSelector.selectedKeys().clear();
            recvByteBufAllocator$Handle = this.allocHandle;
            if (recvByteBufAllocator$Handle == null) {
                this.allocHandle = recvByteBufAllocator$Handle = this.config().getRecvByteBufAllocator().newHandle();
            }
            byteBuf = recvByteBufAllocator$Handle.allocate(this.config().getAllocator());
            bl = true;
            ByteBuf byteBuf2 = byteBuf;
            object = byteBuf2.nioBuffer(byteBuf2.writerIndex(), byteBuf.writableBytes());
            messageInfo = this.ch.receive((ByteBuffer)object, null, this.notificationHandler);
            if (messageInfo != null) break block10;
            int n4 = byteBuf.readableBytes();
            recvByteBufAllocator$Handle.record(n4);
            byteBuf.release();
            return 0;
        }
        try {
            ((ByteBuffer)object).flip();
            ByteBuf byteBuf3 = byteBuf;
            list.add(new SctpMessage(messageInfo, byteBuf3.writerIndex(byteBuf3.writerIndex() + ((Buffer)object).remaining())));
            bl = false;
            ++n2;
            int n5 = byteBuf.readableBytes();
            recvByteBufAllocator$Handle.record(n5);
        }
        catch (Throwable throwable) {
            try {
                object = throwable;
                PlatformDependent.throwException(throwable);
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                int n6 = byteBuf.readableBytes();
                recvByteBufAllocator$Handle.record(n6);
                if (bl) {
                    byteBuf.release();
                }
            }
        }
        return n2;
    }

    @Override
    public void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        if (!this.writeSelector.isOpen()) {
            return;
        }
        int n2 = channelOutboundBuffer.size();
        int n3 = this.writeSelector.select(1000L);
        if (n3 > 0) {
            Set<SelectionKey> set = this.writeSelector.selectedKeys();
            if (set.isEmpty()) {
                return;
            }
            set = set.iterator();
            int n4 = 0;
            do {
                ByteBuffer byteBuffer;
                if (n4 == n2) {
                    return;
                }
                set.next();
                set.remove();
                SctpMessage sctpMessage = (SctpMessage)channelOutboundBuffer.current();
                if (sctpMessage == null) {
                    return;
                }
                Object object = sctpMessage.content();
                int n5 = ((ByteBuf)object).readableBytes();
                if (((ByteBuf)object).nioBufferCount() != -1) {
                    byteBuffer = ((ByteBuf)object).nioBuffer();
                } else {
                    byteBuffer = ByteBuffer.allocate(n5);
                    ByteBuf byteBuf = object;
                    byteBuf.getBytes(byteBuf.readerIndex(), byteBuffer);
                    byteBuffer.flip();
                }
                object = MessageInfo.createOutgoing(this.association(), null, sctpMessage.streamIdentifier());
                ((MessageInfo)object).payloadProtocolID(sctpMessage.protocolIdentifier());
                ((MessageInfo)object).streamNumber(sctpMessage.streamIdentifier());
                ((MessageInfo)object).unordered(sctpMessage.isUnordered());
                this.ch.send(byteBuffer, (MessageInfo)object);
                ++n4;
                channelOutboundBuffer.remove();
            } while (set.hasNext());
            return;
        }
    }

    @Override
    public Object filterOutboundMessage(Object object) {
        if (object instanceof SctpMessage) {
            return object;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(object) + EXPECTED_TYPE);
    }

    @Override
    public Association association() {
        try {
            return this.ch.association();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public boolean isActive() {
        return this.isOpen() && this.association() != null;
    }

    @Override
    public SocketAddress localAddress0() {
        try {
            Iterator<SocketAddress> iterator = this.ch.getAllLocalAddresses().iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    @Override
    public Set<InetSocketAddress> allLocalAddresses() {
        try {
            Object object = this.ch.getAllLocalAddresses();
            LinkedHashSet<InetSocketAddress> linkedHashSet = new LinkedHashSet<InetSocketAddress>(object.size());
            object = object.iterator();
            while (object.hasNext()) {
                SocketAddress socketAddress = (SocketAddress)object.next();
                linkedHashSet.add((InetSocketAddress)socketAddress);
            }
            return linkedHashSet;
        }
        catch (Throwable throwable) {
            return Collections.emptySet();
        }
    }

    @Override
    public SocketAddress remoteAddress0() {
        try {
            Iterator<SocketAddress> iterator = this.ch.getRemoteAddresses().iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    @Override
    public Set<InetSocketAddress> allRemoteAddresses() {
        try {
            Object object = this.ch.getRemoteAddresses();
            LinkedHashSet<InetSocketAddress> linkedHashSet = new LinkedHashSet<InetSocketAddress>(object.size());
            object = object.iterator();
            while (object.hasNext()) {
                SocketAddress socketAddress = (SocketAddress)object.next();
                linkedHashSet.add((InetSocketAddress)socketAddress);
            }
            return linkedHashSet;
        }
        catch (Throwable throwable) {
            return Collections.emptySet();
        }
    }

    @Override
    public void doBind(SocketAddress socketAddress) {
        this.ch.bind(socketAddress);
    }

    @Override
    public void doConnect(SocketAddress socketAddress, SocketAddress object) {
        if (object != null) {
            this.ch.bind((SocketAddress)object);
        }
        try {
            this.ch.connect(socketAddress);
            boolean bl = false;
            while (!bl) {
                if (this.connectSelector.select(1000L) < 0) continue;
                object = this.connectSelector.selectedKeys();
                Iterator<SelectionKey> iterator = object.iterator();
                while (iterator.hasNext()) {
                    SelectionKey selectionKey = iterator.next();
                    if (!selectionKey.isConnectable()) continue;
                    object.clear();
                    bl = true;
                    break;
                }
                object.clear();
            }
            bl = this.ch.finishConnect();
            if (!bl) {
                this.doClose();
                return;
            }
        }
        catch (Throwable throwable) {
            this.doClose();
            throw throwable;
        }
    }

    @Override
    public void doDisconnect() {
        this.doClose();
    }

    @Override
    public void doClose() {
        OioSctpChannel.closeSelector("read", this.readSelector);
        OioSctpChannel.closeSelector("write", this.writeSelector);
        OioSctpChannel.closeSelector("connect", this.connectSelector);
        this.ch.close();
    }

    private static void closeSelector(String string, Selector selector) {
        try {
            selector.close();
            return;
        }
        catch (IOException iOException) {
            logger.warn("Failed to close a " + string + " selector.", iOException);
            return;
        }
    }

    @Override
    public ChannelFuture bindAddress(InetAddress inetAddress) {
        return this.bindAddress(inetAddress, this.newPromise());
    }

    @Override
    public ChannelFuture bindAddress(InetAddress inetAddress, ChannelPromise channelPromise) {
        if (this.eventLoop().inEventLoop()) {
            try {
                this.ch.bindAddress(inetAddress);
                channelPromise.setSuccess();
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        } else {
            this.eventLoop().execute(new OioSctpChannel$1(this, inetAddress, channelPromise));
        }
        return channelPromise;
    }

    @Override
    public ChannelFuture unbindAddress(InetAddress inetAddress) {
        return this.unbindAddress(inetAddress, this.newPromise());
    }

    @Override
    public ChannelFuture unbindAddress(InetAddress inetAddress, ChannelPromise channelPromise) {
        if (this.eventLoop().inEventLoop()) {
            try {
                this.ch.unbindAddress(inetAddress);
                channelPromise.setSuccess();
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        } else {
            this.eventLoop().execute(new OioSctpChannel$2(this, inetAddress, channelPromise));
        }
        return channelPromise;
    }

    static /* synthetic */ void access$100(OioSctpChannel oioSctpChannel, boolean bl) {
        oioSctpChannel.setReadPending(bl);
    }
}

