/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.sctp.oio;

import com.aliyun.openservices.shade.io.netty.channel.ChannelException;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelMetadata;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundBuffer;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.oio.AbstractOioMessageChannel;
import com.aliyun.openservices.shade.io.netty.channel.sctp.SctpServerChannel;
import com.aliyun.openservices.shade.io.netty.channel.sctp.SctpServerChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.sctp.oio.OioSctpChannel;
import com.aliyun.openservices.shade.io.netty.channel.sctp.oio.OioSctpServerChannel$1;
import com.aliyun.openservices.shade.io.netty.channel.sctp.oio.OioSctpServerChannel$2;
import com.aliyun.openservices.shade.io.netty.channel.sctp.oio.OioSctpServerChannel$OioSctpServerChannelConfig;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import com.sun.nio.sctp.SctpChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class OioSctpServerChannel
extends AbstractOioMessageChannel
implements SctpServerChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OioSctpServerChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private final com.sun.nio.sctp.SctpServerChannel sch;
    private final SctpServerChannelConfig config;
    private final Selector selector;

    private static com.sun.nio.sctp.SctpServerChannel newServerSocket() {
        try {
            return com.sun.nio.sctp.SctpServerChannel.open();
        }
        catch (IOException iOException) {
            throw new ChannelException("failed to create a sctp server channel", iOException);
        }
    }

    public OioSctpServerChannel() {
        this(OioSctpServerChannel.newServerSocket());
    }

    public OioSctpServerChannel(com.sun.nio.sctp.SctpServerChannel sctpServerChannel) {
        super(null);
        if (sctpServerChannel == null) {
            throw new NullPointerException("sctp server channel");
        }
        this.sch = sctpServerChannel;
        try {
            try {
                sctpServerChannel.configureBlocking(false);
                this.selector = Selector.open();
                sctpServerChannel.register(this.selector, 16);
                OioSctpServerChannel oioSctpServerChannel = this;
                this.config = new OioSctpServerChannel$OioSctpServerChannelConfig(oioSctpServerChannel, oioSctpServerChannel, sctpServerChannel, null);
                return;
            }
            catch (Exception exception) {
                throw new ChannelException("failed to initialize a sctp server channel", exception);
            }
        }
        catch (Throwable throwable) {
            try {
                sctpServerChannel.close();
            }
            catch (IOException iOException) {
                logger.warn("Failed to close a sctp server channel.", iOException);
            }
            throw throwable;
        }
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public SctpServerChannelConfig config() {
        return this.config;
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return null;
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public boolean isOpen() {
        return this.sch.isOpen();
    }

    @Override
    public SocketAddress localAddress0() {
        try {
            Iterator<SocketAddress> iterator = this.sch.getAllLocalAddresses().iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    @Override
    public Set<InetSocketAddress> allLocalAddresses() {
        try {
            Object object = this.sch.getAllLocalAddresses();
            LinkedHashSet<InetSocketAddress> linkedHashSet = new LinkedHashSet<InetSocketAddress>(object.size());
            object = object.iterator();
            while (object.hasNext()) {
                SocketAddress socketAddress = (SocketAddress)object.next();
                linkedHashSet.add((InetSocketAddress)socketAddress);
            }
            return linkedHashSet;
        }
        catch (Throwable throwable) {
            return Collections.emptySet();
        }
    }

    @Override
    public boolean isActive() {
        return this.isOpen() && this.localAddress0() != null;
    }

    @Override
    public void doBind(SocketAddress socketAddress) {
        this.sch.bind(socketAddress, this.config.getBacklog());
    }

    @Override
    public void doClose() {
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            logger.warn("Failed to close a selector.", iOException);
        }
        this.sch.close();
    }

    @Override
    public int doReadMessages(List<Object> list) {
        int n2;
        block7: {
            if (!this.isActive()) {
                return -1;
            }
            AbstractInterruptibleChannel abstractInterruptibleChannel = null;
            n2 = 0;
            try {
                int n3 = this.selector.select(1000L);
                if (n3 > 0) {
                    Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                    do {
                        SelectionKey selectionKey = iterator.next();
                        iterator.remove();
                        if (!selectionKey.isAcceptable() || (abstractInterruptibleChannel = this.sch.accept()) == null) continue;
                        list.add(new OioSctpChannel(this, (SctpChannel)abstractInterruptibleChannel));
                        ++n2;
                    } while (iterator.hasNext());
                    return n2;
                }
            }
            catch (Throwable throwable) {
                logger.warn("Failed to create a new channel from an accepted sctp channel.", throwable);
                if (abstractInterruptibleChannel == null) break block7;
                try {
                    abstractInterruptibleChannel.close();
                }
                catch (Throwable throwable2) {
                    logger.warn("Failed to close a sctp channel.", throwable2);
                }
            }
        }
        return n2;
    }

    @Override
    public ChannelFuture bindAddress(InetAddress inetAddress) {
        return this.bindAddress(inetAddress, this.newPromise());
    }

    @Override
    public ChannelFuture bindAddress(InetAddress inetAddress, ChannelPromise channelPromise) {
        if (this.eventLoop().inEventLoop()) {
            try {
                this.sch.bindAddress(inetAddress);
                channelPromise.setSuccess();
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        } else {
            this.eventLoop().execute(new OioSctpServerChannel$1(this, inetAddress, channelPromise));
        }
        return channelPromise;
    }

    @Override
    public ChannelFuture unbindAddress(InetAddress inetAddress) {
        return this.unbindAddress(inetAddress, this.newPromise());
    }

    @Override
    public ChannelFuture unbindAddress(InetAddress inetAddress, ChannelPromise channelPromise) {
        if (this.eventLoop().inEventLoop()) {
            try {
                this.sch.unbindAddress(inetAddress);
                channelPromise.setSuccess();
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        } else {
            this.eventLoop().execute(new OioSctpServerChannel$2(this, inetAddress, channelPromise));
        }
        return channelPromise;
    }

    @Override
    public void doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SocketAddress remoteAddress0() {
        return null;
    }

    @Override
    public void doDisconnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object filterOutboundMessage(Object object) {
        throw new UnsupportedOperationException();
    }

    static /* synthetic */ void access$100(OioSctpServerChannel oioSctpServerChannel, boolean bl) {
        oioSctpServerChannel.setReadPending(bl);
    }
}

