/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.socket.nio;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.AddressedEnvelope;
import com.aliyun.openservices.shade.io.netty.channel.ChannelException;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelMetadata;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOption;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundBuffer;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.DefaultAddressedEnvelope;
import com.aliyun.openservices.shade.io.netty.channel.RecvByteBufAllocator$Handle;
import com.aliyun.openservices.shade.io.netty.channel.nio.AbstractNioChannel;
import com.aliyun.openservices.shade.io.netty.channel.nio.AbstractNioMessageChannel;
import com.aliyun.openservices.shade.io.netty.channel.socket.DatagramChannel;
import com.aliyun.openservices.shade.io.netty.channel.socket.DatagramChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.socket.DatagramPacket;
import com.aliyun.openservices.shade.io.netty.channel.socket.InternetProtocolFamily;
import com.aliyun.openservices.shade.io.netty.channel.socket.nio.NioDatagramChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.socket.nio.ProtocolFamilyConverter;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.MembershipKey;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class NioDatagramChannel
extends AbstractNioMessageChannel
implements DatagramChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(true);
    private static final SelectorProvider DEFAULT_SELECTOR_PROVIDER = SelectorProvider.provider();
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(DatagramPacket.class) + ", " + StringUtil.simpleClassName(AddressedEnvelope.class) + '<' + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(SocketAddress.class) + ">, " + StringUtil.simpleClassName(ByteBuf.class) + ')';
    private final DatagramChannelConfig config;
    private Map<InetAddress, List<MembershipKey>> memberships;
    private RecvByteBufAllocator$Handle allocHandle;

    private static java.nio.channels.DatagramChannel newSocket(SelectorProvider selectorProvider) {
        try {
            return selectorProvider.openDatagramChannel();
        }
        catch (IOException iOException) {
            throw new ChannelException("Failed to open a socket.", iOException);
        }
    }

    private static java.nio.channels.DatagramChannel newSocket(SelectorProvider selectorProvider, InternetProtocolFamily internetProtocolFamily) {
        if (internetProtocolFamily == null) {
            return NioDatagramChannel.newSocket(selectorProvider);
        }
        NioDatagramChannel.checkJavaVersion();
        try {
            return selectorProvider.openDatagramChannel(ProtocolFamilyConverter.convert(internetProtocolFamily));
        }
        catch (IOException iOException) {
            throw new ChannelException("Failed to open a socket.", iOException);
        }
    }

    private static void checkJavaVersion() {
        if (PlatformDependent.javaVersion() < 7) {
            throw new UnsupportedOperationException("Only supported on java 7+.");
        }
    }

    public NioDatagramChannel() {
        this(NioDatagramChannel.newSocket(DEFAULT_SELECTOR_PROVIDER));
    }

    public NioDatagramChannel(SelectorProvider selectorProvider) {
        this(NioDatagramChannel.newSocket(selectorProvider));
    }

    public NioDatagramChannel(InternetProtocolFamily internetProtocolFamily) {
        this(NioDatagramChannel.newSocket(DEFAULT_SELECTOR_PROVIDER, internetProtocolFamily));
    }

    public NioDatagramChannel(SelectorProvider selectorProvider, InternetProtocolFamily internetProtocolFamily) {
        this(NioDatagramChannel.newSocket(selectorProvider, internetProtocolFamily));
    }

    public NioDatagramChannel(java.nio.channels.DatagramChannel datagramChannel) {
        super(null, datagramChannel, 1);
        this.config = new NioDatagramChannelConfig(this, datagramChannel);
    }

    @Override
    public final ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public final DatagramChannelConfig config() {
        return this.config;
    }

    @Override
    public final boolean isActive() {
        java.nio.channels.DatagramChannel datagramChannel = this.javaChannel();
        return datagramChannel.isOpen() && (this.config.getOption(ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION) != false && this.isRegistered() || datagramChannel.socket().isBound());
    }

    @Override
    public final boolean isConnected() {
        return this.javaChannel().isConnected();
    }

    @Override
    protected final java.nio.channels.DatagramChannel javaChannel() {
        return (java.nio.channels.DatagramChannel)super.javaChannel();
    }

    @Override
    public final SocketAddress localAddress0() {
        return this.javaChannel().socket().getLocalSocketAddress();
    }

    @Override
    public final SocketAddress remoteAddress0() {
        return this.javaChannel().socket().getRemoteSocketAddress();
    }

    @Override
    public final void doBind(SocketAddress socketAddress) {
        this.doBind0(socketAddress);
    }

    private void doBind0(SocketAddress socketAddress) {
        if (PlatformDependent.javaVersion() >= 7) {
            this.javaChannel().bind(socketAddress);
            return;
        }
        this.javaChannel().socket().bind(socketAddress);
    }

    @Override
    public final boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        if (socketAddress2 != null) {
            this.doBind0(socketAddress2);
        }
        boolean bl = false;
        try {
            this.javaChannel().connect(socketAddress);
            bl = true;
            return true;
        }
        catch (Throwable throwable) {
            if (!bl) {
                ((AbstractNioChannel)this).doClose();
            }
            throw throwable;
        }
    }

    @Override
    public final void doFinishConnect() {
        throw new Error();
    }

    @Override
    public final void doDisconnect() {
        this.javaChannel().disconnect();
    }

    @Override
    public final void doClose() {
        this.javaChannel().close();
    }

    @Override
    public final int doReadMessages(List<Object> list) {
        int n2;
        Object object;
        boolean bl;
        RecvByteBufAllocator$Handle recvByteBufAllocator$Handle;
        Object object2;
        Object object3;
        block8: {
            object3 = this.javaChannel();
            object2 = this.config();
            recvByteBufAllocator$Handle = this.allocHandle;
            if (recvByteBufAllocator$Handle == null) {
                this.allocHandle = recvByteBufAllocator$Handle = object2.getRecvByteBufAllocator().newHandle();
            }
            object2 = recvByteBufAllocator$Handle.allocate(object2.getAllocator());
            bl = true;
            Object object4 = object2;
            object = ((ByteBuf)object4).internalNioBuffer(((ByteBuf)object4).writerIndex(), ((ByteBuf)object2).writableBytes());
            n2 = ((Buffer)object).position();
            object3 = (InetSocketAddress)((java.nio.channels.DatagramChannel)object3).receive((ByteBuffer)object);
            if (object3 != null) break block8;
            object2.release();
            return 0;
        }
        try {
            int n3 = ((Buffer)object).position() - n2;
            Object object5 = object2;
            ((ByteBuf)object5).writerIndex(((ByteBuf)object5).writerIndex() + n3);
            recvByteBufAllocator$Handle.record(n3);
            list.add(new DatagramPacket((ByteBuf)object2, this.localAddress(), (InetSocketAddress)object3));
            bl = false;
            return 1;
        }
        catch (Throwable throwable) {
            object = throwable;
            PlatformDependent.throwException(throwable);
            return -1;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (bl) {
                object2.release();
            }
        }
    }

    @Override
    public final boolean doWriteMessage(Object object, ChannelOutboundBuffer channelOutboundBuffer) {
        ByteBuf byteBuf;
        if (object instanceof AddressedEnvelope) {
            object = (AddressedEnvelope)object;
            channelOutboundBuffer = object.recipient();
            byteBuf = (ByteBuf)object.content();
        } else {
            byteBuf = (ByteBuf)object;
            channelOutboundBuffer = null;
        }
        int n2 = byteBuf.readableBytes();
        if (n2 == 0) {
            return true;
        }
        ByteBuf byteBuf2 = byteBuf;
        ByteBuffer byteBuffer = byteBuf2.internalNioBuffer(byteBuf2.readerIndex(), n2);
        int n3 = channelOutboundBuffer != null ? this.javaChannel().send(byteBuffer, (SocketAddress)((Object)channelOutboundBuffer)) : this.javaChannel().write(byteBuffer);
        return n3 > 0;
    }

    @Override
    public final Object filterOutboundMessage(Object object) {
        AddressedEnvelope addressedEnvelope;
        if (object instanceof DatagramPacket) {
            DatagramPacket datagramPacket = (DatagramPacket)object;
            if (NioDatagramChannel.isSingleDirectBuffer((ByteBuf)(object = (ByteBuf)datagramPacket.content()))) {
                return datagramPacket;
            }
            return new DatagramPacket(this.newDirectBuffer(datagramPacket, (ByteBuf)object), (InetSocketAddress)datagramPacket.recipient());
        }
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            if (NioDatagramChannel.isSingleDirectBuffer(byteBuf)) {
                return byteBuf;
            }
            return this.newDirectBuffer(byteBuf);
        }
        if (object instanceof AddressedEnvelope && (addressedEnvelope = (AddressedEnvelope)object).content() instanceof ByteBuf) {
            object = (ByteBuf)addressedEnvelope.content();
            if (NioDatagramChannel.isSingleDirectBuffer((ByteBuf)object)) {
                return addressedEnvelope;
            }
            return new DefaultAddressedEnvelope(this.newDirectBuffer(addressedEnvelope, (ByteBuf)object), addressedEnvelope.recipient());
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(object) + EXPECTED_TYPES);
    }

    private static boolean isSingleDirectBuffer(ByteBuf byteBuf) {
        return byteBuf.isDirect() && byteBuf.nioBufferCount() == 1;
    }

    @Override
    public final boolean continueOnWriteError() {
        return true;
    }

    @Override
    public final InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public final InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public final ChannelFuture joinGroup(InetAddress inetAddress) {
        return this.joinGroup(inetAddress, this.newPromise());
    }

    @Override
    public final ChannelFuture joinGroup(InetAddress inetAddress, ChannelPromise channelPromise) {
        try {
            return this.joinGroup(inetAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), null, channelPromise);
        }
        catch (SocketException socketException) {
            channelPromise.setFailure(socketException);
            return channelPromise;
        }
    }

    @Override
    public final ChannelFuture joinGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface) {
        return this.joinGroup(inetSocketAddress, networkInterface, this.newPromise());
    }

    @Override
    public final ChannelFuture joinGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface, ChannelPromise channelPromise) {
        return this.joinGroup(inetSocketAddress.getAddress(), networkInterface, null, channelPromise);
    }

    @Override
    public final ChannelFuture joinGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        return this.joinGroup(inetAddress, networkInterface, inetAddress2, this.newPromise());
    }

    @Override
    public final ChannelFuture joinGroup(InetAddress inetAddress, NetworkInterface object, InetAddress object2, ChannelPromise channelPromise) {
        NioDatagramChannel.checkJavaVersion();
        if (inetAddress == null) {
            throw new NullPointerException("multicastAddress");
        }
        if (object == null) {
            throw new NullPointerException("networkInterface");
        }
        try {
            object = object2 == null ? this.javaChannel().join(inetAddress, (NetworkInterface)object) : this.javaChannel().join(inetAddress, (NetworkInterface)object, (InetAddress)object2);
            object2 = this;
            synchronized (object2) {
                List<MembershipKey> list = null;
                if (this.memberships == null) {
                    this.memberships = new HashMap<InetAddress, List<MembershipKey>>();
                } else {
                    list = this.memberships.get(inetAddress);
                }
                if (list == null) {
                    list = new ArrayList<MembershipKey>();
                    this.memberships.put(inetAddress, list);
                }
                list.add((MembershipKey)object);
            }
            channelPromise.setSuccess();
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
        }
        return channelPromise;
    }

    @Override
    public final ChannelFuture leaveGroup(InetAddress inetAddress) {
        return this.leaveGroup(inetAddress, this.newPromise());
    }

    @Override
    public final ChannelFuture leaveGroup(InetAddress inetAddress, ChannelPromise channelPromise) {
        try {
            return this.leaveGroup(inetAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), null, channelPromise);
        }
        catch (SocketException socketException) {
            channelPromise.setFailure(socketException);
            return channelPromise;
        }
    }

    @Override
    public final ChannelFuture leaveGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface) {
        return this.leaveGroup(inetSocketAddress, networkInterface, this.newPromise());
    }

    @Override
    public final ChannelFuture leaveGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface, ChannelPromise channelPromise) {
        return this.leaveGroup(inetSocketAddress.getAddress(), networkInterface, null, channelPromise);
    }

    @Override
    public final ChannelFuture leaveGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        return this.leaveGroup(inetAddress, networkInterface, inetAddress2, this.newPromise());
    }

    @Override
    public final ChannelFuture leaveGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2, ChannelPromise channelPromise) {
        NioDatagramChannel.checkJavaVersion();
        if (inetAddress == null) {
            throw new NullPointerException("multicastAddress");
        }
        if (networkInterface == null) {
            throw new NullPointerException("networkInterface");
        }
        NioDatagramChannel nioDatagramChannel = this;
        synchronized (nioDatagramChannel) {
            List<MembershipKey> list;
            if (this.memberships != null && (list = this.memberships.get(inetAddress)) != null) {
                Iterator<MembershipKey> iterator = list.iterator();
                while (iterator.hasNext()) {
                    MembershipKey membershipKey = iterator.next();
                    if (!networkInterface.equals(membershipKey.networkInterface()) || (inetAddress2 != null || membershipKey.sourceAddress() != null) && (inetAddress2 == null || !inetAddress2.equals(membershipKey.sourceAddress()))) continue;
                    membershipKey.drop();
                    iterator.remove();
                }
                if (list.isEmpty()) {
                    this.memberships.remove(inetAddress);
                }
            }
        }
        channelPromise.setSuccess();
        return channelPromise;
    }

    @Override
    public final ChannelFuture block(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        return this.block(inetAddress, networkInterface, inetAddress2, this.newPromise());
    }

    @Override
    public final ChannelFuture block(InetAddress iterator, NetworkInterface networkInterface, InetAddress inetAddress, ChannelPromise channelPromise) {
        NioDatagramChannel.checkJavaVersion();
        if (iterator == null) {
            throw new NullPointerException("multicastAddress");
        }
        if (inetAddress == null) {
            throw new NullPointerException("sourceToBlock");
        }
        if (networkInterface == null) {
            throw new NullPointerException("networkInterface");
        }
        NioDatagramChannel nioDatagramChannel = this;
        synchronized (nioDatagramChannel) {
            if (this.memberships != null) {
                iterator = this.memberships.get(iterator);
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    MembershipKey membershipKey = iterator.next();
                    if (!networkInterface.equals(membershipKey.networkInterface())) continue;
                    try {
                        membershipKey.block(inetAddress);
                    }
                    catch (IOException iOException) {
                        channelPromise.setFailure(iOException);
                    }
                }
            }
        }
        channelPromise.setSuccess();
        return channelPromise;
    }

    @Override
    public final ChannelFuture block(InetAddress inetAddress, InetAddress inetAddress2) {
        return this.block(inetAddress, inetAddress2, this.newPromise());
    }

    @Override
    public final ChannelFuture block(InetAddress inetAddress, InetAddress inetAddress2, ChannelPromise channelPromise) {
        try {
            return this.block(inetAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), inetAddress2, channelPromise);
        }
        catch (SocketException socketException) {
            channelPromise.setFailure(socketException);
            return channelPromise;
        }
    }

    @Override
    public final void setReadPending(boolean bl) {
        super.setReadPending(bl);
    }

    @Override
    public final boolean closeOnReadError(Throwable throwable) {
        if (throwable instanceof SocketException) {
            return false;
        }
        return super.closeOnReadError(throwable);
    }
}

