/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.socket.nio;

import com.aliyun.openservices.shade.io.netty.channel.ChannelException;
import com.aliyun.openservices.shade.io.netty.channel.nio.AbstractNioChannel;
import com.aliyun.openservices.shade.io.netty.channel.socket.DatagramChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.socket.DefaultDatagramChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.socket.nio.NioDatagramChannel;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;

class NioDatagramChannelConfig
extends DefaultDatagramChannelConfig {
    private static final Object IP_MULTICAST_TTL;
    private static final Object IP_MULTICAST_IF;
    private static final Object IP_MULTICAST_LOOP;
    private static final Method GET_OPTION;
    private static final Method SET_OPTION;
    private final DatagramChannel javaChannel;

    NioDatagramChannelConfig(NioDatagramChannel nioDatagramChannel, DatagramChannel datagramChannel) {
        super(nioDatagramChannel, datagramChannel.socket());
        this.javaChannel = datagramChannel;
    }

    @Override
    public int getTimeToLive() {
        return (Integer)this.getOption0(IP_MULTICAST_TTL);
    }

    @Override
    public DatagramChannelConfig setTimeToLive(int n2) {
        this.setOption0(IP_MULTICAST_TTL, n2);
        return this;
    }

    @Override
    public InetAddress getInterface() {
        Object object = ((DefaultDatagramChannelConfig)this).getNetworkInterface();
        if (object == null) {
            return null;
        }
        if ((object = ((NetworkInterface)object).getInetAddresses()).hasMoreElements()) {
            return (InetAddress)object.nextElement();
        }
        return null;
    }

    @Override
    public DatagramChannelConfig setInterface(InetAddress inetAddress) {
        try {
            ((DefaultDatagramChannelConfig)this).setNetworkInterface(NetworkInterface.getByInetAddress(inetAddress));
        }
        catch (SocketException socketException) {
            throw new ChannelException(socketException);
        }
        return this;
    }

    @Override
    public NetworkInterface getNetworkInterface() {
        return (NetworkInterface)this.getOption0(IP_MULTICAST_IF);
    }

    @Override
    public DatagramChannelConfig setNetworkInterface(NetworkInterface networkInterface) {
        this.setOption0(IP_MULTICAST_IF, networkInterface);
        return this;
    }

    @Override
    public boolean isLoopbackModeDisabled() {
        return (Boolean)this.getOption0(IP_MULTICAST_LOOP);
    }

    @Override
    public DatagramChannelConfig setLoopbackModeDisabled(boolean bl) {
        this.setOption0(IP_MULTICAST_LOOP, bl);
        return this;
    }

    @Override
    public DatagramChannelConfig setAutoRead(boolean bl) {
        super.setAutoRead(bl);
        return this;
    }

    @Override
    public void autoReadCleared() {
        ((AbstractNioChannel)((NioDatagramChannel)this.channel)).setReadPending(false);
    }

    private Object getOption0(Object object) {
        if (GET_OPTION == null) {
            throw new UnsupportedOperationException();
        }
        try {
            return GET_OPTION.invoke((Object)this.javaChannel, object);
        }
        catch (Exception exception) {
            throw new ChannelException(exception);
        }
    }

    private void setOption0(Object object, Object object2) {
        if (SET_OPTION == null) {
            throw new UnsupportedOperationException();
        }
        try {
            SET_OPTION.invoke((Object)this.javaChannel, object, object2);
            return;
        }
        catch (Exception exception) {
            throw new ChannelException(exception);
        }
    }

    static {
        ClassLoader classLoader = PlatformDependent.getClassLoader(DatagramChannel.class);
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.net.SocketOption", true, classLoader);
        }
        catch (Exception exception) {}
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName("java.net.StandardSocketOptions", true, classLoader);
        }
        catch (Exception exception) {}
        Object object = null;
        Object object2 = null;
        Object object3 = null;
        Method method = null;
        Method method2 = null;
        if (clazz != null) {
            try {
                object = clazz2.getDeclaredField("IP_MULTICAST_TTL").get(null);
            }
            catch (Exception exception) {
                throw new Error("cannot locate the IP_MULTICAST_TTL field", exception);
            }
            try {
                object2 = clazz2.getDeclaredField("IP_MULTICAST_IF").get(null);
            }
            catch (Exception exception) {
                throw new Error("cannot locate the IP_MULTICAST_IF field", exception);
            }
            try {
                object3 = clazz2.getDeclaredField("IP_MULTICAST_LOOP").get(null);
            }
            catch (Exception exception) {
                throw new Error("cannot locate the IP_MULTICAST_LOOP field", exception);
            }
            clazz2 = null;
            try {
                clazz2 = Class.forName("java.nio.channels.NetworkChannel", true, classLoader);
            }
            catch (Throwable throwable) {}
            if (clazz2 == null) {
                method = null;
                method2 = null;
            } else {
                try {
                    method = clazz2.getDeclaredMethod("getOption", clazz);
                }
                catch (Exception exception) {
                    throw new Error("cannot locate the getOption() method", exception);
                }
                try {
                    method2 = clazz2.getDeclaredMethod("setOption", clazz, Object.class);
                }
                catch (Exception exception) {
                    throw new Error("cannot locate the setOption() method", exception);
                }
            }
        }
        IP_MULTICAST_TTL = object;
        IP_MULTICAST_IF = object2;
        IP_MULTICAST_LOOP = object3;
        GET_OPTION = method;
        SET_OPTION = method2;
    }
}

