/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.socket.nio;

import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelException;
import com.aliyun.openservices.shade.io.netty.channel.ChannelMetadata;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundBuffer;
import com.aliyun.openservices.shade.io.netty.channel.nio.AbstractNioMessageChannel;
import com.aliyun.openservices.shade.io.netty.channel.socket.ServerSocketChannel;
import com.aliyun.openservices.shade.io.netty.channel.socket.ServerSocketChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.socket.nio.NioServerSocketChannel$NioServerSocketChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.socket.nio.NioSocketChannel;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.List;

public class NioServerSocketChannel
extends AbstractNioMessageChannel
implements ServerSocketChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private static final SelectorProvider DEFAULT_SELECTOR_PROVIDER = SelectorProvider.provider();
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioServerSocketChannel.class);
    private final ServerSocketChannelConfig config;

    private static java.nio.channels.ServerSocketChannel newSocket(SelectorProvider selectorProvider) {
        try {
            return selectorProvider.openServerSocketChannel();
        }
        catch (IOException iOException) {
            throw new ChannelException("Failed to open a server socket.", iOException);
        }
    }

    public NioServerSocketChannel() {
        this(NioServerSocketChannel.newSocket(DEFAULT_SELECTOR_PROVIDER));
    }

    public NioServerSocketChannel(SelectorProvider selectorProvider) {
        this(NioServerSocketChannel.newSocket(selectorProvider));
    }

    public NioServerSocketChannel(java.nio.channels.ServerSocketChannel serverSocketChannel) {
        super(null, serverSocketChannel, 16);
        NioServerSocketChannel nioServerSocketChannel = this;
        this.config = new NioServerSocketChannel$NioServerSocketChannelConfig(nioServerSocketChannel, nioServerSocketChannel, this.javaChannel().socket(), null);
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public ServerSocketChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isActive() {
        return this.javaChannel().socket().isBound();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return null;
    }

    @Override
    protected java.nio.channels.ServerSocketChannel javaChannel() {
        return (java.nio.channels.ServerSocketChannel)super.javaChannel();
    }

    @Override
    public SocketAddress localAddress0() {
        return this.javaChannel().socket().getLocalSocketAddress();
    }

    @Override
    public void doBind(SocketAddress socketAddress) {
        if (PlatformDependent.javaVersion() >= 7) {
            this.javaChannel().bind(socketAddress, this.config.getBacklog());
            return;
        }
        this.javaChannel().socket().bind(socketAddress, this.config.getBacklog());
    }

    @Override
    public void doClose() {
        this.javaChannel().close();
    }

    @Override
    public int doReadMessages(List<Object> list) {
        SocketChannel socketChannel = this.javaChannel().accept();
        try {
            if (socketChannel != null) {
                list.add(new NioSocketChannel((Channel)this, socketChannel));
                return 1;
            }
        }
        catch (Throwable throwable) {
            logger.warn("Failed to create a new channel from an accepted socket.", throwable);
            try {
                socketChannel.close();
            }
            catch (Throwable throwable2) {
                logger.warn("Failed to close a socket.", throwable2);
            }
        }
        return 0;
    }

    @Override
    public boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void doFinishConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SocketAddress remoteAddress0() {
        return null;
    }

    @Override
    public void doDisconnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean doWriteMessage(Object object, ChannelOutboundBuffer channelOutboundBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Object filterOutboundMessage(Object object) {
        throw new UnsupportedOperationException();
    }

    static /* synthetic */ void access$100(NioServerSocketChannel nioServerSocketChannel, boolean bl) {
        nioServerSocketChannel.setReadPending(bl);
    }
}

