/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.socket.nio;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.AbstractChannel$AbstractUnsafe;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelException;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelMetadata;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundBuffer;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.FileRegion;
import com.aliyun.openservices.shade.io.netty.channel.nio.AbstractNioByteChannel;
import com.aliyun.openservices.shade.io.netty.channel.nio.AbstractNioChannel;
import com.aliyun.openservices.shade.io.netty.channel.nio.AbstractNioChannel$AbstractNioUnsafe;
import com.aliyun.openservices.shade.io.netty.channel.socket.ServerSocketChannel;
import com.aliyun.openservices.shade.io.netty.channel.socket.SocketChannel;
import com.aliyun.openservices.shade.io.netty.channel.socket.SocketChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.socket.nio.NioSocketChannel$1;
import com.aliyun.openservices.shade.io.netty.channel.socket.nio.NioSocketChannel$2;
import com.aliyun.openservices.shade.io.netty.channel.socket.nio.NioSocketChannel$NioSocketChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.socket.nio.NioSocketChannel$NioSocketChannelUnsafe;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.Executor;

public class NioSocketChannel
extends AbstractNioByteChannel
implements SocketChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private static final SelectorProvider DEFAULT_SELECTOR_PROVIDER = SelectorProvider.provider();
    private final SocketChannelConfig config;

    private static java.nio.channels.SocketChannel newSocket(SelectorProvider selectorProvider) {
        try {
            return selectorProvider.openSocketChannel();
        }
        catch (IOException iOException) {
            throw new ChannelException("Failed to open a socket.", iOException);
        }
    }

    public NioSocketChannel() {
        this(NioSocketChannel.newSocket(DEFAULT_SELECTOR_PROVIDER));
    }

    public NioSocketChannel(SelectorProvider selectorProvider) {
        this(NioSocketChannel.newSocket(selectorProvider));
    }

    public NioSocketChannel(java.nio.channels.SocketChannel socketChannel) {
        this(null, socketChannel);
    }

    public NioSocketChannel(Channel channel, java.nio.channels.SocketChannel socketChannel) {
        super(channel, socketChannel);
        NioSocketChannel nioSocketChannel = this;
        this.config = new NioSocketChannel$NioSocketChannelConfig(nioSocketChannel, nioSocketChannel, socketChannel.socket(), null);
    }

    @Override
    public ServerSocketChannel parent() {
        return (ServerSocketChannel)super.parent();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public SocketChannelConfig config() {
        return this.config;
    }

    @Override
    protected java.nio.channels.SocketChannel javaChannel() {
        return (java.nio.channels.SocketChannel)super.javaChannel();
    }

    @Override
    public boolean isActive() {
        java.nio.channels.SocketChannel socketChannel = this.javaChannel();
        return socketChannel.isOpen() && socketChannel.isConnected();
    }

    @Override
    public boolean isInputShutdown() {
        return super.isInputShutdown();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.javaChannel().socket().isOutputShutdown() || !this.isActive();
    }

    @Override
    public ChannelFuture shutdownOutput() {
        NioSocketChannel nioSocketChannel = this;
        return nioSocketChannel.shutdownOutput(nioSocketChannel.newPromise());
    }

    @Override
    public ChannelFuture shutdownOutput(ChannelPromise channelPromise) {
        Executor executor = ((AbstractChannel$AbstractUnsafe)((NioSocketChannel$NioSocketChannelUnsafe)this.unsafe())).prepareToClose();
        if (executor != null) {
            executor.execute(new NioSocketChannel$1(this, channelPromise));
        } else {
            executor = this.eventLoop();
            if (executor.inEventLoop()) {
                this.shutdownOutput0(channelPromise);
            } else {
                executor.execute(new NioSocketChannel$2(this, channelPromise));
            }
        }
        return channelPromise;
    }

    private void shutdownOutput0(ChannelPromise channelPromise) {
        try {
            this.shutdownOutput0();
            channelPromise.setSuccess();
            return;
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
            return;
        }
    }

    private void shutdownOutput0() {
        if (PlatformDependent.javaVersion() >= 7) {
            this.javaChannel().shutdownOutput();
            return;
        }
        this.javaChannel().socket().shutdownOutput();
    }

    private void shutdownInput0(ChannelPromise channelPromise) {
        try {
            this.shutdownInput0();
            channelPromise.setSuccess();
            return;
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
            return;
        }
    }

    private void shutdownInput0() {
        if (PlatformDependent.javaVersion() >= 7) {
            this.javaChannel().shutdownInput();
            return;
        }
        this.javaChannel().socket().shutdownInput();
    }

    @Override
    public SocketAddress localAddress0() {
        return this.javaChannel().socket().getLocalSocketAddress();
    }

    @Override
    public SocketAddress remoteAddress0() {
        return this.javaChannel().socket().getRemoteSocketAddress();
    }

    @Override
    public void doBind(SocketAddress socketAddress) {
        this.doBind0(socketAddress);
    }

    private void doBind0(SocketAddress socketAddress) {
        if (PlatformDependent.javaVersion() >= 7) {
            this.javaChannel().bind(socketAddress);
            return;
        }
        this.javaChannel().socket().bind(socketAddress);
    }

    @Override
    public boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        if (socketAddress2 != null) {
            this.doBind0(socketAddress2);
        }
        boolean bl = false;
        try {
            boolean bl2 = this.javaChannel().connect(socketAddress);
            if (!bl2) {
                this.selectionKey().interestOps(8);
            }
            bl = true;
            return bl2;
        }
        catch (Throwable throwable) {
            if (!bl) {
                ((AbstractNioChannel)this).doClose();
            }
            throw throwable;
        }
    }

    @Override
    public void doFinishConnect() {
        if (!this.javaChannel().finishConnect()) {
            throw new Error();
        }
    }

    @Override
    public void doDisconnect() {
        ((AbstractNioChannel)this).doClose();
    }

    @Override
    public void doClose() {
        super.doClose();
        this.javaChannel().close();
    }

    @Override
    public int doReadBytes(ByteBuf byteBuf) {
        return byteBuf.writeBytes(this.javaChannel(), byteBuf.writableBytes());
    }

    @Override
    public int doWriteBytes(ByteBuf byteBuf) {
        int n2 = byteBuf.readableBytes();
        return byteBuf.readBytes(this.javaChannel(), n2);
    }

    @Override
    public long doWriteFileRegion(FileRegion fileRegion) {
        long l2 = fileRegion.transfered();
        return fileRegion.transferTo(this.javaChannel(), l2);
    }

    @Override
    public void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        boolean bl;
        int n2;
        do {
            if ((n2 = channelOutboundBuffer.size()) == 0) {
                this.clearOpWrite();
                return;
            }
            long l2 = 0L;
            n2 = 0;
            bl = false;
            ByteBuffer[] byteBufferArray = channelOutboundBuffer.nioBuffers();
            int n3 = channelOutboundBuffer.nioBufferCount();
            long l3 = channelOutboundBuffer.nioBufferSize();
            java.nio.channels.SocketChannel socketChannel = this.javaChannel();
            block0 : switch (n3) {
                case 0: {
                    super.doWrite(channelOutboundBuffer);
                    return;
                }
                case 1: {
                    int n4;
                    byteBufferArray = byteBufferArray[0];
                    for (n4 = this.config().getWriteSpinCount() - 1; n4 >= 0; --n4) {
                        n3 = socketChannel.write((ByteBuffer)byteBufferArray);
                        if (n3 == 0) {
                            bl = true;
                            break block0;
                        }
                        l2 += (long)n3;
                        if ((l3 -= (long)n3) != 0L) continue;
                        n2 = 1;
                        break block0;
                    }
                    break;
                }
                default: {
                    int n4;
                    for (n4 = this.config().getWriteSpinCount() - 1; n4 >= 0; --n4) {
                        long l4 = socketChannel.write(byteBufferArray, 0, n3);
                        if (l4 == 0L) {
                            bl = true;
                            break block0;
                        }
                        l2 += l4;
                        if ((l3 -= l4) != 0L) continue;
                        n2 = 1;
                        break block0;
                    }
                }
            }
            channelOutboundBuffer.removeBytes(l2);
        } while (n2 != 0);
        this.incompleteWrite(bl);
    }

    @Override
    public AbstractNioChannel$AbstractNioUnsafe newUnsafe() {
        return new NioSocketChannel$NioSocketChannelUnsafe(this, null);
    }

    static /* synthetic */ void access$100(NioSocketChannel nioSocketChannel, ChannelPromise channelPromise) {
        nioSocketChannel.shutdownOutput0(channelPromise);
    }

    static /* synthetic */ void access$300(NioSocketChannel nioSocketChannel) {
        nioSocketChannel.doDeregister();
    }

    static /* synthetic */ void access$400(NioSocketChannel nioSocketChannel, boolean bl) {
        nioSocketChannel.setReadPending(bl);
    }
}

