/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.socket.oio;

import com.aliyun.openservices.shade.io.netty.channel.ChannelException;
import com.aliyun.openservices.shade.io.netty.channel.ChannelMetadata;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundBuffer;
import com.aliyun.openservices.shade.io.netty.channel.oio.AbstractOioMessageChannel;
import com.aliyun.openservices.shade.io.netty.channel.socket.ServerSocketChannel;
import com.aliyun.openservices.shade.io.netty.channel.socket.oio.DefaultOioServerSocketChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.socket.oio.OioServerSocketChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.socket.oio.OioSocketChannel;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class OioServerSocketChannel
extends AbstractOioMessageChannel
implements ServerSocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OioServerSocketChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    final ServerSocket socket;
    final Lock shutdownLock = new ReentrantLock();
    private final OioServerSocketChannelConfig config;

    private static ServerSocket newServerSocket() {
        try {
            return new ServerSocket();
        }
        catch (IOException iOException) {
            throw new ChannelException("failed to create a server socket", iOException);
        }
    }

    public OioServerSocketChannel() {
        this(OioServerSocketChannel.newServerSocket());
    }

    public OioServerSocketChannel(ServerSocket serverSocket) {
        super(null);
        if (serverSocket == null) {
            throw new NullPointerException("socket");
        }
        try {
            try {
                serverSocket.setSoTimeout(1000);
            }
            catch (IOException iOException) {
                throw new ChannelException("Failed to set the server socket timeout.", iOException);
            }
        }
        catch (Throwable throwable) {
            block8: {
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {
                    if (!logger.isWarnEnabled()) break block8;
                    logger.warn("Failed to close a partially initialized socket.", iOException);
                }
            }
            throw throwable;
        }
        this.socket = serverSocket;
        this.config = new DefaultOioServerSocketChannelConfig(this, serverSocket);
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public OioServerSocketChannelConfig config() {
        return this.config;
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return null;
    }

    @Override
    public boolean isOpen() {
        return !this.socket.isClosed();
    }

    @Override
    public boolean isActive() {
        return this.isOpen() && this.socket.isBound();
    }

    @Override
    public SocketAddress localAddress0() {
        return this.socket.getLocalSocketAddress();
    }

    @Override
    public void doBind(SocketAddress socketAddress) {
        this.socket.bind(socketAddress, this.config.getBacklog());
    }

    @Override
    public void doClose() {
        this.socket.close();
    }

    @Override
    public int doReadMessages(List<Object> list) {
        if (this.socket.isClosed()) {
            return -1;
        }
        try {
            Socket socket = this.socket.accept();
            try {
                list.add(new OioSocketChannel(this, socket));
                return 1;
            }
            catch (Throwable throwable) {
                logger.warn("Failed to create a new channel from an accepted socket.", throwable);
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    logger.warn("Failed to close a socket.", throwable2);
                }
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {}
        return 0;
    }

    @Override
    public void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object filterOutboundMessage(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SocketAddress remoteAddress0() {
        return null;
    }

    @Override
    public void doDisconnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setReadPending(boolean bl) {
        super.setReadPending(bl);
    }
}

