/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.socket.oio;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelException;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.ConnectTimeoutException;
import com.aliyun.openservices.shade.io.netty.channel.EventLoop;
import com.aliyun.openservices.shade.io.netty.channel.oio.AbstractOioByteChannel;
import com.aliyun.openservices.shade.io.netty.channel.oio.OioByteStreamChannel;
import com.aliyun.openservices.shade.io.netty.channel.socket.ServerSocketChannel;
import com.aliyun.openservices.shade.io.netty.channel.socket.SocketChannel;
import com.aliyun.openservices.shade.io.netty.channel.socket.oio.DefaultOioSocketChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.socket.oio.OioSocketChannel$1;
import com.aliyun.openservices.shade.io.netty.channel.socket.oio.OioSocketChannelConfig;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;

public class OioSocketChannel
extends OioByteStreamChannel
implements SocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OioSocketChannel.class);
    private final Socket socket;
    private final OioSocketChannelConfig config;

    public OioSocketChannel() {
        this(new Socket());
    }

    public OioSocketChannel(Socket socket) {
        this(null, socket);
    }

    public OioSocketChannel(Channel channel, Socket socket) {
        super(channel);
        this.socket = socket;
        this.config = new DefaultOioSocketChannelConfig(this, socket);
        try {
            try {
                if (socket.isConnected()) {
                    this.activate(socket.getInputStream(), socket.getOutputStream());
                }
                socket.setSoTimeout(1000);
                return;
            }
            catch (Exception exception) {
                throw new ChannelException("failed to initialize a socket", exception);
            }
        }
        catch (Throwable throwable) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                logger.warn("Failed to close a socket.", iOException);
            }
            throw throwable;
        }
    }

    @Override
    public ServerSocketChannel parent() {
        return (ServerSocketChannel)super.parent();
    }

    @Override
    public OioSocketChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return !this.socket.isClosed();
    }

    @Override
    public boolean isActive() {
        return !this.socket.isClosed() && this.socket.isConnected();
    }

    @Override
    public boolean isInputShutdown() {
        return super.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown() || !((OioByteStreamChannel)this).isActive();
    }

    @Override
    public ChannelFuture shutdownOutput() {
        OioSocketChannel oioSocketChannel = this;
        return oioSocketChannel.shutdownOutput(oioSocketChannel.newPromise());
    }

    @Override
    public int doReadBytes(ByteBuf byteBuf) {
        if (this.socket.isClosed()) {
            return -1;
        }
        try {
            return super.doReadBytes(byteBuf);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return 0;
        }
    }

    @Override
    public ChannelFuture shutdownOutput(ChannelPromise channelPromise) {
        EventLoop eventLoop = this.eventLoop();
        if (eventLoop.inEventLoop()) {
            try {
                this.socket.shutdownOutput();
                channelPromise.setSuccess();
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        } else {
            eventLoop.execute(new OioSocketChannel$1(this, channelPromise));
        }
        return channelPromise;
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public SocketAddress localAddress0() {
        return this.socket.getLocalSocketAddress();
    }

    @Override
    public SocketAddress remoteAddress0() {
        return this.socket.getRemoteSocketAddress();
    }

    @Override
    public void doBind(SocketAddress socketAddress) {
        this.socket.bind(socketAddress);
    }

    @Override
    public void doConnect(SocketAddress serializable, SocketAddress socketAddress) {
        if (socketAddress != null) {
            this.socket.bind(socketAddress);
        }
        try {
            try {
                this.socket.connect((SocketAddress)serializable, this.config().getConnectTimeoutMillis());
                OioSocketChannel oioSocketChannel = this;
                oioSocketChannel.activate(oioSocketChannel.socket.getInputStream(), this.socket.getOutputStream());
                return;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                serializable = new ConnectTimeoutException("connection timed out: " + serializable);
                ((Throwable)serializable).setStackTrace(socketTimeoutException.getStackTrace());
                throw serializable;
            }
        }
        catch (Throwable throwable) {
            ((OioByteStreamChannel)this).doClose();
            throw throwable;
        }
    }

    @Override
    public void doDisconnect() {
        ((OioByteStreamChannel)this).doClose();
    }

    @Override
    public void doClose() {
        this.socket.close();
    }

    @Override
    public boolean checkInputShutdown() {
        if (((AbstractOioByteChannel)this).isInputShutdown()) {
            try {
                Thread.sleep(this.config().getSoTimeout());
            }
            catch (Throwable throwable) {}
            return true;
        }
        return false;
    }

    @Override
    public void setReadPending(boolean bl) {
        super.setReadPending(bl);
    }
}

