/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.udt;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOption;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.MessageSizeEstimator;
import com.aliyun.openservices.shade.io.netty.channel.RecvByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.channel.udt.UdtChannel;
import com.aliyun.openservices.shade.io.netty.channel.udt.UdtChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.udt.UdtChannelOption;
import com.barchart.udt.OptionUDT;
import com.barchart.udt.nio.ChannelUDT;
import java.util.Map;

public class DefaultUdtChannelConfig
extends DefaultChannelConfig
implements UdtChannelConfig {
    private static final int K = 1024;
    private static final int M = 0x100000;
    private volatile int protocolReceiveBufferSize = 0xA00000;
    private volatile int protocolSendBufferSize = 0xA00000;
    private volatile int systemReceiveBufferSize = 0x100000;
    private volatile int systemSendBufferSize = 0x100000;
    private volatile int allocatorReceiveBufferSize = 131072;
    private volatile int allocatorSendBufferSize = 131072;
    private volatile int soLinger;
    private volatile boolean reuseAddress = true;

    public DefaultUdtChannelConfig(UdtChannel udtChannel, ChannelUDT channelUDT, boolean bl) {
        super(udtChannel);
        if (bl) {
            this.apply(channelUDT);
        }
    }

    protected void apply(ChannelUDT channelUDT) {
        channelUDT = channelUDT.socketUDT();
        channelUDT.setReuseAddress(this.isReuseAddress());
        channelUDT.setSendBufferSize(this.getSendBufferSize());
        if (this.getSoLinger() <= 0) {
            channelUDT.setSoLinger(false, 0);
        } else {
            channelUDT.setSoLinger(true, this.getSoLinger());
        }
        channelUDT.setOption(OptionUDT.Protocol_Receive_Buffer_Size, (Object)this.getProtocolReceiveBufferSize());
        channelUDT.setOption(OptionUDT.Protocol_Send_Buffer_Size, (Object)this.getProtocolSendBufferSize());
        channelUDT.setOption(OptionUDT.System_Receive_Buffer_Size, (Object)this.getSystemReceiveBufferSize());
        channelUDT.setOption(OptionUDT.System_Send_Buffer_Size, (Object)this.getSystemSendBufferSize());
    }

    @Override
    public int getProtocolReceiveBufferSize() {
        return this.protocolReceiveBufferSize;
    }

    @Override
    public <T> T getOption(ChannelOption<T> channelOption) {
        if (channelOption == UdtChannelOption.PROTOCOL_RECEIVE_BUFFER_SIZE) {
            return (T)Integer.valueOf(this.getProtocolReceiveBufferSize());
        }
        if (channelOption == UdtChannelOption.PROTOCOL_SEND_BUFFER_SIZE) {
            return (T)Integer.valueOf(this.getProtocolSendBufferSize());
        }
        if (channelOption == UdtChannelOption.SYSTEM_RECEIVE_BUFFER_SIZE) {
            return (T)Integer.valueOf(this.getSystemReceiveBufferSize());
        }
        if (channelOption == UdtChannelOption.SYSTEM_SEND_BUFFER_SIZE) {
            return (T)Integer.valueOf(this.getSystemSendBufferSize());
        }
        if (channelOption == UdtChannelOption.SO_RCVBUF) {
            return (T)Integer.valueOf(this.getReceiveBufferSize());
        }
        if (channelOption == UdtChannelOption.SO_SNDBUF) {
            return (T)Integer.valueOf(this.getSendBufferSize());
        }
        if (channelOption == UdtChannelOption.SO_REUSEADDR) {
            return (T)Boolean.valueOf(this.isReuseAddress());
        }
        if (channelOption == UdtChannelOption.SO_LINGER) {
            return (T)Integer.valueOf(this.getSoLinger());
        }
        return super.getOption(channelOption);
    }

    @Override
    public Map<ChannelOption<?>, Object> getOptions() {
        DefaultUdtChannelConfig defaultUdtChannelConfig = this;
        return defaultUdtChannelConfig.getOptions(super.getOptions(), UdtChannelOption.PROTOCOL_RECEIVE_BUFFER_SIZE, UdtChannelOption.PROTOCOL_SEND_BUFFER_SIZE, UdtChannelOption.SYSTEM_RECEIVE_BUFFER_SIZE, UdtChannelOption.SYSTEM_SEND_BUFFER_SIZE, UdtChannelOption.SO_RCVBUF, UdtChannelOption.SO_SNDBUF, UdtChannelOption.SO_REUSEADDR, UdtChannelOption.SO_LINGER);
    }

    @Override
    public int getReceiveBufferSize() {
        return this.allocatorReceiveBufferSize;
    }

    @Override
    public int getSendBufferSize() {
        return this.allocatorSendBufferSize;
    }

    @Override
    public int getSoLinger() {
        return this.soLinger;
    }

    @Override
    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    @Override
    public UdtChannelConfig setProtocolReceiveBufferSize(int n2) {
        this.protocolReceiveBufferSize = n2;
        return this;
    }

    @Override
    public <T> boolean setOption(ChannelOption<T> channelOption, T t2) {
        this.validate(channelOption, t2);
        if (channelOption == UdtChannelOption.PROTOCOL_RECEIVE_BUFFER_SIZE) {
            this.setProtocolReceiveBufferSize((Integer)t2);
        } else if (channelOption == UdtChannelOption.PROTOCOL_SEND_BUFFER_SIZE) {
            this.setProtocolSendBufferSize((Integer)t2);
        } else if (channelOption == UdtChannelOption.SYSTEM_RECEIVE_BUFFER_SIZE) {
            this.setSystemReceiveBufferSize((Integer)t2);
        } else if (channelOption == UdtChannelOption.SYSTEM_SEND_BUFFER_SIZE) {
            this.setSystemSendBufferSize((Integer)t2);
        } else if (channelOption == UdtChannelOption.SO_RCVBUF) {
            this.setReceiveBufferSize((Integer)t2);
        } else if (channelOption == UdtChannelOption.SO_SNDBUF) {
            this.setSendBufferSize((Integer)t2);
        } else if (channelOption == UdtChannelOption.SO_REUSEADDR) {
            this.setReuseAddress((Boolean)t2);
        } else if (channelOption == UdtChannelOption.SO_LINGER) {
            this.setSoLinger((Integer)t2);
        } else {
            return super.setOption(channelOption, t2);
        }
        return true;
    }

    @Override
    public UdtChannelConfig setReceiveBufferSize(int n2) {
        this.allocatorReceiveBufferSize = n2;
        return this;
    }

    @Override
    public UdtChannelConfig setReuseAddress(boolean bl) {
        this.reuseAddress = bl;
        return this;
    }

    @Override
    public UdtChannelConfig setSendBufferSize(int n2) {
        this.allocatorSendBufferSize = n2;
        return this;
    }

    @Override
    public UdtChannelConfig setSoLinger(int n2) {
        this.soLinger = n2;
        return this;
    }

    @Override
    public int getSystemReceiveBufferSize() {
        return this.systemReceiveBufferSize;
    }

    @Override
    public UdtChannelConfig setSystemSendBufferSize(int n2) {
        this.systemReceiveBufferSize = n2;
        return this;
    }

    @Override
    public int getProtocolSendBufferSize() {
        return this.protocolSendBufferSize;
    }

    @Override
    public UdtChannelConfig setProtocolSendBufferSize(int n2) {
        this.protocolSendBufferSize = n2;
        return this;
    }

    @Override
    public UdtChannelConfig setSystemReceiveBufferSize(int n2) {
        this.systemSendBufferSize = n2;
        return this;
    }

    @Override
    public int getSystemSendBufferSize() {
        return this.systemSendBufferSize;
    }

    @Override
    public UdtChannelConfig setConnectTimeoutMillis(int n2) {
        super.setConnectTimeoutMillis(n2);
        return this;
    }

    @Override
    public UdtChannelConfig setMaxMessagesPerRead(int n2) {
        super.setMaxMessagesPerRead(n2);
        return this;
    }

    @Override
    public UdtChannelConfig setWriteSpinCount(int n2) {
        super.setWriteSpinCount(n2);
        return this;
    }

    @Override
    public UdtChannelConfig setAllocator(ByteBufAllocator byteBufAllocator) {
        super.setAllocator(byteBufAllocator);
        return this;
    }

    @Override
    public UdtChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator recvByteBufAllocator) {
        super.setRecvByteBufAllocator(recvByteBufAllocator);
        return this;
    }

    @Override
    public UdtChannelConfig setAutoRead(boolean bl) {
        super.setAutoRead(bl);
        return this;
    }

    @Override
    public UdtChannelConfig setAutoClose(boolean bl) {
        super.setAutoClose(bl);
        return this;
    }

    @Override
    public UdtChannelConfig setWriteBufferLowWaterMark(int n2) {
        super.setWriteBufferLowWaterMark(n2);
        return this;
    }

    @Override
    public UdtChannelConfig setWriteBufferHighWaterMark(int n2) {
        super.setWriteBufferHighWaterMark(n2);
        return this;
    }

    @Override
    public UdtChannelConfig setMessageSizeEstimator(MessageSizeEstimator messageSizeEstimator) {
        super.setMessageSizeEstimator(messageSizeEstimator);
        return this;
    }
}

