/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.udt.nio;

import com.aliyun.openservices.shade.io.netty.channel.ChannelException;
import com.aliyun.openservices.shade.io.netty.channel.ChannelMetadata;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundBuffer;
import com.aliyun.openservices.shade.io.netty.channel.nio.AbstractNioMessageChannel;
import com.aliyun.openservices.shade.io.netty.channel.udt.DefaultUdtServerChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.udt.UdtChannel;
import com.aliyun.openservices.shade.io.netty.channel.udt.UdtServerChannel;
import com.aliyun.openservices.shade.io.netty.channel.udt.UdtServerChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.udt.nio.NioUdtProvider;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import com.barchart.udt.TypeUDT;
import com.barchart.udt.nio.ChannelUDT;
import com.barchart.udt.nio.ServerSocketChannelUDT;
import com.barchart.udt.nio.SocketChannelUDT;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.util.List;

public abstract class NioUdtAcceptorChannel
extends AbstractNioMessageChannel
implements UdtServerChannel {
    protected static final InternalLogger logger = InternalLoggerFactory.getInstance(NioUdtAcceptorChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private final UdtServerChannelConfig config;

    protected NioUdtAcceptorChannel(ServerSocketChannelUDT serverSocketChannelUDT) {
        super(null, (SelectableChannel)serverSocketChannelUDT, 16);
        try {
            serverSocketChannelUDT.configureBlocking(false);
            this.config = new DefaultUdtServerChannelConfig(this, (ChannelUDT)serverSocketChannelUDT, true);
            return;
        }
        catch (Exception exception) {
            block4: {
                try {
                    serverSocketChannelUDT.close();
                }
                catch (Exception exception2) {
                    if (!logger.isWarnEnabled()) break block4;
                    logger.warn("Failed to close channel.", exception2);
                }
            }
            throw new ChannelException("Failed to configure channel.", exception);
        }
    }

    protected NioUdtAcceptorChannel(TypeUDT typeUDT) {
        this(NioUdtProvider.newAcceptorChannelUDT(typeUDT));
    }

    @Override
    public UdtServerChannelConfig config() {
        return this.config;
    }

    @Override
    public void doBind(SocketAddress socketAddress) {
        this.javaChannel().socket().bind(socketAddress, this.config.getBacklog());
    }

    @Override
    public void doClose() {
        this.javaChannel().close();
    }

    @Override
    public boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void doDisconnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void doFinishConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean doWriteMessage(Object object, ChannelOutboundBuffer channelOutboundBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Object filterOutboundMessage(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isActive() {
        return this.javaChannel().socket().isBound();
    }

    protected ServerSocketChannelUDT javaChannel() {
        return (ServerSocketChannelUDT)super.javaChannel();
    }

    @Override
    public SocketAddress localAddress0() {
        return this.javaChannel().socket().getLocalSocketAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return null;
    }

    @Override
    public SocketAddress remoteAddress0() {
        return null;
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public int doReadMessages(List<Object> list) {
        SocketChannelUDT socketChannelUDT = this.javaChannel().accept();
        if (socketChannelUDT == null) {
            return 0;
        }
        list.add(this.newConnectorChannel(socketChannelUDT));
        return 1;
    }

    protected abstract UdtChannel newConnectorChannel(SocketChannelUDT var1);
}

