/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.udt.nio;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelException;
import com.aliyun.openservices.shade.io.netty.channel.ChannelMetadata;
import com.aliyun.openservices.shade.io.netty.channel.FileRegion;
import com.aliyun.openservices.shade.io.netty.channel.nio.AbstractNioByteChannel;
import com.aliyun.openservices.shade.io.netty.channel.nio.AbstractNioChannel;
import com.aliyun.openservices.shade.io.netty.channel.udt.DefaultUdtChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.udt.UdtChannel;
import com.aliyun.openservices.shade.io.netty.channel.udt.UdtChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.udt.nio.NioUdtProvider;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import com.barchart.udt.TypeUDT;
import com.barchart.udt.nio.ChannelUDT;
import com.barchart.udt.nio.SocketChannelUDT;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SelectableChannel;

public class NioUdtByteConnectorChannel
extends AbstractNioByteChannel
implements UdtChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioUdtByteConnectorChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private final UdtChannelConfig config;

    public NioUdtByteConnectorChannel() {
        this(TypeUDT.STREAM);
    }

    public NioUdtByteConnectorChannel(Channel channel, SocketChannelUDT socketChannelUDT) {
        super(channel, (SelectableChannel)socketChannelUDT);
        try {
            socketChannelUDT.configureBlocking(false);
            switch (socketChannelUDT.socketUDT().status()) {
                case INIT: 
                case OPENED: {
                    this.config = new DefaultUdtChannelConfig(this, (ChannelUDT)socketChannelUDT, true);
                    break;
                }
                default: {
                    this.config = new DefaultUdtChannelConfig(this, (ChannelUDT)socketChannelUDT, false);
                    return;
                }
            }
        }
        catch (Exception exception) {
            block8: {
                try {
                    socketChannelUDT.close();
                }
                catch (Exception exception2) {
                    if (!logger.isWarnEnabled()) break block8;
                    logger.warn("Failed to close channel.", exception2);
                }
            }
            throw new ChannelException("Failed to configure channel.", exception);
        }
    }

    public NioUdtByteConnectorChannel(SocketChannelUDT socketChannelUDT) {
        this(null, socketChannelUDT);
    }

    public NioUdtByteConnectorChannel(TypeUDT typeUDT) {
        this(NioUdtProvider.newConnectorChannelUDT(typeUDT));
    }

    @Override
    public UdtChannelConfig config() {
        return this.config;
    }

    @Override
    public void doBind(SocketAddress socketAddress) {
        this.javaChannel().bind(socketAddress);
    }

    @Override
    public void doClose() {
        this.javaChannel().close();
    }

    @Override
    public boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        this.doBind(socketAddress2 != null ? socketAddress2 : new InetSocketAddress(0));
        boolean bl = false;
        try {
            boolean bl2 = this.javaChannel().connect(socketAddress);
            if (!bl2) {
                this.selectionKey().interestOps(this.selectionKey().interestOps() | 8);
            }
            bl = true;
            return bl2;
        }
        catch (Throwable throwable) {
            if (!bl) {
                ((AbstractNioChannel)this).doClose();
            }
            throw throwable;
        }
    }

    @Override
    public void doDisconnect() {
        ((AbstractNioChannel)this).doClose();
    }

    @Override
    public void doFinishConnect() {
        if (this.javaChannel().finishConnect()) {
            this.selectionKey().interestOps(this.selectionKey().interestOps() & 0xFFFFFFF7);
            return;
        }
        throw new Error("Provider error: failed to finish connect. Provider library should be upgraded.");
    }

    @Override
    public int doReadBytes(ByteBuf byteBuf) {
        return byteBuf.writeBytes((ScatteringByteChannel)this.javaChannel(), byteBuf.writableBytes());
    }

    @Override
    public int doWriteBytes(ByteBuf byteBuf) {
        int n2 = byteBuf.readableBytes();
        return byteBuf.readBytes((GatheringByteChannel)this.javaChannel(), n2);
    }

    @Override
    public long doWriteFileRegion(FileRegion fileRegion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isActive() {
        SocketChannelUDT socketChannelUDT = this.javaChannel();
        return socketChannelUDT.isOpen() && socketChannelUDT.isConnectFinished();
    }

    protected SocketChannelUDT javaChannel() {
        return (SocketChannelUDT)super.javaChannel();
    }

    @Override
    public SocketAddress localAddress0() {
        return this.javaChannel().socket().getLocalSocketAddress();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public SocketAddress remoteAddress0() {
        return this.javaChannel().socket().getRemoteSocketAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }
}

