/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.udt.nio;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.DefaultByteBufHolder;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelException;
import com.aliyun.openservices.shade.io.netty.channel.ChannelMetadata;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundBuffer;
import com.aliyun.openservices.shade.io.netty.channel.nio.AbstractNioChannel;
import com.aliyun.openservices.shade.io.netty.channel.nio.AbstractNioMessageChannel;
import com.aliyun.openservices.shade.io.netty.channel.udt.DefaultUdtChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.udt.UdtChannel;
import com.aliyun.openservices.shade.io.netty.channel.udt.UdtChannelConfig;
import com.aliyun.openservices.shade.io.netty.channel.udt.UdtMessage;
import com.aliyun.openservices.shade.io.netty.channel.udt.nio.NioUdtProvider;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import com.barchart.udt.TypeUDT;
import com.barchart.udt.nio.ChannelUDT;
import com.barchart.udt.nio.SocketChannelUDT;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SelectableChannel;
import java.util.List;

public class NioUdtMessageConnectorChannel
extends AbstractNioMessageChannel
implements UdtChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioUdtMessageConnectorChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private static final String EXPECTED_TYPE = " (expected: " + StringUtil.simpleClassName(UdtMessage.class) + ')';
    private final UdtChannelConfig config;

    public NioUdtMessageConnectorChannel() {
        this(TypeUDT.DATAGRAM);
    }

    public NioUdtMessageConnectorChannel(Channel channel, SocketChannelUDT socketChannelUDT) {
        super(channel, (SelectableChannel)socketChannelUDT, 1);
        try {
            socketChannelUDT.configureBlocking(false);
            switch (socketChannelUDT.socketUDT().status()) {
                case INIT: 
                case OPENED: {
                    this.config = new DefaultUdtChannelConfig(this, (ChannelUDT)socketChannelUDT, true);
                    break;
                }
                default: {
                    this.config = new DefaultUdtChannelConfig(this, (ChannelUDT)socketChannelUDT, false);
                    return;
                }
            }
        }
        catch (Exception exception) {
            block8: {
                try {
                    socketChannelUDT.close();
                }
                catch (Exception exception2) {
                    if (!logger.isWarnEnabled()) break block8;
                    logger.warn("Failed to close channel.", exception2);
                }
            }
            throw new ChannelException("Failed to configure channel.", exception);
        }
    }

    public NioUdtMessageConnectorChannel(SocketChannelUDT socketChannelUDT) {
        this(null, socketChannelUDT);
    }

    public NioUdtMessageConnectorChannel(TypeUDT typeUDT) {
        this(NioUdtProvider.newConnectorChannelUDT(typeUDT));
    }

    @Override
    public UdtChannelConfig config() {
        return this.config;
    }

    @Override
    public void doBind(SocketAddress socketAddress) {
        this.javaChannel().bind(socketAddress);
    }

    @Override
    public void doClose() {
        this.javaChannel().close();
    }

    @Override
    public boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        this.doBind(socketAddress2 != null ? socketAddress2 : new InetSocketAddress(0));
        boolean bl = false;
        try {
            boolean bl2 = this.javaChannel().connect(socketAddress);
            if (!bl2) {
                this.selectionKey().interestOps(this.selectionKey().interestOps() | 8);
            }
            bl = true;
            return bl2;
        }
        catch (Throwable throwable) {
            if (!bl) {
                ((AbstractNioChannel)this).doClose();
            }
            throw throwable;
        }
    }

    @Override
    public void doDisconnect() {
        ((AbstractNioChannel)this).doClose();
    }

    @Override
    public void doFinishConnect() {
        if (this.javaChannel().finishConnect()) {
            this.selectionKey().interestOps(this.selectionKey().interestOps() & 0xFFFFFFF7);
            return;
        }
        throw new Error("Provider error: failed to finish connect. Provider library should be upgraded.");
    }

    @Override
    public int doReadMessages(List<Object> list) {
        int n2 = this.config.getReceiveBufferSize();
        ByteBuf byteBuf = this.config.getAllocator().directBuffer(n2);
        int n3 = byteBuf.writeBytes((ScatteringByteChannel)this.javaChannel(), n2);
        if (n3 <= 0) {
            byteBuf.release();
            return 0;
        }
        if (n3 >= n2) {
            this.javaChannel().close();
            throw new ChannelException("Invalid config : increase receive buffer size to avoid message truncation");
        }
        list.add(new UdtMessage(byteBuf));
        return 1;
    }

    @Override
    public boolean doWriteMessage(Object object, ChannelOutboundBuffer channelOutboundBuffer) {
        object = (UdtMessage)object;
        int n2 = ((ByteBuf)(object = ((DefaultByteBufHolder)object).content())).readableBytes();
        if (n2 == 0) {
            return true;
        }
        long l2 = ((ByteBuf)object).nioBufferCount() == 1 ? (long)this.javaChannel().write(((ByteBuf)object).nioBuffer()) : this.javaChannel().write(((ByteBuf)object).nioBuffers());
        if (l2 > 0L && l2 != (long)n2) {
            throw new Error("Provider error: failed to write message. Provider library should be upgraded.");
        }
        return l2 > 0L;
    }

    @Override
    public final Object filterOutboundMessage(Object object) {
        if (object instanceof UdtMessage) {
            return object;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(object) + EXPECTED_TYPE);
    }

    @Override
    public boolean isActive() {
        SocketChannelUDT socketChannelUDT = this.javaChannel();
        return socketChannelUDT.isOpen() && socketChannelUDT.isConnectFinished();
    }

    protected SocketChannelUDT javaChannel() {
        return (SocketChannelUDT)super.javaChannel();
    }

    @Override
    public SocketAddress localAddress0() {
        return this.javaChannel().socket().getLocalSocketAddress();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public SocketAddress remoteAddress0() {
        return this.javaChannel().socket().getRemoteSocketAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }
}

