/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.unix;

import com.aliyun.openservices.shade.io.netty.channel.unix.Errors$NativeConnectException;
import com.aliyun.openservices.shade.io.netty.channel.unix.Errors$NativeIoException;
import com.aliyun.openservices.shade.io.netty.channel.unix.ErrorsStaticallyReferencedJniMethods;
import com.aliyun.openservices.shade.io.netty.util.internal.EmptyArrays;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NotYetConnectedException;

public final class Errors {
    public static final int ERRNO_ENOTCONN_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoENOTCONN();
    public static final int ERRNO_EBADF_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEBADF();
    public static final int ERRNO_EPIPE_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEPIPE();
    public static final int ERRNO_ECONNRESET_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoECONNRESET();
    public static final int ERRNO_EAGAIN_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEAGAIN();
    public static final int ERRNO_EWOULDBLOCK_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEWOULDBLOCK();
    public static final int ERRNO_EINPROGRESS_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEINPROGRESS();
    public static final int ERROR_ECONNREFUSED_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errorECONNREFUSED();
    public static final int ERROR_EISCONN_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errorEISCONN();
    public static final int ERROR_EALREADY_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errorEALREADY();
    public static final int ERROR_ENETUNREACH_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errorENETUNREACH();
    private static final String[] ERRORS = new String[512];

    static void throwConnectException(String string, Errors$NativeConnectException errors$NativeConnectException, int n2) {
        if (n2 == errors$NativeConnectException.expectedErr()) {
            throw errors$NativeConnectException;
        }
        if (n2 == ERROR_EALREADY_NEGATIVE) {
            throw new ConnectionPendingException();
        }
        if (n2 == ERROR_ENETUNREACH_NEGATIVE) {
            throw new NoRouteToHostException();
        }
        if (n2 == ERROR_EISCONN_NEGATIVE) {
            throw new AlreadyConnectedException();
        }
        throw new ConnectException(string + "() failed: " + ERRORS[-n2]);
    }

    public static Errors$NativeIoException newConnectionResetException(String object, int n2) {
        object = Errors.newIOException((String)object, n2);
        ((Throwable)object).setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
        return object;
    }

    public static Errors$NativeIoException newIOException(String string, int n2) {
        return new Errors$NativeIoException(string + "() failed: " + ERRORS[-n2], n2);
    }

    public static int ioResult(String string, int n2, Errors$NativeIoException errors$NativeIoException, ClosedChannelException closedChannelException) {
        if (n2 == ERRNO_EAGAIN_NEGATIVE || n2 == ERRNO_EWOULDBLOCK_NEGATIVE) {
            return 0;
        }
        if (n2 == errors$NativeIoException.expectedErr()) {
            throw errors$NativeIoException;
        }
        if (n2 == ERRNO_EBADF_NEGATIVE) {
            throw closedChannelException;
        }
        if (n2 == ERRNO_ENOTCONN_NEGATIVE) {
            throw new NotYetConnectedException();
        }
        throw Errors.newIOException(string, n2);
    }

    private Errors() {
    }

    static {
        int n2 = 0;
        while (n2 < ERRORS.length) {
            int n3 = n2++;
            Errors.ERRORS[n3] = ErrorsStaticallyReferencedJniMethods.strError(n3);
        }
    }
}

