/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.unix;

import com.aliyun.openservices.shade.io.netty.channel.unix.Errors;
import com.aliyun.openservices.shade.io.netty.channel.unix.Errors$NativeIoException;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.ThrowableUtil;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class FileDescriptor {
    private static final ClosedChannelException WRITE_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), FileDescriptor.class, "write(...)");
    private static final ClosedChannelException WRITE_ADDRESS_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), FileDescriptor.class, "writeAddress(...)");
    private static final ClosedChannelException WRITEV_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), FileDescriptor.class, "writev(...)");
    private static final ClosedChannelException WRITEV_ADDRESSES_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), FileDescriptor.class, "writevAddresses(...)");
    private static final ClosedChannelException READ_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), FileDescriptor.class, "read(...)");
    private static final ClosedChannelException READ_ADDRESS_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), FileDescriptor.class, "readAddress(...)");
    private static final Errors$NativeIoException WRITE_CONNECTION_RESET_EXCEPTION = ThrowableUtil.unknownStackTrace(Errors.newConnectionResetException("syscall:write(...)", Errors.ERRNO_EPIPE_NEGATIVE), FileDescriptor.class, "write(...)");
    private static final Errors$NativeIoException WRITE_ADDRESS_CONNECTION_RESET_EXCEPTION = ThrowableUtil.unknownStackTrace(Errors.newConnectionResetException("syscall:write(...)", Errors.ERRNO_EPIPE_NEGATIVE), FileDescriptor.class, "writeAddress(...)");
    private static final Errors$NativeIoException WRITEV_CONNECTION_RESET_EXCEPTION = ThrowableUtil.unknownStackTrace(Errors.newConnectionResetException("syscall:writev(...)", Errors.ERRNO_EPIPE_NEGATIVE), FileDescriptor.class, "writev(...)");
    private static final Errors$NativeIoException WRITEV_ADDRESSES_CONNECTION_RESET_EXCEPTION = ThrowableUtil.unknownStackTrace(Errors.newConnectionResetException("syscall:writev(...)", Errors.ERRNO_EPIPE_NEGATIVE), FileDescriptor.class, "writeAddresses(...)");
    private static final Errors$NativeIoException READ_CONNECTION_RESET_EXCEPTION = ThrowableUtil.unknownStackTrace(Errors.newConnectionResetException("syscall:read(...)", Errors.ERRNO_ECONNRESET_NEGATIVE), FileDescriptor.class, "read(...)");
    private static final Errors$NativeIoException READ_ADDRESS_CONNECTION_RESET_EXCEPTION = ThrowableUtil.unknownStackTrace(Errors.newConnectionResetException("syscall:read(...)", Errors.ERRNO_ECONNRESET_NEGATIVE), FileDescriptor.class, "readAddress(...)");
    private static final AtomicIntegerFieldUpdater<FileDescriptor> stateUpdater;
    private static final int STATE_CLOSED_MASK = 1;
    private static final int STATE_INPUT_SHUTDOWN_MASK = 2;
    private static final int STATE_OUTPUT_SHUTDOWN_MASK = 4;
    private static final int STATE_ALL_MASK = 7;
    volatile int state;
    final int fd;

    public FileDescriptor(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("fd must be >= 0");
        }
        this.fd = n2;
    }

    public int intValue() {
        return this.fd;
    }

    public void close() {
        int n2;
        int n3;
        do {
            if (FileDescriptor.isClosed(n2 = this.state)) {
                return;
            }
            n3 = n2;
        } while (!this.casState(n3, n3 | 7));
        n2 = FileDescriptor.close(this.fd);
        if (n2 < 0) {
            throw Errors.newIOException("close", n2);
        }
    }

    public boolean isOpen() {
        return !FileDescriptor.isClosed(this.state);
    }

    public final int write(ByteBuffer byteBuffer, int n2, int n3) {
        int n4 = FileDescriptor.write(this.fd, byteBuffer, n2, n3);
        if (n4 >= 0) {
            return n4;
        }
        return Errors.ioResult("write", n4, WRITE_CONNECTION_RESET_EXCEPTION, WRITE_CLOSED_CHANNEL_EXCEPTION);
    }

    public final int writeAddress(long l2, int n2, int n3) {
        int n4 = FileDescriptor.writeAddress(this.fd, l2, n2, n3);
        if (n4 >= 0) {
            return n4;
        }
        return Errors.ioResult("writeAddress", n4, WRITE_ADDRESS_CONNECTION_RESET_EXCEPTION, WRITE_ADDRESS_CLOSED_CHANNEL_EXCEPTION);
    }

    public final long writev(ByteBuffer[] byteBufferArray, int n2, int n3) {
        long l2 = FileDescriptor.writev(this.fd, byteBufferArray, n2, n3);
        if (l2 >= 0L) {
            return l2;
        }
        return Errors.ioResult("writev", (int)l2, WRITEV_CONNECTION_RESET_EXCEPTION, WRITEV_CLOSED_CHANNEL_EXCEPTION);
    }

    public final long writevAddresses(long l2, int n2) {
        long l3 = FileDescriptor.writevAddresses(this.fd, l2, n2);
        if (l3 >= 0L) {
            return l3;
        }
        return Errors.ioResult("writevAddresses", (int)l3, WRITEV_ADDRESSES_CONNECTION_RESET_EXCEPTION, WRITEV_ADDRESSES_CLOSED_CHANNEL_EXCEPTION);
    }

    public final int read(ByteBuffer byteBuffer, int n2, int n3) {
        int n4 = FileDescriptor.read(this.fd, byteBuffer, n2, n3);
        if (n4 > 0) {
            return n4;
        }
        if (n4 == 0) {
            return -1;
        }
        return Errors.ioResult("read", n4, READ_CONNECTION_RESET_EXCEPTION, READ_CLOSED_CHANNEL_EXCEPTION);
    }

    public final int readAddress(long l2, int n2, int n3) {
        int n4 = FileDescriptor.readAddress(this.fd, l2, n2, n3);
        if (n4 > 0) {
            return n4;
        }
        if (n4 == 0) {
            return -1;
        }
        return Errors.ioResult("readAddress", n4, READ_ADDRESS_CONNECTION_RESET_EXCEPTION, READ_ADDRESS_CLOSED_CHANNEL_EXCEPTION);
    }

    public String toString() {
        return "FileDescriptor{fd=" + this.fd + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FileDescriptor)) {
            return false;
        }
        return this.fd == ((FileDescriptor)object).fd;
    }

    public int hashCode() {
        return this.fd;
    }

    public static FileDescriptor from(String string) {
        ObjectUtil.checkNotNull(string, "path");
        int n2 = FileDescriptor.open(string);
        if (n2 < 0) {
            throw Errors.newIOException("open", n2);
        }
        return new FileDescriptor(n2);
    }

    public static FileDescriptor from(File file) {
        return FileDescriptor.from(ObjectUtil.checkNotNull(file, "file").getPath());
    }

    public static FileDescriptor[] pipe() {
        long l2 = FileDescriptor.newPipe();
        if (l2 < 0L) {
            throw Errors.newIOException("newPipe", (int)l2);
        }
        return new FileDescriptor[]{new FileDescriptor((int)(l2 >>> 32)), new FileDescriptor((int)l2)};
    }

    final boolean casState(int n2, int n3) {
        return stateUpdater.compareAndSet(this, n2, n3);
    }

    static boolean isClosed(int n2) {
        return (n2 & 1) != 0;
    }

    static boolean isInputShutdown(int n2) {
        return (n2 & 2) != 0;
    }

    static boolean isOutputShutdown(int n2) {
        return (n2 & 4) != 0;
    }

    static int inputShutdown(int n2) {
        return n2 | 2;
    }

    static int outputShutdown(int n2) {
        return n2 | 4;
    }

    private static native int open(String var0);

    private static native int close(int var0);

    private static native int write(int var0, ByteBuffer var1, int var2, int var3);

    private static native int writeAddress(int var0, long var1, int var3, int var4);

    private static native long writev(int var0, ByteBuffer[] var1, int var2, int var3);

    private static native long writevAddresses(int var0, long var1, int var3);

    private static native int read(int var0, ByteBuffer var1, int var2, int var3);

    private static native int readAddress(int var0, long var1, int var3, int var4);

    private static native long newPipe();

    static {
        AtomicIntegerFieldUpdater<FileDescriptor> atomicIntegerFieldUpdater = PlatformDependent.newAtomicIntegerFieldUpdater(FileDescriptor.class, "state");
        if (atomicIntegerFieldUpdater == null) {
            atomicIntegerFieldUpdater = AtomicIntegerFieldUpdater.newUpdater(FileDescriptor.class, "state");
        }
        stateUpdater = atomicIntegerFieldUpdater;
    }
}

