/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.unix;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public final class NativeInetAddress {
    private static final byte[] IPV4_MAPPED_IPV6_PREFIX = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1};
    final byte[] address;
    final int scopeId;

    public static NativeInetAddress newInstance(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        if (inetAddress instanceof Inet6Address) {
            return new NativeInetAddress(byArray, ((Inet6Address)inetAddress).getScopeId());
        }
        return new NativeInetAddress(NativeInetAddress.ipv4MappedIpv6Address(byArray));
    }

    public NativeInetAddress(byte[] byArray, int n2) {
        this.address = byArray;
        this.scopeId = n2;
    }

    public NativeInetAddress(byte[] byArray) {
        this(byArray, 0);
    }

    public final byte[] address() {
        return this.address;
    }

    public final int scopeId() {
        return this.scopeId;
    }

    public static byte[] ipv4MappedIpv6Address(byte[] byArray) {
        byte[] byArray2 = new byte[16];
        System.arraycopy(IPV4_MAPPED_IPV6_PREFIX, 0, byArray2, 0, IPV4_MAPPED_IPV6_PREFIX.length);
        System.arraycopy(byArray, 0, byArray2, 12, byArray.length);
        return byArray2;
    }

    public static InetSocketAddress address(byte[] object, int n2, int n3) {
        int n4 = NativeInetAddress.decodeInt(object, n2 + n3 - 4);
        try {
            switch (n3) {
                case 8: {
                    byte[] byArray = new byte[4];
                    System.arraycopy(object, n2, byArray, 0, 4);
                    object = InetAddress.getByAddress(byArray);
                    break;
                }
                case 24: {
                    byte[] byArray = new byte[16];
                    System.arraycopy(object, n2, byArray, 0, 16);
                    int n5 = NativeInetAddress.decodeInt(object, n2 + n3 - 8);
                    object = Inet6Address.getByAddress(null, byArray, n5);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            return new InetSocketAddress((InetAddress)object, n4);
        }
        catch (UnknownHostException unknownHostException) {
            throw new Error("Should never happen", unknownHostException);
        }
    }

    static int decodeInt(byte[] byArray, int n2) {
        return (byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }
}

