/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.channel.unix;

import com.aliyun.openservices.shade.io.netty.channel.ChannelException;
import com.aliyun.openservices.shade.io.netty.channel.unix.DatagramSocketAddress;
import com.aliyun.openservices.shade.io.netty.channel.unix.DomainSocketAddress;
import com.aliyun.openservices.shade.io.netty.channel.unix.Errors;
import com.aliyun.openservices.shade.io.netty.channel.unix.Errors$NativeConnectException;
import com.aliyun.openservices.shade.io.netty.channel.unix.Errors$NativeIoException;
import com.aliyun.openservices.shade.io.netty.channel.unix.FileDescriptor;
import com.aliyun.openservices.shade.io.netty.channel.unix.NativeInetAddress;
import com.aliyun.openservices.shade.io.netty.util.CharsetUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.ThrowableUtil;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;

public final class Socket
extends FileDescriptor {
    private static final ClosedChannelException SHUTDOWN_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), Socket.class, "shutdown(...)");
    private static final ClosedChannelException SEND_TO_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), Socket.class, "sendTo(...)");
    private static final ClosedChannelException SEND_TO_ADDRESS_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), Socket.class, "sendToAddress(...)");
    private static final ClosedChannelException SEND_TO_ADDRESSES_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), Socket.class, "sendToAddresses(...)");
    private static final Errors$NativeIoException SEND_TO_CONNECTION_RESET_EXCEPTION = ThrowableUtil.unknownStackTrace(Errors.newConnectionResetException("syscall:sendto(...)", Errors.ERRNO_EPIPE_NEGATIVE), Socket.class, "sendTo(...)");
    private static final Errors$NativeIoException SEND_TO_ADDRESS_CONNECTION_RESET_EXCEPTION = ThrowableUtil.unknownStackTrace(Errors.newConnectionResetException("syscall:sendto(...)", Errors.ERRNO_EPIPE_NEGATIVE), Socket.class, "sendToAddress(...)");
    private static final Errors$NativeIoException CONNECTION_RESET_EXCEPTION_SENDMSG = ThrowableUtil.unknownStackTrace(Errors.newConnectionResetException("syscall:sendmsg(...)", Errors.ERRNO_EPIPE_NEGATIVE), Socket.class, "sendToAddresses(...)");
    private static final Errors$NativeIoException CONNECTION_RESET_SHUTDOWN_EXCEPTION = ThrowableUtil.unknownStackTrace(Errors.newConnectionResetException("syscall:shutdown(...)", Errors.ERRNO_ECONNRESET_NEGATIVE), Socket.class, "shutdown(...)");
    private static final Errors$NativeConnectException FINISH_CONNECT_REFUSED_EXCEPTION = ThrowableUtil.unknownStackTrace(new Errors$NativeConnectException("syscall:getsockopt(...)", Errors.ERROR_ECONNREFUSED_NEGATIVE), Socket.class, "finishConnect(...)");
    private static final Errors$NativeConnectException CONNECT_REFUSED_EXCEPTION = ThrowableUtil.unknownStackTrace(new Errors$NativeConnectException("syscall:connect(...)", Errors.ERROR_ECONNREFUSED_NEGATIVE), Socket.class, "connect(...)");

    public Socket(int n2) {
        super(n2);
    }

    public final void shutdown() {
        this.shutdown(true, true);
    }

    public final void shutdown(boolean bl, boolean bl2) {
        int n2;
        int n3;
        do {
            if (Socket.isClosed(n3 = this.state)) {
                throw new ClosedChannelException();
            }
            n2 = n3;
            if (bl && !Socket.isInputShutdown(n3)) {
                n2 = Socket.inputShutdown(n3);
            }
            if (bl2 && !Socket.isOutputShutdown(n2)) {
                n2 = Socket.outputShutdown(n2);
            }
            if (n2 != n3) continue;
            return;
        } while (!this.casState(n3, n2));
        n3 = Socket.shutdown(this.fd, bl, bl2);
        if (n3 < 0) {
            Errors.ioResult("shutdown", n3, CONNECTION_RESET_SHUTDOWN_EXCEPTION, SHUTDOWN_CLOSED_CHANNEL_EXCEPTION);
        }
    }

    public final boolean isShutdown() {
        int n2 = this.state;
        return Socket.isInputShutdown(n2) && Socket.isOutputShutdown(n2);
    }

    public final boolean isInputShutdown() {
        return Socket.isInputShutdown(this.state);
    }

    public final boolean isOutputShutdown() {
        return Socket.isOutputShutdown(this.state);
    }

    public final int sendTo(ByteBuffer byteBuffer, int n2, int n3, InetAddress inetAddress, int n4) {
        int n5;
        byte[] byArray;
        if (inetAddress instanceof Inet6Address) {
            byArray = inetAddress.getAddress();
            n5 = ((Inet6Address)inetAddress).getScopeId();
        } else {
            n5 = 0;
            byArray = NativeInetAddress.ipv4MappedIpv6Address(inetAddress.getAddress());
        }
        int n6 = Socket.sendTo(this.fd, byteBuffer, n2, n3, byArray, n5, n4);
        if (n6 >= 0) {
            return n6;
        }
        return Errors.ioResult("sendTo", n6, SEND_TO_CONNECTION_RESET_EXCEPTION, SEND_TO_CLOSED_CHANNEL_EXCEPTION);
    }

    public final int sendToAddress(long l2, int n2, int n3, InetAddress inetAddress, int n4) {
        int n5;
        byte[] byArray;
        if (inetAddress instanceof Inet6Address) {
            byArray = inetAddress.getAddress();
            n5 = ((Inet6Address)inetAddress).getScopeId();
        } else {
            n5 = 0;
            byArray = NativeInetAddress.ipv4MappedIpv6Address(inetAddress.getAddress());
        }
        int n6 = Socket.sendToAddress(this.fd, l2, n2, n3, byArray, n5, n4);
        if (n6 >= 0) {
            return n6;
        }
        return Errors.ioResult("sendToAddress", n6, SEND_TO_ADDRESS_CONNECTION_RESET_EXCEPTION, SEND_TO_ADDRESS_CLOSED_CHANNEL_EXCEPTION);
    }

    public final int sendToAddresses(long l2, int n2, InetAddress inetAddress, int n3) {
        int n4;
        byte[] byArray;
        if (inetAddress instanceof Inet6Address) {
            byArray = inetAddress.getAddress();
            n4 = ((Inet6Address)inetAddress).getScopeId();
        } else {
            n4 = 0;
            byArray = NativeInetAddress.ipv4MappedIpv6Address(inetAddress.getAddress());
        }
        int n5 = Socket.sendToAddresses(this.fd, l2, n2, byArray, n4, n3);
        if (n5 >= 0) {
            return n5;
        }
        return Errors.ioResult("sendToAddresses", n5, CONNECTION_RESET_EXCEPTION_SENDMSG, SEND_TO_ADDRESSES_CLOSED_CHANNEL_EXCEPTION);
    }

    public final DatagramSocketAddress recvFrom(ByteBuffer byteBuffer, int n2, int n3) {
        return Socket.recvFrom(this.fd, byteBuffer, n2, n3);
    }

    public final DatagramSocketAddress recvFromAddress(long l2, int n2, int n3) {
        return Socket.recvFromAddress(this.fd, l2, n2, n3);
    }

    public final boolean connect(SocketAddress socketAddress) {
        int n2;
        if (socketAddress instanceof InetSocketAddress) {
            socketAddress = (InetSocketAddress)socketAddress;
            NativeInetAddress nativeInetAddress = NativeInetAddress.newInstance(((InetSocketAddress)socketAddress).getAddress());
            n2 = Socket.connect(this.fd, nativeInetAddress.address, nativeInetAddress.scopeId, ((InetSocketAddress)socketAddress).getPort());
        } else if (socketAddress instanceof DomainSocketAddress) {
            socketAddress = (DomainSocketAddress)socketAddress;
            n2 = Socket.connectDomainSocket(this.fd, ((DomainSocketAddress)socketAddress).path().getBytes(CharsetUtil.UTF_8));
        } else {
            throw new Error("Unexpected SocketAddress implementation " + socketAddress);
        }
        if (n2 < 0) {
            if (n2 == Errors.ERRNO_EINPROGRESS_NEGATIVE) {
                return false;
            }
            Errors.throwConnectException("connect", CONNECT_REFUSED_EXCEPTION, n2);
        }
        return true;
    }

    public final boolean finishConnect() {
        int n2 = Socket.finishConnect(this.fd);
        if (n2 < 0) {
            if (n2 == Errors.ERRNO_EINPROGRESS_NEGATIVE) {
                return false;
            }
            Errors.throwConnectException("finishConnect", FINISH_CONNECT_REFUSED_EXCEPTION, n2);
        }
        return true;
    }

    public final void bind(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            socketAddress = (InetSocketAddress)socketAddress;
            NativeInetAddress nativeInetAddress = NativeInetAddress.newInstance(((InetSocketAddress)socketAddress).getAddress());
            int n2 = Socket.bind(this.fd, nativeInetAddress.address, nativeInetAddress.scopeId, ((InetSocketAddress)socketAddress).getPort());
            if (n2 < 0) {
                throw Errors.newIOException("bind", n2);
            }
            return;
        }
        if (socketAddress instanceof DomainSocketAddress) {
            int n3 = Socket.bindDomainSocket(this.fd, ((DomainSocketAddress)(socketAddress = (DomainSocketAddress)socketAddress)).path().getBytes(CharsetUtil.UTF_8));
            if (n3 < 0) {
                throw Errors.newIOException("bind", n3);
            }
            return;
        }
        throw new Error("Unexpected SocketAddress implementation " + socketAddress);
    }

    public final void listen(int n2) {
        if ((n2 = Socket.listen(this.fd, n2)) < 0) {
            throw Errors.newIOException("listen", n2);
        }
    }

    public final int accept(byte[] byArray) {
        int n2 = Socket.accept(this.fd, byArray);
        if (n2 >= 0) {
            return n2;
        }
        if (n2 == Errors.ERRNO_EAGAIN_NEGATIVE || n2 == Errors.ERRNO_EWOULDBLOCK_NEGATIVE) {
            return -1;
        }
        throw Errors.newIOException("accept", n2);
    }

    public final InetSocketAddress remoteAddress() {
        byte[] byArray = Socket.remoteAddress(this.fd);
        if (byArray == null) {
            return null;
        }
        return NativeInetAddress.address(byArray, 0, byArray.length);
    }

    public final InetSocketAddress localAddress() {
        byte[] byArray = Socket.localAddress(this.fd);
        if (byArray == null) {
            return null;
        }
        return NativeInetAddress.address(byArray, 0, byArray.length);
    }

    public final int getReceiveBufferSize() {
        return Socket.getReceiveBufferSize(this.fd);
    }

    public final int getSendBufferSize() {
        return Socket.getSendBufferSize(this.fd);
    }

    public final boolean isKeepAlive() {
        return Socket.isKeepAlive(this.fd) != 0;
    }

    public final boolean isTcpNoDelay() {
        return Socket.isTcpNoDelay(this.fd) != 0;
    }

    public final boolean isTcpCork() {
        return Socket.isTcpCork(this.fd) != 0;
    }

    public final int getSoLinger() {
        return Socket.getSoLinger(this.fd);
    }

    public final int getTcpDeferAccept() {
        return Socket.getTcpDeferAccept(this.fd);
    }

    public final boolean isTcpQuickAck() {
        return Socket.isTcpQuickAck(this.fd) != 0;
    }

    public final int getSoError() {
        return Socket.getSoError(this.fd);
    }

    public final void setKeepAlive(boolean bl) {
        Socket.setKeepAlive(this.fd, bl ? 1 : 0);
    }

    public final void setReceiveBufferSize(int n2) {
        Socket.setReceiveBufferSize(this.fd, n2);
    }

    public final void setSendBufferSize(int n2) {
        Socket.setSendBufferSize(this.fd, n2);
    }

    public final void setTcpNoDelay(boolean bl) {
        Socket.setTcpNoDelay(this.fd, bl ? 1 : 0);
    }

    public final void setTcpCork(boolean bl) {
        Socket.setTcpCork(this.fd, bl ? 1 : 0);
    }

    public final void setSoLinger(int n2) {
        Socket.setSoLinger(this.fd, n2);
    }

    public final void setTcpDeferAccept(int n2) {
        Socket.setTcpDeferAccept(this.fd, n2);
    }

    public final void setTcpQuickAck(boolean bl) {
        Socket.setTcpQuickAck(this.fd, bl ? 1 : 0);
    }

    @Override
    public final String toString() {
        return "Socket{fd=" + this.fd + '}';
    }

    public static Socket newSocketStream() {
        int n2 = Socket.newSocketStreamFd();
        if (n2 < 0) {
            throw new ChannelException(Errors.newIOException("newSocketStream", n2));
        }
        return new Socket(n2);
    }

    public static Socket newSocketDgram() {
        int n2 = Socket.newSocketDgramFd();
        if (n2 < 0) {
            throw new ChannelException(Errors.newIOException("newSocketDgram", n2));
        }
        return new Socket(n2);
    }

    public static Socket newSocketDomain() {
        int n2 = Socket.newSocketDomainFd();
        if (n2 < 0) {
            throw new ChannelException(Errors.newIOException("newSocketDomain", n2));
        }
        return new Socket(n2);
    }

    private static native int shutdown(int var0, boolean var1, boolean var2);

    private static native int connect(int var0, byte[] var1, int var2, int var3);

    private static native int connectDomainSocket(int var0, byte[] var1);

    private static native int finishConnect(int var0);

    private static native int bind(int var0, byte[] var1, int var2, int var3);

    private static native int bindDomainSocket(int var0, byte[] var1);

    private static native int listen(int var0, int var1);

    private static native int accept(int var0, byte[] var1);

    private static native byte[] remoteAddress(int var0);

    private static native byte[] localAddress(int var0);

    private static native int sendTo(int var0, ByteBuffer var1, int var2, int var3, byte[] var4, int var5, int var6);

    private static native int sendToAddress(int var0, long var1, int var3, int var4, byte[] var5, int var6, int var7);

    private static native int sendToAddresses(int var0, long var1, int var3, byte[] var4, int var5, int var6);

    private static native DatagramSocketAddress recvFrom(int var0, ByteBuffer var1, int var2, int var3);

    private static native DatagramSocketAddress recvFromAddress(int var0, long var1, int var3, int var4);

    private static native int newSocketStreamFd();

    private static native int newSocketDgramFd();

    private static native int newSocketDomainFd();

    private static native int getReceiveBufferSize(int var0);

    private static native int getSendBufferSize(int var0);

    private static native int isKeepAlive(int var0);

    private static native int isTcpNoDelay(int var0);

    private static native int isTcpCork(int var0);

    private static native int getSoLinger(int var0);

    private static native int getSoError(int var0);

    private static native int getTcpDeferAccept(int var0);

    private static native int isTcpQuickAck(int var0);

    private static native void setKeepAlive(int var0, int var1);

    private static native void setReceiveBufferSize(int var0, int var1);

    private static native void setSendBufferSize(int var0, int var1);

    private static native void setTcpNoDelay(int var0, int var1);

    private static native void setTcpCork(int var0, int var1);

    private static native void setSoLinger(int var0, int var1);

    private static native void setTcpDeferAccept(int var0, int var1);

    private static native void setTcpQuickAck(int var0, int var1);
}

