/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelInboundHandlerAdapter;
import com.aliyun.openservices.shade.io.netty.channel.socket.ChannelInputShutdownEvent;
import com.aliyun.openservices.shade.io.netty.handler.codec.ByteToMessageDecoder$1;
import com.aliyun.openservices.shade.io.netty.handler.codec.ByteToMessageDecoder$2;
import com.aliyun.openservices.shade.io.netty.handler.codec.ByteToMessageDecoder$Cumulator;
import com.aliyun.openservices.shade.io.netty.handler.codec.CodecOutputList;
import com.aliyun.openservices.shade.io.netty.handler.codec.CodecUtil;
import com.aliyun.openservices.shade.io.netty.handler.codec.DecoderException;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import java.util.List;

public abstract class ByteToMessageDecoder
extends ChannelInboundHandlerAdapter {
    public static final ByteToMessageDecoder$Cumulator MERGE_CUMULATOR = new ByteToMessageDecoder$1();
    public static final ByteToMessageDecoder$Cumulator COMPOSITE_CUMULATOR = new ByteToMessageDecoder$2();
    ByteBuf cumulation;
    private ByteToMessageDecoder$Cumulator cumulator = MERGE_CUMULATOR;
    private boolean singleDecode;
    private boolean decodeWasNull;
    private boolean first;
    private int discardAfterReads = 16;
    private int numReads;

    public ByteToMessageDecoder() {
        CodecUtil.ensureNotSharable(this);
    }

    public void setSingleDecode(boolean bl) {
        this.singleDecode = bl;
    }

    public boolean isSingleDecode() {
        return this.singleDecode;
    }

    public void setCumulator(ByteToMessageDecoder$Cumulator byteToMessageDecoder$Cumulator) {
        if (byteToMessageDecoder$Cumulator == null) {
            throw new NullPointerException("cumulator");
        }
        this.cumulator = byteToMessageDecoder$Cumulator;
    }

    public void setDiscardAfterReads(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("discardAfterReads must be > 0");
        }
        this.discardAfterReads = n2;
    }

    protected int actualReadableBytes() {
        return this.internalBuffer().readableBytes();
    }

    protected ByteBuf internalBuffer() {
        if (this.cumulation != null) {
            return this.cumulation;
        }
        return Unpooled.EMPTY_BUFFER;
    }

    @Override
    public final void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        ByteBuf byteBuf = this.cumulation;
        if (byteBuf != null) {
            this.cumulation = null;
            int n2 = byteBuf.readableBytes();
            if (n2 > 0) {
                ByteBuf byteBuf2 = byteBuf.readBytes(n2);
                byteBuf.release();
                channelHandlerContext.fireChannelRead(byteBuf2);
            } else {
                byteBuf.release();
            }
            this.numReads = 0;
            channelHandlerContext.fireChannelReadComplete();
        }
        this.handlerRemoved0(channelHandlerContext);
    }

    public void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (!(object instanceof ByteBuf)) {
            channelHandlerContext.fireChannelRead(object);
            return;
        }
        CodecOutputList codecOutputList = CodecOutputList.newInstance();
        try {
            object = (ByteBuf)object;
            this.first = this.cumulation == null;
            this.cumulation = this.first ? object : this.cumulator.cumulate(channelHandlerContext.alloc(), this.cumulation, (ByteBuf)object);
            this.callDecode(channelHandlerContext, this.cumulation, codecOutputList);
        }
        catch (DecoderException decoderException) {
            try {
                object = decoderException;
                throw decoderException;
                catch (Throwable throwable) {
                    throw new DecoderException(throwable);
                }
            }
            catch (Throwable throwable) {
                if (this.cumulation != null && !this.cumulation.isReadable()) {
                    this.numReads = 0;
                    this.cumulation.release();
                    this.cumulation = null;
                } else if (++this.numReads >= this.discardAfterReads) {
                    this.numReads = 0;
                    this.discardSomeReadBytes();
                }
                int n2 = codecOutputList.size();
                this.decodeWasNull = !codecOutputList.insertSinceRecycled();
                ByteToMessageDecoder.fireChannelRead(channelHandlerContext, codecOutputList, n2);
                codecOutputList.recycle();
                throw throwable;
            }
        }
        if (this.cumulation != null && !this.cumulation.isReadable()) {
            this.numReads = 0;
            this.cumulation.release();
            this.cumulation = null;
        } else if (++this.numReads >= this.discardAfterReads) {
            this.numReads = 0;
            this.discardSomeReadBytes();
        }
        int n3 = codecOutputList.size();
        this.decodeWasNull = !codecOutputList.insertSinceRecycled();
        ByteToMessageDecoder.fireChannelRead(channelHandlerContext, codecOutputList, n3);
        codecOutputList.recycle();
        return;
    }

    static void fireChannelRead(ChannelHandlerContext channelHandlerContext, List<Object> list, int n2) {
        if (list instanceof CodecOutputList) {
            ByteToMessageDecoder.fireChannelRead(channelHandlerContext, (CodecOutputList)list, n2);
            return;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            channelHandlerContext.fireChannelRead(list.get(i2));
        }
    }

    static void fireChannelRead(ChannelHandlerContext channelHandlerContext, CodecOutputList codecOutputList, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            channelHandlerContext.fireChannelRead(codecOutputList.getUnsafe(i2));
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        this.numReads = 0;
        this.discardSomeReadBytes();
        if (this.decodeWasNull) {
            this.decodeWasNull = false;
            if (!channelHandlerContext.channel().config().isAutoRead()) {
                channelHandlerContext.read();
            }
        }
        channelHandlerContext.fireChannelReadComplete();
    }

    protected final void discardSomeReadBytes() {
        if (this.cumulation != null && !this.first && this.cumulation.refCnt() == 1) {
            this.cumulation.discardSomeReadBytes();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.channelInputClosed(channelHandlerContext, true);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof ChannelInputShutdownEvent) {
            this.channelInputClosed(channelHandlerContext, false);
        }
        super.userEventTriggered(channelHandlerContext, object);
    }

    private void channelInputClosed(ChannelHandlerContext channelHandlerContext, boolean bl) {
        CodecOutputList codecOutputList = CodecOutputList.newInstance();
        try {
            this.channelInputClosed(channelHandlerContext, codecOutputList);
        }
        catch (DecoderException decoderException) {
            DecoderException decoderException2 = decoderException;
            throw decoderException;
        }
        catch (Exception exception) {
            throw new DecoderException(exception);
        }
        finally {
            try {
                if (this.cumulation != null) {
                    this.cumulation.release();
                    this.cumulation = null;
                }
                int n2 = codecOutputList.size();
                ByteToMessageDecoder.fireChannelRead(channelHandlerContext, codecOutputList, n2);
                if (n2 > 0) {
                    channelHandlerContext.fireChannelReadComplete();
                }
                if (bl) {
                    channelHandlerContext.fireChannelInactive();
                }
            }
            finally {
                codecOutputList.recycle();
            }
        }
    }

    void channelInputClosed(ChannelHandlerContext channelHandlerContext, List<Object> list) {
        if (this.cumulation != null) {
            this.callDecode(channelHandlerContext, this.cumulation, list);
            this.decodeLast(channelHandlerContext, this.cumulation, list);
            return;
        }
        this.decodeLast(channelHandlerContext, Unpooled.EMPTY_BUFFER, list);
    }

    protected void callDecode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        block7: {
            try {
                while (byteBuf.isReadable()) {
                    int n2 = list.size();
                    if (n2 > 0) {
                        ByteToMessageDecoder.fireChannelRead(channelHandlerContext, list, n2);
                        list.clear();
                        if (channelHandlerContext.isRemoved()) break;
                        n2 = 0;
                    }
                    int n3 = byteBuf.readableBytes();
                    this.decode(channelHandlerContext, byteBuf, list);
                    if (channelHandlerContext.isRemoved()) break;
                    if (n2 == list.size()) {
                        if (n3 != byteBuf.readableBytes()) continue;
                        break block7;
                    }
                    if (n3 == byteBuf.readableBytes()) {
                        throw new DecoderException(StringUtil.simpleClassName(this.getClass()) + ".decode() did not read anything but decoded a message.");
                    }
                    if (!this.isSingleDecode()) continue;
                }
                return;
            }
            catch (DecoderException decoderException) {
                DecoderException decoderException2 = decoderException;
                throw decoderException;
            }
            catch (Throwable throwable) {
                throw new DecoderException(throwable);
            }
        }
    }

    protected abstract void decode(ChannelHandlerContext var1, ByteBuf var2, List<Object> var3);

    public void decodeLast(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (byteBuf.isReadable()) {
            this.decode(channelHandlerContext, byteBuf, list);
        }
    }

    static ByteBuf expandCumulation(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf, int n2) {
        ByteBuf byteBuf2 = byteBuf;
        byteBuf = byteBufAllocator.buffer(byteBuf2.readableBytes() + n2);
        byteBuf.writeBytes(byteBuf2);
        byteBuf2.release();
        return byteBuf;
    }
}

