/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.ByteToMessageDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.LineBasedFrameDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.TooLongFrameException;
import java.util.List;

public class DelimiterBasedFrameDecoder
extends ByteToMessageDecoder {
    private final ByteBuf[] delimiters;
    private final int maxFrameLength;
    private final boolean stripDelimiter;
    private final boolean failFast;
    private boolean discardingTooLongFrame;
    private int tooLongFrameLength;
    private final LineBasedFrameDecoder lineBasedDecoder;

    public DelimiterBasedFrameDecoder(int n2, ByteBuf byteBuf) {
        this(n2, true, byteBuf);
    }

    public DelimiterBasedFrameDecoder(int n2, boolean bl, ByteBuf byteBuf) {
        this(n2, bl, true, byteBuf);
    }

    public DelimiterBasedFrameDecoder(int n2, boolean bl, boolean bl2, ByteBuf byteBuf) {
        ByteBuf[] byteBufArray = new ByteBuf[1];
        ByteBuf byteBuf2 = byteBuf;
        byteBufArray[0] = byteBuf2.slice(byteBuf2.readerIndex(), byteBuf.readableBytes());
        this(n2, bl, bl2, byteBufArray);
    }

    public DelimiterBasedFrameDecoder(int n2, ByteBuf ... byteBufArray) {
        this(n2, true, byteBufArray);
    }

    public DelimiterBasedFrameDecoder(int n2, boolean bl, ByteBuf ... byteBufArray) {
        this(n2, bl, true, byteBufArray);
    }

    public DelimiterBasedFrameDecoder(int n2, boolean bl, boolean bl2, ByteBuf ... byteBufArray) {
        DelimiterBasedFrameDecoder.validateMaxFrameLength(n2);
        if (byteBufArray == null) {
            throw new NullPointerException("delimiters");
        }
        if (byteBufArray.length == 0) {
            throw new IllegalArgumentException("empty delimiters");
        }
        if (DelimiterBasedFrameDecoder.isLineBased(byteBufArray) && !this.isSubclass()) {
            this.lineBasedDecoder = new LineBasedFrameDecoder(n2, bl, bl2);
            this.delimiters = null;
        } else {
            this.delimiters = new ByteBuf[byteBufArray.length];
            for (int i2 = 0; i2 < byteBufArray.length; ++i2) {
                ByteBuf byteBuf = byteBufArray[i2];
                DelimiterBasedFrameDecoder.validateDelimiter(byteBuf);
                ByteBuf byteBuf2 = byteBuf;
                this.delimiters[i2] = byteBuf2.slice(byteBuf2.readerIndex(), byteBuf.readableBytes());
            }
            this.lineBasedDecoder = null;
        }
        this.maxFrameLength = n2;
        this.stripDelimiter = bl;
        this.failFast = bl2;
    }

    private static boolean isLineBased(ByteBuf[] byteBufArray) {
        if (byteBufArray.length != 2) {
            return false;
        }
        ByteBuf byteBuf = byteBufArray[0];
        ByteBuf byteBuf2 = byteBufArray[1];
        if (byteBuf.capacity() < byteBuf2.capacity()) {
            byteBuf = byteBufArray[1];
            byteBuf2 = byteBufArray[0];
        }
        return byteBuf.capacity() == 2 && byteBuf2.capacity() == 1 && byteBuf.getByte(0) == 13 && byteBuf.getByte(1) == 10 && byteBuf2.getByte(0) == 10;
    }

    private boolean isSubclass() {
        return this.getClass() != DelimiterBasedFrameDecoder.class;
    }

    @Override
    protected final void decode(ChannelHandlerContext object, ByteBuf byteBuf, List<Object> list) {
        if ((object = this.decode((ChannelHandlerContext)object, byteBuf)) != null) {
            list.add(object);
        }
    }

    protected Object decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        int n2;
        if (this.lineBasedDecoder != null) {
            return this.lineBasedDecoder.decode(channelHandlerContext, byteBuf);
        }
        int n3 = Integer.MAX_VALUE;
        ByteBuf byteBuf2 = null;
        ByteBuf[] byteBufArray = this.delimiters;
        int n4 = this.delimiters.length;
        for (n2 = 0; n2 < n4; ++n2) {
            ByteBuf byteBuf3 = byteBufArray[n2];
            int n5 = DelimiterBasedFrameDecoder.indexOf(byteBuf, byteBuf3);
            if (n5 < 0 || n5 >= n3) continue;
            n3 = n5;
            byteBuf2 = byteBuf3;
        }
        if (byteBuf2 != null) {
            ByteBuf byteBuf4;
            int n6 = byteBuf2.capacity();
            if (this.discardingTooLongFrame) {
                this.discardingTooLongFrame = false;
                byteBuf.skipBytes(n3 + n6);
                n2 = this.tooLongFrameLength;
                this.tooLongFrameLength = 0;
                if (!this.failFast) {
                    this.fail(n2);
                }
                return null;
            }
            if (n3 > this.maxFrameLength) {
                byteBuf.skipBytes(n3 + n6);
                this.fail(n3);
                return null;
            }
            if (this.stripDelimiter) {
                byteBuf4 = byteBuf.readSlice(n3);
                byteBuf.skipBytes(n6);
            } else {
                byteBuf4 = byteBuf.readSlice(n3 + n6);
            }
            return byteBuf4.retain();
        }
        if (!this.discardingTooLongFrame) {
            if (byteBuf.readableBytes() > this.maxFrameLength) {
                this.tooLongFrameLength = byteBuf.readableBytes();
                ByteBuf byteBuf5 = byteBuf;
                byteBuf5.skipBytes(byteBuf5.readableBytes());
                this.discardingTooLongFrame = true;
                if (this.failFast) {
                    DelimiterBasedFrameDecoder delimiterBasedFrameDecoder = this;
                    delimiterBasedFrameDecoder.fail(delimiterBasedFrameDecoder.tooLongFrameLength);
                }
            }
        } else {
            this.tooLongFrameLength += byteBuf.readableBytes();
            ByteBuf byteBuf6 = byteBuf;
            byteBuf6.skipBytes(byteBuf6.readableBytes());
        }
        return null;
    }

    private void fail(long l2) {
        if (l2 > 0L) {
            throw new TooLongFrameException("frame length exceeds " + this.maxFrameLength + ": " + l2 + " - discarded");
        }
        throw new TooLongFrameException("frame length exceeds " + this.maxFrameLength + " - discarding");
    }

    private static int indexOf(ByteBuf byteBuf, ByteBuf byteBuf2) {
        for (int i2 = byteBuf.readerIndex(); i2 < byteBuf.writerIndex(); ++i2) {
            int n2;
            int n3 = i2;
            for (n2 = 0; n2 < byteBuf2.capacity() && byteBuf.getByte(n3) == byteBuf2.getByte(n2); ++n2) {
                if (++n3 != byteBuf.writerIndex() || n2 == byteBuf2.capacity() - 1) continue;
                return -1;
            }
            if (n2 != byteBuf2.capacity()) continue;
            return i2 - byteBuf.readerIndex();
        }
        return -1;
    }

    private static void validateDelimiter(ByteBuf byteBuf) {
        if (byteBuf == null) {
            throw new NullPointerException("delimiter");
        }
        if (!byteBuf.isReadable()) {
            throw new IllegalArgumentException("empty delimiter");
        }
    }

    private static void validateMaxFrameLength(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxFrameLength must be a positive integer: " + n2);
        }
    }
}

