/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;

public class FixedLengthFrameDecoder
extends ByteToMessageDecoder {
    private final int frameLength;

    public FixedLengthFrameDecoder(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("frameLength must be a positive integer: " + n2);
        }
        this.frameLength = n2;
    }

    @Override
    protected final void decode(ChannelHandlerContext object, ByteBuf byteBuf, List<Object> list) {
        if ((object = this.decode((ChannelHandlerContext)object, byteBuf)) != null) {
            list.add(object);
        }
    }

    protected Object decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        if (byteBuf.readableBytes() < this.frameLength) {
            return null;
        }
        return byteBuf.readSlice(this.frameLength).retain();
    }
}

