/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.ByteToMessageDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.CorruptedFrameException;
import com.aliyun.openservices.shade.io.netty.handler.codec.DecoderException;
import com.aliyun.openservices.shade.io.netty.handler.codec.TooLongFrameException;
import java.nio.ByteOrder;
import java.util.List;

public class LengthFieldBasedFrameDecoder
extends ByteToMessageDecoder {
    private final ByteOrder byteOrder;
    private final int maxFrameLength;
    private final int lengthFieldOffset;
    private final int lengthFieldLength;
    private final int lengthFieldEndOffset;
    private final int lengthAdjustment;
    private final int initialBytesToStrip;
    private final boolean failFast;
    private boolean discardingTooLongFrame;
    private long tooLongFrameLength;
    private long bytesToDiscard;

    public LengthFieldBasedFrameDecoder(int n2, int n3, int n4) {
        this(n2, n3, n4, 0, 0);
    }

    public LengthFieldBasedFrameDecoder(int n2, int n3, int n4, int n5, int n6) {
        this(n2, n3, n4, n5, n6, true);
    }

    public LengthFieldBasedFrameDecoder(int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this(ByteOrder.BIG_ENDIAN, n2, n3, n4, n5, n6, bl);
    }

    public LengthFieldBasedFrameDecoder(ByteOrder byteOrder, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (byteOrder == null) {
            throw new NullPointerException("byteOrder");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxFrameLength must be a positive integer: " + n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("lengthFieldOffset must be a non-negative integer: " + n3);
        }
        if (n6 < 0) {
            throw new IllegalArgumentException("initialBytesToStrip must be a non-negative integer: " + n6);
        }
        if (n3 > n2 - n4) {
            throw new IllegalArgumentException("maxFrameLength (" + n2 + ") must be equal to or greater than " + "lengthFieldOffset (" + n3 + ") + lengthFieldLength (" + n4 + ").");
        }
        this.byteOrder = byteOrder;
        this.maxFrameLength = n2;
        this.lengthFieldOffset = n3;
        this.lengthFieldLength = n4;
        this.lengthAdjustment = n5;
        this.lengthFieldEndOffset = n3 + n4;
        this.initialBytesToStrip = n6;
        this.failFast = bl;
    }

    @Override
    protected final void decode(ChannelHandlerContext object, ByteBuf byteBuf, List<Object> list) {
        if ((object = this.decode((ChannelHandlerContext)object, byteBuf)) != null) {
            list.add(object);
        }
    }

    public Object decode(ChannelHandlerContext object, ByteBuf byteBuf) {
        if (this.discardingTooLongFrame) {
            long l2 = this.bytesToDiscard;
            int n2 = (int)Math.min(l2, (long)byteBuf.readableBytes());
            byteBuf.skipBytes(n2);
            this.bytesToDiscard = l2 -= (long)n2;
            this.failIfNecessary(false);
        }
        if (byteBuf.readableBytes() < this.lengthFieldEndOffset) {
            return null;
        }
        int n3 = byteBuf.readerIndex() + this.lengthFieldOffset;
        long l3 = this.getUnadjustedFrameLength(byteBuf, n3, this.lengthFieldLength, this.byteOrder);
        if (l3 < 0L) {
            byteBuf.skipBytes(this.lengthFieldEndOffset);
            throw new CorruptedFrameException("negative pre-adjustment length field: " + l3);
        }
        if ((l3 += (long)(this.lengthAdjustment + this.lengthFieldEndOffset)) < (long)this.lengthFieldEndOffset) {
            byteBuf.skipBytes(this.lengthFieldEndOffset);
            throw new CorruptedFrameException("Adjusted frame length (" + l3 + ") is less than lengthFieldEndOffset: " + this.lengthFieldEndOffset);
        }
        if (l3 > (long)this.maxFrameLength) {
            long l4 = l3 - (long)byteBuf.readableBytes();
            this.tooLongFrameLength = l3;
            if (l4 < 0L) {
                byteBuf.skipBytes((int)l3);
            } else {
                this.discardingTooLongFrame = true;
                this.bytesToDiscard = l4;
                ByteBuf byteBuf2 = byteBuf;
                byteBuf2.skipBytes(byteBuf2.readableBytes());
            }
            this.failIfNecessary(true);
            return null;
        }
        n3 = (int)l3;
        if (byteBuf.readableBytes() < n3) {
            return null;
        }
        if (this.initialBytesToStrip > n3) {
            byteBuf.skipBytes(n3);
            throw new CorruptedFrameException("Adjusted frame length (" + l3 + ") is less than initialBytesToStrip: " + this.initialBytesToStrip);
        }
        byteBuf.skipBytes(this.initialBytesToStrip);
        int n4 = byteBuf.readerIndex();
        object = this.extractFrame((ChannelHandlerContext)object, byteBuf, n4, n3 -= this.initialBytesToStrip);
        byteBuf.readerIndex(n4 + n3);
        return object;
    }

    protected long getUnadjustedFrameLength(ByteBuf byteBuf, int n2, int n3, ByteOrder byteOrder) {
        long l2;
        byteBuf = byteBuf.order(byteOrder);
        switch (n3) {
            case 1: {
                l2 = byteBuf.getUnsignedByte(n2);
                break;
            }
            case 2: {
                l2 = byteBuf.getUnsignedShort(n2);
                break;
            }
            case 3: {
                l2 = byteBuf.getUnsignedMedium(n2);
                break;
            }
            case 4: {
                l2 = byteBuf.getUnsignedInt(n2);
                break;
            }
            case 8: {
                l2 = byteBuf.getLong(n2);
                break;
            }
            default: {
                throw new DecoderException("unsupported lengthFieldLength: " + this.lengthFieldLength + " (expected: 1, 2, 3, 4, or 8)");
            }
        }
        return l2;
    }

    private void failIfNecessary(boolean bl) {
        if (this.bytesToDiscard == 0L) {
            long l2 = this.tooLongFrameLength;
            this.tooLongFrameLength = 0L;
            this.discardingTooLongFrame = false;
            if (!this.failFast || this.failFast && bl) {
                this.fail(l2);
            }
            return;
        }
        if (this.failFast && bl) {
            LengthFieldBasedFrameDecoder lengthFieldBasedFrameDecoder = this;
            lengthFieldBasedFrameDecoder.fail(lengthFieldBasedFrameDecoder.tooLongFrameLength);
        }
    }

    protected ByteBuf extractFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, int n2, int n3) {
        return byteBuf.slice(n2, n3).retain();
    }

    private void fail(long l2) {
        if (l2 > 0L) {
            throw new TooLongFrameException("Adjusted frame length exceeds " + this.maxFrameLength + ": " + l2 + " - discarded");
        }
        throw new TooLongFrameException("Adjusted frame length exceeds " + this.maxFrameLength + " - discarding");
    }
}

