/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandler$Sharable;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.MessageToByteEncoder;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import java.nio.ByteOrder;

@ChannelHandler$Sharable
public class LengthFieldPrepender
extends MessageToByteEncoder<ByteBuf> {
    private final ByteOrder byteOrder;
    private final int lengthFieldLength;
    private final boolean lengthIncludesLengthFieldLength;
    private final int lengthAdjustment;

    public LengthFieldPrepender(int n2) {
        this(n2, false);
    }

    public LengthFieldPrepender(int n2, boolean bl) {
        this(n2, 0, bl);
    }

    public LengthFieldPrepender(int n2, int n3) {
        this(n2, n3, false);
    }

    public LengthFieldPrepender(int n2, int n3, boolean bl) {
        this(ByteOrder.BIG_ENDIAN, n2, n3, bl);
    }

    public LengthFieldPrepender(ByteOrder byteOrder, int n2, int n3, boolean bl) {
        if (n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4 && n2 != 8) {
            throw new IllegalArgumentException("lengthFieldLength must be either 1, 2, 3, 4, or 8: " + n2);
        }
        ObjectUtil.checkNotNull(byteOrder, "byteOrder");
        this.byteOrder = byteOrder;
        this.lengthFieldLength = n2;
        this.lengthIncludesLengthFieldLength = bl;
        this.lengthAdjustment = n3;
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n2 = byteBuf.readableBytes() + this.lengthAdjustment;
        if (this.lengthIncludesLengthFieldLength) {
            n2 += this.lengthFieldLength;
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Adjusted frame length (" + n2 + ") is less than zero");
        }
        switch (this.lengthFieldLength) {
            case 1: {
                if (n2 >= 256) {
                    throw new IllegalArgumentException("length does not fit into a byte: " + n2);
                }
                byteBuf2.writeByte((byte)n2);
                break;
            }
            case 2: {
                if (n2 >= 65536) {
                    throw new IllegalArgumentException("length does not fit into a short integer: " + n2);
                }
                byteBuf2.writeShort((short)n2);
                break;
            }
            case 3: {
                if (n2 >= 0x1000000) {
                    throw new IllegalArgumentException("length does not fit into a medium integer: " + n2);
                }
                byteBuf2.writeMedium(n2);
                break;
            }
            case 4: {
                byteBuf2.writeInt(n2);
                break;
            }
            case 8: {
                byteBuf2.writeLong(n2);
                break;
            }
            default: {
                throw new Error("should not reach here");
            }
        }
        ByteBuf byteBuf3 = byteBuf;
        byteBuf2.writeBytes(byteBuf3, byteBuf3.readerIndex(), byteBuf.readableBytes());
    }

    @Override
    protected ByteBuf allocateBuffer(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, boolean bl) {
        return super.allocateBuffer(channelHandlerContext, byteBuf, bl).order(this.byteOrder);
    }
}

