/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufProcessor;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.ByteToMessageDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.TooLongFrameException;
import java.util.List;

public class LineBasedFrameDecoder
extends ByteToMessageDecoder {
    private final int maxLength;
    private final boolean failFast;
    private final boolean stripDelimiter;
    private boolean discarding;
    private int discardedBytes;

    public LineBasedFrameDecoder(int n2) {
        this(n2, true, false);
    }

    public LineBasedFrameDecoder(int n2, boolean bl, boolean bl2) {
        this.maxLength = n2;
        this.failFast = bl2;
        this.stripDelimiter = bl;
    }

    @Override
    protected final void decode(ChannelHandlerContext object, ByteBuf byteBuf, List<Object> list) {
        if ((object = this.decode((ChannelHandlerContext)object, byteBuf)) != null) {
            list.add(object);
        }
    }

    protected Object decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        int n2 = LineBasedFrameDecoder.findEndOfLine(byteBuf);
        if (!this.discarding) {
            if (n2 >= 0) {
                ByteBuf byteBuf2;
                int n3;
                int n4 = n2 - byteBuf.readerIndex();
                int n5 = n3 = byteBuf.getByte(n2) == 13 ? 2 : 1;
                if (n4 > this.maxLength) {
                    byteBuf.readerIndex(n2 + n3);
                    this.fail(channelHandlerContext, n4);
                    return null;
                }
                if (this.stripDelimiter) {
                    byteBuf2 = byteBuf.readSlice(n4);
                    byteBuf.skipBytes(n3);
                } else {
                    byteBuf2 = byteBuf.readSlice(n4 + n3);
                }
                return byteBuf2.retain();
            }
            int n6 = byteBuf.readableBytes();
            if (n6 > this.maxLength) {
                this.discardedBytes = n6;
                ByteBuf byteBuf3 = byteBuf;
                byteBuf3.readerIndex(byteBuf3.writerIndex());
                this.discarding = true;
                if (this.failFast) {
                    this.fail(channelHandlerContext, "over " + this.discardedBytes);
                }
            }
            return null;
        }
        if (n2 >= 0) {
            int n7 = this.discardedBytes + n2 - byteBuf.readerIndex();
            int n8 = byteBuf.getByte(n2) == 13 ? 2 : 1;
            byteBuf.readerIndex(n2 + n8);
            this.discardedBytes = 0;
            this.discarding = false;
            if (!this.failFast) {
                this.fail(channelHandlerContext, n7);
            }
        } else {
            this.discardedBytes += byteBuf.readableBytes();
            ByteBuf byteBuf4 = byteBuf;
            byteBuf4.readerIndex(byteBuf4.writerIndex());
        }
        return null;
    }

    private void fail(ChannelHandlerContext channelHandlerContext, int n2) {
        this.fail(channelHandlerContext, String.valueOf(n2));
    }

    private void fail(ChannelHandlerContext channelHandlerContext, String string) {
        channelHandlerContext.fireExceptionCaught(new TooLongFrameException("frame length (" + string + ") exceeds the allowed maximum (" + this.maxLength + ')'));
    }

    private static int findEndOfLine(ByteBuf byteBuf) {
        int n2 = byteBuf.forEachByte(ByteBufProcessor.FIND_LF);
        if (n2 > 0 && byteBuf.getByte(n2 - 1) == 13) {
            --n2;
        }
        return n2;
    }
}

