/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundHandlerAdapter;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.handler.codec.EncoderException;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCountUtil;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCounted;
import com.aliyun.openservices.shade.io.netty.util.internal.TypeParameterMatcher;

public abstract class MessageToByteEncoder<I>
extends ChannelOutboundHandlerAdapter {
    private final TypeParameterMatcher matcher;
    private final boolean preferDirect;

    public MessageToByteEncoder() {
        this(true);
    }

    protected MessageToByteEncoder(Class<? extends I> clazz) {
        this(clazz, true);
    }

    public MessageToByteEncoder(boolean bl) {
        this.matcher = TypeParameterMatcher.find(this, MessageToByteEncoder.class, "I");
        this.preferDirect = bl;
    }

    protected MessageToByteEncoder(Class<? extends I> clazz, boolean bl) {
        this.matcher = TypeParameterMatcher.get(clazz);
        this.preferDirect = bl;
    }

    public boolean acceptOutboundMessage(Object object) {
        return this.matcher.match(object);
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        ReferenceCounted referenceCounted = null;
        try {
            try {
                if (this.acceptOutboundMessage(object)) {
                    referenceCounted = this.allocateBuffer(channelHandlerContext, object, this.preferDirect);
                    try {
                        this.encode(channelHandlerContext, object, (ByteBuf)referenceCounted);
                    }
                    finally {
                        ReferenceCountUtil.release(object);
                    }
                    if (((ByteBuf)referenceCounted).isReadable()) {
                        channelHandlerContext.write(referenceCounted, channelPromise);
                    } else {
                        referenceCounted.release();
                        channelHandlerContext.write(Unpooled.EMPTY_BUFFER, channelPromise);
                    }
                } else {
                    channelHandlerContext.write(object, channelPromise);
                    return;
                }
                referenceCounted = null;
            }
            catch (EncoderException encoderException) {
                object = encoderException;
                throw encoderException;
            }
            catch (Throwable throwable) {
                throw new EncoderException(throwable);
            }
        }
        catch (Throwable throwable) {
            if (referenceCounted != null) {
                referenceCounted.release();
            }
            throw throwable;
        }
    }

    protected ByteBuf allocateBuffer(ChannelHandlerContext channelHandlerContext, I i2, boolean bl) {
        if (bl) {
            return channelHandlerContext.alloc().ioBuffer();
        }
        return channelHandlerContext.alloc().heapBuffer();
    }

    protected abstract void encode(ChannelHandlerContext var1, I var2, ByteBuf var3);
}

