/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec;

import com.aliyun.openservices.shade.io.netty.channel.ChannelDuplexHandler;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelInboundHandlerAdapter;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundHandlerAdapter;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.handler.codec.MessageToMessageCodec$1;
import com.aliyun.openservices.shade.io.netty.handler.codec.MessageToMessageCodec$2;
import com.aliyun.openservices.shade.io.netty.handler.codec.MessageToMessageDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.MessageToMessageEncoder;
import com.aliyun.openservices.shade.io.netty.util.internal.TypeParameterMatcher;
import java.util.List;

public abstract class MessageToMessageCodec<INBOUND_IN, OUTBOUND_IN>
extends ChannelDuplexHandler {
    private final MessageToMessageEncoder<Object> encoder = new MessageToMessageCodec$1(this);
    private final MessageToMessageDecoder<Object> decoder = new MessageToMessageCodec$2(this);
    private final TypeParameterMatcher inboundMsgMatcher;
    private final TypeParameterMatcher outboundMsgMatcher;

    public MessageToMessageCodec() {
        this.inboundMsgMatcher = TypeParameterMatcher.find(this, MessageToMessageCodec.class, "INBOUND_IN");
        this.outboundMsgMatcher = TypeParameterMatcher.find(this, MessageToMessageCodec.class, "OUTBOUND_IN");
    }

    protected MessageToMessageCodec(Class<? extends INBOUND_IN> clazz, Class<? extends OUTBOUND_IN> clazz2) {
        this.inboundMsgMatcher = TypeParameterMatcher.get(clazz);
        this.outboundMsgMatcher = TypeParameterMatcher.get(clazz2);
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        ((ChannelInboundHandlerAdapter)this.decoder).channelRead(channelHandlerContext, object);
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        ((ChannelOutboundHandlerAdapter)this.encoder).write(channelHandlerContext, object, channelPromise);
    }

    public boolean acceptInboundMessage(Object object) {
        return this.inboundMsgMatcher.match(object);
    }

    public boolean acceptOutboundMessage(Object object) {
        return this.outboundMsgMatcher.match(object);
    }

    protected abstract void encode(ChannelHandlerContext var1, OUTBOUND_IN var2, List<Object> var3);

    protected abstract void decode(ChannelHandlerContext var1, INBOUND_IN var2, List<Object> var3);
}

