/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec;

import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelInboundHandlerAdapter;
import com.aliyun.openservices.shade.io.netty.handler.codec.CodecOutputList;
import com.aliyun.openservices.shade.io.netty.handler.codec.DecoderException;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCountUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.TypeParameterMatcher;
import java.util.List;

public abstract class MessageToMessageDecoder<I>
extends ChannelInboundHandlerAdapter {
    private final TypeParameterMatcher matcher;

    public MessageToMessageDecoder() {
        this.matcher = TypeParameterMatcher.find(this, MessageToMessageDecoder.class, "I");
    }

    protected MessageToMessageDecoder(Class<? extends I> clazz) {
        this.matcher = TypeParameterMatcher.get(clazz);
    }

    public boolean acceptInboundMessage(Object object) {
        return this.matcher.match(object);
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        CodecOutputList codecOutputList = CodecOutputList.newInstance();
        try {
            if (this.acceptInboundMessage(object)) {
                try {
                    this.decode(channelHandlerContext, object, codecOutputList);
                }
                finally {
                    ReferenceCountUtil.release(object);
                }
            } else {
                codecOutputList.add(object);
            }
            return;
        }
        catch (DecoderException decoderException) {
            object = decoderException;
            throw decoderException;
        }
        catch (Exception exception) {
            throw new DecoderException(exception);
        }
        finally {
            int n2 = codecOutputList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                channelHandlerContext.fireChannelRead(codecOutputList.getUnsafe(i2));
            }
            codecOutputList.recycle();
        }
    }

    protected abstract void decode(ChannelHandlerContext var1, I var2, List<Object> var3);
}

