/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec;

import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOutboundHandlerAdapter;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.handler.codec.CodecOutputList;
import com.aliyun.openservices.shade.io.netty.handler.codec.EncoderException;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCountUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.TypeParameterMatcher;
import java.util.List;

public abstract class MessageToMessageEncoder<I>
extends ChannelOutboundHandlerAdapter {
    private final TypeParameterMatcher matcher;

    public MessageToMessageEncoder() {
        this.matcher = TypeParameterMatcher.find(this, MessageToMessageEncoder.class, "I");
    }

    protected MessageToMessageEncoder(Class<? extends I> clazz) {
        this.matcher = TypeParameterMatcher.get(clazz);
    }

    public boolean acceptOutboundMessage(Object object) {
        return this.matcher.match(object);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        block21: {
            CodecOutputList codecOutputList = null;
            try {
                if (this.acceptOutboundMessage(object)) {
                    codecOutputList = CodecOutputList.newInstance();
                    try {
                        this.encode(channelHandlerContext, object, codecOutputList);
                    }
                    finally {
                        ReferenceCountUtil.release(object);
                    }
                    if (codecOutputList.isEmpty()) {
                        codecOutputList.recycle();
                        codecOutputList = null;
                        throw new EncoderException(StringUtil.simpleClassName(this) + " must produce at least one message.");
                    }
                } else {
                    channelHandlerContext.write(object, channelPromise);
                }
                if (codecOutputList == null) break block21;
            }
            catch (EncoderException encoderException) {
                try {
                    object = encoderException;
                    throw encoderException;
                    catch (Throwable throwable) {
                        throw new EncoderException(throwable);
                    }
                }
                catch (Throwable throwable) {
                    if (codecOutputList != null) {
                        int n2 = codecOutputList.size() - 1;
                        if (n2 == 0) {
                            channelHandlerContext.write(codecOutputList.get(0), channelPromise);
                        } else if (n2 > 0) {
                            ChannelPromise channelPromise2 = channelHandlerContext.voidPromise();
                            boolean bl2 = channelPromise == channelPromise2;
                            for (int i2 = 0; i2 < n2; ++i2) {
                                ChannelPromise channelPromise3 = bl2 ? channelPromise2 : channelHandlerContext.newPromise();
                                channelHandlerContext.write(codecOutputList.getUnsafe(i2), channelPromise3);
                            }
                            channelHandlerContext.write(codecOutputList.getUnsafe(n2), channelPromise);
                        }
                        codecOutputList.recycle();
                    }
                    throw throwable;
                }
            }
            int n3 = codecOutputList.size() - 1;
            if (n3 == 0) {
                channelHandlerContext.write(codecOutputList.get(0), channelPromise);
            } else if (n3 > 0) {
                ChannelPromise channelPromise4 = channelHandlerContext.voidPromise();
                boolean bl = channelPromise == channelPromise4;
                for (int i3 = 0; i3 < n3; ++i3) {
                    ChannelPromise channelPromise5 = bl ? channelPromise4 : channelHandlerContext.newPromise();
                    channelHandlerContext.write(codecOutputList.getUnsafe(i3), channelPromise5);
                }
                channelHandlerContext.write(codecOutputList.getUnsafe(n3), channelPromise);
            }
            codecOutputList.recycle();
            return;
        }
    }

    protected abstract void encode(ChannelHandlerContext var1, I var2, List<Object> var3);
}

