/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.ByteToMessageDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.DecoderException;
import com.aliyun.openservices.shade.io.netty.handler.codec.ReplayingDecoderByteBuf;
import com.aliyun.openservices.shade.io.netty.util.Signal;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import java.util.List;

public abstract class ReplayingDecoder<S>
extends ByteToMessageDecoder {
    static final Signal REPLAY = Signal.valueOf(ReplayingDecoder.class.getName() + ".REPLAY");
    private final ReplayingDecoderByteBuf replayable = new ReplayingDecoderByteBuf();
    private S state;
    private int checkpoint = -1;

    public ReplayingDecoder() {
        this(null);
    }

    public ReplayingDecoder(S s2) {
        this.state = s2;
    }

    protected void checkpoint() {
        this.checkpoint = this.internalBuffer().readerIndex();
    }

    protected void checkpoint(S s2) {
        this.checkpoint();
        this.state(s2);
    }

    protected S state() {
        return this.state;
    }

    protected S state(S s2) {
        S s3 = this.state;
        this.state = s2;
        return s3;
    }

    @Override
    final void channelInputClosed(ChannelHandlerContext object, List<Object> list) {
        try {
            this.replayable.terminate();
            if (this.cumulation == null) {
                this.replayable.setCumulation(Unpooled.EMPTY_BUFFER);
                this.decodeLast((ChannelHandlerContext)object, this.replayable, list);
                return;
            }
            this.callDecode((ChannelHandlerContext)object, this.internalBuffer(), list);
            this.decodeLast((ChannelHandlerContext)object, this.replayable, list);
        }
        catch (Signal signal) {
            object = signal;
            signal.expect(REPLAY);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void callDecode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> object) {
        this.replayable.setCumulation(byteBuf);
        try {
            while (byteBuf.isReadable()) {
                int n2 = this.checkpoint = byteBuf.readerIndex();
                int n3 = object.size();
                if (n3 > 0) {
                    ReplayingDecoder.fireChannelRead(channelHandlerContext, (List<Object>)object, n3);
                    object.clear();
                    if (channelHandlerContext.isRemoved()) return;
                    n3 = 0;
                }
                S s2 = this.state;
                int n4 = byteBuf.readableBytes();
                try {
                    this.decode(channelHandlerContext, this.replayable, (List<Object>)object);
                    if (channelHandlerContext.isRemoved()) {
                        return;
                    }
                    if (n3 == object.size()) {
                        if (n4 != byteBuf.readableBytes() || s2 != this.state) continue;
                        throw new DecoderException(StringUtil.simpleClassName(this.getClass()) + ".decode() must consume the inbound data or change its state if it did not decode anything.");
                    }
                }
                catch (Signal signal) {
                    object = signal;
                    signal.expect(REPLAY);
                    if (channelHandlerContext.isRemoved()) return;
                    int n5 = this.checkpoint;
                    if (n5 < 0) return;
                    byteBuf.readerIndex(n5);
                    return;
                }
                if (n2 == byteBuf.readerIndex() && s2 == this.state) {
                    throw new DecoderException(StringUtil.simpleClassName(this.getClass()) + ".decode() method must consume the inbound data or change its state if it decoded something.");
                }
                if (this.isSingleDecode()) return;
            }
            return;
        }
        catch (DecoderException decoderException) {
            DecoderException decoderException2 = decoderException;
            throw decoderException;
        }
        catch (Throwable throwable) {
            throw new DecoderException(throwable);
        }
    }
}

