/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufProcessor;
import com.aliyun.openservices.shade.io.netty.buffer.SwappedByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.handler.codec.ReplayingDecoder;
import com.aliyun.openservices.shade.io.netty.util.Signal;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

final class ReplayingDecoderByteBuf
extends ByteBuf {
    private static final Signal REPLAY = ReplayingDecoder.REPLAY;
    private ByteBuf buffer;
    private boolean terminated;
    private SwappedByteBuf swapped;
    static final ReplayingDecoderByteBuf EMPTY_BUFFER = new ReplayingDecoderByteBuf(Unpooled.EMPTY_BUFFER);

    ReplayingDecoderByteBuf() {
    }

    ReplayingDecoderByteBuf(ByteBuf byteBuf) {
        this.setCumulation(byteBuf);
    }

    final void setCumulation(ByteBuf byteBuf) {
        this.buffer = byteBuf;
    }

    final void terminate() {
        this.terminated = true;
    }

    @Override
    public final int capacity() {
        if (this.terminated) {
            return this.buffer.capacity();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public final ByteBuf capacity(int n2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final int maxCapacity() {
        return ((ByteBuf)this).capacity();
    }

    @Override
    public final ByteBufAllocator alloc() {
        return this.buffer.alloc();
    }

    @Override
    public final boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public final boolean hasArray() {
        return false;
    }

    @Override
    public final byte[] array() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean hasMemoryAddress() {
        return false;
    }

    @Override
    public final long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ByteBuf clear() {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final boolean equals(Object object) {
        return this == object;
    }

    @Override
    public final int compareTo(ByteBuf byteBuf) {
        ReplayingDecoderByteBuf.reject();
        return 0;
    }

    @Override
    public final ByteBuf copy() {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf copy(int n2, int n3) {
        this.checkIndex(n2, n3);
        return this.buffer.copy(n2, n3);
    }

    @Override
    public final ByteBuf discardReadBytes() {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf ensureWritable(int n2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final int ensureWritable(int n2, boolean bl) {
        ReplayingDecoderByteBuf.reject();
        return 0;
    }

    @Override
    public final ByteBuf duplicate() {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final boolean getBoolean(int n2) {
        this.checkIndex(n2, 1);
        return this.buffer.getBoolean(n2);
    }

    @Override
    public final byte getByte(int n2) {
        this.checkIndex(n2, 1);
        return this.buffer.getByte(n2);
    }

    @Override
    public final short getUnsignedByte(int n2) {
        this.checkIndex(n2, 1);
        return this.buffer.getUnsignedByte(n2);
    }

    @Override
    public final ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkIndex(n2, n4);
        this.buffer.getBytes(n2, byArray, n3, n4);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n2, byte[] byArray) {
        this.checkIndex(n2, byArray.length);
        this.buffer.getBytes(n2, byArray);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkIndex(n2, n4);
        this.buffer.getBytes(n2, byteBuf, n3, n4);
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf getBytes(int n2, ByteBuf byteBuf) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) {
        ReplayingDecoderByteBuf.reject();
        return 0;
    }

    @Override
    public final ByteBuf getBytes(int n2, OutputStream outputStream, int n3) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final int getInt(int n2) {
        this.checkIndex(n2, 4);
        return this.buffer.getInt(n2);
    }

    @Override
    public final long getUnsignedInt(int n2) {
        this.checkIndex(n2, 4);
        return this.buffer.getUnsignedInt(n2);
    }

    @Override
    public final long getLong(int n2) {
        this.checkIndex(n2, 8);
        return this.buffer.getLong(n2);
    }

    @Override
    public final int getMedium(int n2) {
        this.checkIndex(n2, 3);
        return this.buffer.getMedium(n2);
    }

    @Override
    public final int getUnsignedMedium(int n2) {
        this.checkIndex(n2, 3);
        return this.buffer.getUnsignedMedium(n2);
    }

    @Override
    public final short getShort(int n2) {
        this.checkIndex(n2, 2);
        return this.buffer.getShort(n2);
    }

    @Override
    public final int getUnsignedShort(int n2) {
        this.checkIndex(n2, 2);
        return this.buffer.getUnsignedShort(n2);
    }

    @Override
    public final char getChar(int n2) {
        this.checkIndex(n2, 2);
        return this.buffer.getChar(n2);
    }

    @Override
    public final float getFloat(int n2) {
        this.checkIndex(n2, 4);
        return this.buffer.getFloat(n2);
    }

    @Override
    public final double getDouble(int n2) {
        this.checkIndex(n2, 8);
        return this.buffer.getDouble(n2);
    }

    @Override
    public final int hashCode() {
        ReplayingDecoderByteBuf.reject();
        return 0;
    }

    @Override
    public final int indexOf(int n2, int n3, byte by) {
        if (n2 == n3) {
            return -1;
        }
        if (Math.max(n2, n3) > this.buffer.writerIndex()) {
            throw REPLAY;
        }
        return this.buffer.indexOf(n2, n3, by);
    }

    @Override
    public final int bytesBefore(byte by) {
        int n2 = this.buffer.bytesBefore(by);
        by = (byte)n2;
        if (n2 < 0) {
            throw REPLAY;
        }
        return by;
    }

    @Override
    public final int bytesBefore(int n2, byte by) {
        n2 = this.buffer.readerIndex();
        return ((ByteBuf)this).bytesBefore(n2, this.buffer.writerIndex() - n2, by);
    }

    @Override
    public final int bytesBefore(int n2, int n3, byte by) {
        int n4 = this.buffer.writerIndex();
        if (n2 >= n4) {
            throw REPLAY;
        }
        if (n2 <= n4 - n3) {
            return this.buffer.bytesBefore(n2, n3, by);
        }
        if ((n2 = this.buffer.bytesBefore(n2, n4 - n2, by)) < 0) {
            throw REPLAY;
        }
        return n2;
    }

    @Override
    public final int forEachByte(ByteBufProcessor byteBufProcessor) {
        int n2 = this.buffer.forEachByte(byteBufProcessor);
        if (n2 < 0) {
            throw REPLAY;
        }
        return n2;
    }

    @Override
    public final int forEachByte(int n2, int n3, ByteBufProcessor byteBufProcessor) {
        int n4 = this.buffer.writerIndex();
        if (n2 >= n4) {
            throw REPLAY;
        }
        if (n2 <= n4 - n3) {
            return this.buffer.forEachByte(n2, n3, byteBufProcessor);
        }
        if ((n2 = this.buffer.forEachByte(n2, n4 - n2, byteBufProcessor)) < 0) {
            throw REPLAY;
        }
        return n2;
    }

    @Override
    public final int forEachByteDesc(ByteBufProcessor byteBufProcessor) {
        if (this.terminated) {
            return this.buffer.forEachByteDesc(byteBufProcessor);
        }
        ReplayingDecoderByteBuf.reject();
        return 0;
    }

    @Override
    public final int forEachByteDesc(int n2, int n3, ByteBufProcessor byteBufProcessor) {
        if (n2 + n3 > this.buffer.writerIndex()) {
            throw REPLAY;
        }
        return this.buffer.forEachByteDesc(n2, n3, byteBufProcessor);
    }

    @Override
    public final ByteBuf markReaderIndex() {
        this.buffer.markReaderIndex();
        return this;
    }

    @Override
    public final ByteBuf markWriterIndex() {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteOrder order() {
        return this.buffer.order();
    }

    @Override
    public final ByteBuf order(ByteOrder object) {
        if (object == null) {
            throw new NullPointerException("endianness");
        }
        if (object == ((ByteBuf)this).order()) {
            return this;
        }
        object = this.swapped;
        if (object == null) {
            object = new SwappedByteBuf(this);
            this.swapped = object;
        }
        return object;
    }

    @Override
    public final boolean isReadable() {
        if (this.terminated) {
            return this.buffer.isReadable();
        }
        return true;
    }

    @Override
    public final boolean isReadable(int n2) {
        if (this.terminated) {
            return this.buffer.isReadable(n2);
        }
        return true;
    }

    @Override
    public final int readableBytes() {
        if (this.terminated) {
            return this.buffer.readableBytes();
        }
        return Integer.MAX_VALUE - this.buffer.readerIndex();
    }

    @Override
    public final boolean readBoolean() {
        this.checkReadableBytes(1);
        return this.buffer.readBoolean();
    }

    @Override
    public final byte readByte() {
        this.checkReadableBytes(1);
        return this.buffer.readByte();
    }

    @Override
    public final short readUnsignedByte() {
        this.checkReadableBytes(1);
        return this.buffer.readUnsignedByte();
    }

    @Override
    public final ByteBuf readBytes(byte[] byArray, int n2, int n3) {
        this.checkReadableBytes(n3);
        this.buffer.readBytes(byArray, n2, n3);
        return this;
    }

    @Override
    public final ByteBuf readBytes(byte[] byArray) {
        this.checkReadableBytes(byArray.length);
        this.buffer.readBytes(byArray);
        return this;
    }

    @Override
    public final ByteBuf readBytes(ByteBuffer byteBuffer) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf readBytes(ByteBuf byteBuf, int n2, int n3) {
        this.checkReadableBytes(n3);
        this.buffer.readBytes(byteBuf, n2, n3);
        return this;
    }

    @Override
    public final ByteBuf readBytes(ByteBuf byteBuf, int n2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf readBytes(ByteBuf byteBuf) {
        this.checkReadableBytes(byteBuf.writableBytes());
        this.buffer.readBytes(byteBuf);
        return this;
    }

    @Override
    public final int readBytes(GatheringByteChannel gatheringByteChannel, int n2) {
        ReplayingDecoderByteBuf.reject();
        return 0;
    }

    @Override
    public final ByteBuf readBytes(int n2) {
        this.checkReadableBytes(n2);
        return this.buffer.readBytes(n2);
    }

    @Override
    public final ByteBuf readSlice(int n2) {
        this.checkReadableBytes(n2);
        return this.buffer.readSlice(n2);
    }

    @Override
    public final ByteBuf readBytes(OutputStream outputStream, int n2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final int readerIndex() {
        return this.buffer.readerIndex();
    }

    @Override
    public final ByteBuf readerIndex(int n2) {
        this.buffer.readerIndex(n2);
        return this;
    }

    @Override
    public final int readInt() {
        this.checkReadableBytes(4);
        return this.buffer.readInt();
    }

    @Override
    public final long readUnsignedInt() {
        this.checkReadableBytes(4);
        return this.buffer.readUnsignedInt();
    }

    @Override
    public final long readLong() {
        this.checkReadableBytes(8);
        return this.buffer.readLong();
    }

    @Override
    public final int readMedium() {
        this.checkReadableBytes(3);
        return this.buffer.readMedium();
    }

    @Override
    public final int readUnsignedMedium() {
        this.checkReadableBytes(3);
        return this.buffer.readUnsignedMedium();
    }

    @Override
    public final short readShort() {
        this.checkReadableBytes(2);
        return this.buffer.readShort();
    }

    @Override
    public final int readUnsignedShort() {
        this.checkReadableBytes(2);
        return this.buffer.readUnsignedShort();
    }

    @Override
    public final char readChar() {
        this.checkReadableBytes(2);
        return this.buffer.readChar();
    }

    @Override
    public final float readFloat() {
        this.checkReadableBytes(4);
        return this.buffer.readFloat();
    }

    @Override
    public final double readDouble() {
        this.checkReadableBytes(8);
        return this.buffer.readDouble();
    }

    @Override
    public final ByteBuf resetReaderIndex() {
        this.buffer.resetReaderIndex();
        return this;
    }

    @Override
    public final ByteBuf resetWriterIndex() {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf setBoolean(int n2, boolean bl) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf setByte(int n2, int n3) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n2, byte[] byArray) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf setBytes(int n2, ByteBuf byteBuf) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final int setBytes(int n2, InputStream inputStream, int n3) {
        ReplayingDecoderByteBuf.reject();
        return 0;
    }

    @Override
    public final ByteBuf setZero(int n2, int n3) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) {
        ReplayingDecoderByteBuf.reject();
        return 0;
    }

    @Override
    public final ByteBuf setIndex(int n2, int n3) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf setInt(int n2, int n3) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf setLong(int n2, long l2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf setMedium(int n2, int n3) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf setShort(int n2, int n3) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf setChar(int n2, int n3) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf setFloat(int n2, float f2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf setDouble(int n2, double d2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf skipBytes(int n2) {
        this.checkReadableBytes(n2);
        this.buffer.skipBytes(n2);
        return this;
    }

    @Override
    public final ByteBuf slice() {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf slice(int n2, int n3) {
        this.checkIndex(n2, n3);
        return this.buffer.slice(n2, n3);
    }

    @Override
    public final int nioBufferCount() {
        return this.buffer.nioBufferCount();
    }

    @Override
    public final ByteBuffer nioBuffer() {
        ReplayingDecoderByteBuf.reject();
        return null;
    }

    @Override
    public final ByteBuffer nioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        return this.buffer.nioBuffer(n2, n3);
    }

    @Override
    public final ByteBuffer[] nioBuffers() {
        ReplayingDecoderByteBuf.reject();
        return null;
    }

    @Override
    public final ByteBuffer[] nioBuffers(int n2, int n3) {
        this.checkIndex(n2, n3);
        return this.buffer.nioBuffers(n2, n3);
    }

    @Override
    public final ByteBuffer internalNioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        return this.buffer.internalNioBuffer(n2, n3);
    }

    @Override
    public final String toString(int n2, int n3, Charset charset) {
        this.checkIndex(n2, n3);
        return this.buffer.toString(n2, n3, charset);
    }

    @Override
    public final String toString(Charset charset) {
        ReplayingDecoderByteBuf.reject();
        return null;
    }

    @Override
    public final String toString() {
        return StringUtil.simpleClassName(this) + '(' + "ridx=" + ((ByteBuf)this).readerIndex() + ", widx=" + ((ByteBuf)this).writerIndex() + ')';
    }

    @Override
    public final boolean isWritable() {
        return false;
    }

    @Override
    public final boolean isWritable(int n2) {
        return false;
    }

    @Override
    public final int writableBytes() {
        return 0;
    }

    @Override
    public final int maxWritableBytes() {
        return 0;
    }

    @Override
    public final ByteBuf writeBoolean(boolean bl) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf writeByte(int n2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf writeBytes(byte[] byArray, int n2, int n3) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf writeBytes(byte[] byArray) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf writeBytes(ByteBuffer byteBuffer) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf writeBytes(ByteBuf byteBuf, int n2, int n3) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf writeBytes(ByteBuf byteBuf, int n2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf writeBytes(ByteBuf byteBuf) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final int writeBytes(InputStream inputStream, int n2) {
        ReplayingDecoderByteBuf.reject();
        return 0;
    }

    @Override
    public final int writeBytes(ScatteringByteChannel scatteringByteChannel, int n2) {
        ReplayingDecoderByteBuf.reject();
        return 0;
    }

    @Override
    public final ByteBuf writeInt(int n2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf writeLong(long l2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf writeMedium(int n2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf writeZero(int n2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final int writerIndex() {
        return this.buffer.writerIndex();
    }

    @Override
    public final ByteBuf writerIndex(int n2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf writeShort(int n2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf writeChar(int n2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf writeFloat(float f2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf writeDouble(double d2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    private void checkIndex(int n2, int n3) {
        if (n2 + n3 > this.buffer.writerIndex()) {
            throw REPLAY;
        }
    }

    private void checkReadableBytes(int n2) {
        if (this.buffer.readableBytes() < n2) {
            throw REPLAY;
        }
    }

    @Override
    public final ByteBuf discardSomeReadBytes() {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final int refCnt() {
        return this.buffer.refCnt();
    }

    @Override
    public final ByteBuf retain() {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final ByteBuf retain(int n2) {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    @Override
    public final boolean release() {
        ReplayingDecoderByteBuf.reject();
        return false;
    }

    @Override
    public final boolean release(int n2) {
        ReplayingDecoderByteBuf.reject();
        return false;
    }

    @Override
    public final ByteBuf unwrap() {
        ReplayingDecoderByteBuf.reject();
        return this;
    }

    private static void reject() {
        throw new UnsupportedOperationException("not a replayable operation");
    }

    static {
        EMPTY_BUFFER.terminate();
    }
}

