/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.base64;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.handler.codec.base64.Base64Dialect;

public final class Base64 {
    private static final int MAX_LINE_LENGTH = 76;
    private static final byte EQUALS_SIGN = 61;
    private static final byte NEW_LINE = 10;
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;

    private static byte[] alphabet(Base64Dialect base64Dialect) {
        if (base64Dialect == null) {
            throw new NullPointerException("dialect");
        }
        return base64Dialect.alphabet;
    }

    private static byte[] decodabet(Base64Dialect base64Dialect) {
        if (base64Dialect == null) {
            throw new NullPointerException("dialect");
        }
        return base64Dialect.decodabet;
    }

    private static boolean breakLines(Base64Dialect base64Dialect) {
        if (base64Dialect == null) {
            throw new NullPointerException("dialect");
        }
        return base64Dialect.breakLinesByDefault;
    }

    public static ByteBuf encode(ByteBuf byteBuf) {
        return Base64.encode(byteBuf, Base64Dialect.STANDARD);
    }

    public static ByteBuf encode(ByteBuf byteBuf, Base64Dialect base64Dialect) {
        return Base64.encode(byteBuf, Base64.breakLines(base64Dialect), base64Dialect);
    }

    public static ByteBuf encode(ByteBuf byteBuf, boolean bl) {
        return Base64.encode(byteBuf, bl, Base64Dialect.STANDARD);
    }

    public static ByteBuf encode(ByteBuf byteBuf, boolean bl, Base64Dialect base64Dialect) {
        if (byteBuf == null) {
            throw new NullPointerException("src");
        }
        ByteBuf byteBuf2 = byteBuf;
        ByteBuf byteBuf3 = Base64.encode(byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes(), bl, base64Dialect);
        ByteBuf byteBuf4 = byteBuf;
        byteBuf4.readerIndex(byteBuf4.writerIndex());
        return byteBuf3;
    }

    public static ByteBuf encode(ByteBuf byteBuf, int n2, int n3) {
        return Base64.encode(byteBuf, n2, n3, Base64Dialect.STANDARD);
    }

    public static ByteBuf encode(ByteBuf byteBuf, int n2, int n3, Base64Dialect base64Dialect) {
        return Base64.encode(byteBuf, n2, n3, Base64.breakLines(base64Dialect), base64Dialect);
    }

    public static ByteBuf encode(ByteBuf byteBuf, int n2, int n3, boolean bl) {
        return Base64.encode(byteBuf, n2, n3, bl, Base64Dialect.STANDARD);
    }

    public static ByteBuf encode(ByteBuf byteBuf, int n2, int n3, boolean bl, Base64Dialect base64Dialect) {
        return Base64.encode(byteBuf, n2, n3, bl, base64Dialect, byteBuf.alloc());
    }

    public static ByteBuf encode(ByteBuf byteBuf, int n2, int n3, boolean bl, Base64Dialect base64Dialect, ByteBufAllocator object) {
        if (byteBuf == null) {
            throw new NullPointerException("src");
        }
        if (base64Dialect == null) {
            throw new NullPointerException("dialect");
        }
        int n4 = (n3 << 2) / 3;
        object = object.buffer(n4 + (n3 % 3 > 0 ? 4 : 0) + (bl ? n4 / 76 : 0)).order(byteBuf.order());
        n4 = 0;
        int n5 = 0;
        int n6 = n3 - 2;
        int n7 = 0;
        while (n4 < n6) {
            Base64.encode3to4(byteBuf, n4 + n2, 3, (ByteBuf)object, n5, base64Dialect);
            if (bl && (n7 += 4) == 76) {
                ((ByteBuf)object).setByte(n5 + 4, 10);
                ++n5;
                n7 = 0;
            }
            n4 += 3;
            n5 += 4;
        }
        if (n4 < n3) {
            Base64.encode3to4(byteBuf, n4 + n2, n3 - n4, (ByteBuf)object, n5, base64Dialect);
            n5 += 4;
        }
        if (n5 > 1 && ((ByteBuf)object).getByte(n5 - 1) == 10) {
            --n5;
        }
        return ((ByteBuf)object).slice(0, n5);
    }

    private static void encode3to4(ByteBuf byteBuf, int n2, int n3, ByteBuf byteBuf2, int n4, Base64Dialect object) {
        object = Base64.alphabet(object);
        int n5 = (n3 > 0 ? byteBuf.getByte(n2) << 24 >>> 8 : 0) | (n3 > 1 ? byteBuf.getByte(n2 + 1) << 24 >>> 16 : 0) | (n3 > 2 ? byteBuf.getByte(n2 + 2) << 24 >>> 24 : 0);
        switch (n3) {
            case 3: {
                byteBuf2.setByte(n4, (int)object[n5 >>> 18]);
                byteBuf2.setByte(n4 + 1, (int)object[n5 >>> 12 & 0x3F]);
                byteBuf2.setByte(n4 + 2, (int)object[n5 >>> 6 & 0x3F]);
                byteBuf2.setByte(n4 + 3, (int)object[n5 & 0x3F]);
                return;
            }
            case 2: {
                byteBuf2.setByte(n4, (int)object[n5 >>> 18]);
                byteBuf2.setByte(n4 + 1, (int)object[n5 >>> 12 & 0x3F]);
                byteBuf2.setByte(n4 + 2, (int)object[n5 >>> 6 & 0x3F]);
                byteBuf2.setByte(n4 + 3, 61);
                return;
            }
            case 1: {
                byteBuf2.setByte(n4, (int)object[n5 >>> 18]);
                byteBuf2.setByte(n4 + 1, (int)object[n5 >>> 12 & 0x3F]);
                byteBuf2.setByte(n4 + 2, 61);
                byteBuf2.setByte(n4 + 3, 61);
            }
        }
    }

    public static ByteBuf decode(ByteBuf byteBuf) {
        return Base64.decode(byteBuf, Base64Dialect.STANDARD);
    }

    public static ByteBuf decode(ByteBuf byteBuf, Base64Dialect object) {
        if (byteBuf == null) {
            throw new NullPointerException("src");
        }
        ByteBuf byteBuf2 = byteBuf;
        object = Base64.decode(byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes(), object);
        ByteBuf byteBuf3 = byteBuf;
        byteBuf3.readerIndex(byteBuf3.writerIndex());
        return object;
    }

    public static ByteBuf decode(ByteBuf byteBuf, int n2, int n3) {
        return Base64.decode(byteBuf, n2, n3, Base64Dialect.STANDARD);
    }

    public static ByteBuf decode(ByteBuf byteBuf, int n2, int n3, Base64Dialect base64Dialect) {
        return Base64.decode(byteBuf, n2, n3, base64Dialect, byteBuf.alloc());
    }

    public static ByteBuf decode(ByteBuf byteBuf, int n2, int n3, Base64Dialect base64Dialect, ByteBufAllocator object) {
        if (byteBuf == null) {
            throw new NullPointerException("src");
        }
        if (base64Dialect == null) {
            throw new NullPointerException("dialect");
        }
        byte[] byArray = Base64.decodabet(base64Dialect);
        int n4 = n3 * 3 / 4;
        object = object.buffer(n4).order(byteBuf.order());
        n4 = 0;
        byte[] byArray2 = new byte[4];
        int n5 = 0;
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            byte by = (byte)(byteBuf.getByte(i2) & 0x7F);
            byte by2 = byArray[by];
            if (by2 >= -5) {
                if (by2 < -1) continue;
                byArray2[n5++] = by;
                if (n5 <= 3) continue;
                n4 += Base64.decode4to3(byArray2, 0, (ByteBuf)object, n4, base64Dialect);
                n5 = 0;
                if (by != 61) continue;
                break;
            }
            throw new IllegalArgumentException("bad Base64 input character at " + i2 + ": " + byteBuf.getUnsignedByte(i2) + " (decimal)");
        }
        return ((ByteBuf)object).slice(0, n4);
    }

    private static int decode4to3(byte[] byArray, int n2, ByteBuf byteBuf, int n3, Base64Dialect object) {
        int n4;
        object = Base64.decodabet(object);
        if (byArray[n2 + 2] == 61) {
            int n5 = (object[byArray[n2]] & 0xFF) << 18 | (object[byArray[n2 + 1]] & 0xFF) << 12;
            byteBuf.setByte(n3, (byte)(n5 >>> 16));
            return 1;
        }
        if (byArray[n2 + 3] == 61) {
            int n6 = (object[byArray[n2]] & 0xFF) << 18 | (object[byArray[n2 + 1]] & 0xFF) << 12 | (object[byArray[n2 + 2]] & 0xFF) << 6;
            byteBuf.setByte(n3, (byte)(n6 >>> 16));
            byteBuf.setByte(n3 + 1, (byte)(n6 >>> 8));
            return 2;
        }
        try {
            n4 = (object[byArray[n2]] & 0xFF) << 18 | (object[byArray[n2 + 1]] & 0xFF) << 12 | (object[byArray[n2 + 2]] & 0xFF) << 6 | object[byArray[n2 + 3]] & 0xFF;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("not encoded in Base64");
        }
        byteBuf.setByte(n3, (byte)(n4 >> 16));
        byteBuf.setByte(n3 + 1, (byte)(n4 >> 8));
        byteBuf.setByte(n3 + 2, (byte)n4);
        return 3;
    }

    private Base64() {
    }
}

