/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.compression;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.ZlibDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.ZlibUtil;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.ZlibWrapper;
import com.jcraft.jzlib.Inflater;
import com.jcraft.jzlib.JZlib;
import java.util.List;

public class JZlibDecoder
extends ZlibDecoder {
    private final Inflater z = new Inflater();
    private byte[] dictionary;
    private volatile boolean finished;

    public JZlibDecoder() {
        this(ZlibWrapper.ZLIB);
    }

    public JZlibDecoder(ZlibWrapper zlibWrapper) {
        if (zlibWrapper == null) {
            throw new NullPointerException("wrapper");
        }
        int n2 = this.z.init(ZlibUtil.convertWrapperType(zlibWrapper));
        if (n2 != 0) {
            ZlibUtil.fail(this.z, "initialization failure", n2);
        }
    }

    public JZlibDecoder(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("dictionary");
        }
        this.dictionary = byArray;
        int n2 = this.z.inflateInit(JZlib.W_ZLIB);
        if (n2 != 0) {
            ZlibUtil.fail(this.z, "initialization failure", n2);
        }
    }

    @Override
    public boolean isClosed() {
        return this.finished;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void decode(ChannelHandlerContext object, ByteBuf byteBuf, List<Object> list) {
        if (this.finished) {
            ByteBuf byteBuf2 = byteBuf;
            byteBuf2.skipBytes(byteBuf2.readableBytes());
            return;
        }
        int n2 = byteBuf.readableBytes();
        if (n2 == 0) {
            return;
        }
        try {
            this.z.avail_in = n2;
            if (byteBuf.hasArray()) {
                this.z.next_in = byteBuf.array();
                this.z.next_in_index = byteBuf.arrayOffset() + byteBuf.readerIndex();
            } else {
                byte[] byArray = new byte[n2];
                ByteBuf byteBuf3 = byteBuf;
                byteBuf3.getBytes(byteBuf3.readerIndex(), byArray);
                this.z.next_in = byArray;
                this.z.next_in_index = 0;
            }
            int n3 = this.z.next_in_index;
            object = object.alloc().heapBuffer(n2 <<= 1);
            try {
                block12: while (true) {
                    this.z.avail_out = n2;
                    ((ByteBuf)object).ensureWritable(n2);
                    this.z.next_out = ((ByteBuf)object).array();
                    int n4 = this.z.next_out_index = ((ByteBuf)object).arrayOffset() + ((ByteBuf)object).writerIndex();
                    int n5 = this.z.inflate(2);
                    n4 = this.z.next_out_index - n4;
                    if (n4 > 0) {
                        Object object2 = object;
                        ((ByteBuf)object2).writerIndex(((ByteBuf)object2).writerIndex() + n4);
                    }
                    switch (n5) {
                        case 2: {
                            if (this.dictionary == null) break;
                            n5 = this.z.inflateSetDictionary(this.dictionary, this.dictionary.length);
                            if (n5 == 0) continue block12;
                            ZlibUtil.fail(this.z, "failed to set the dictionary", n5);
                            continue block12;
                        }
                        case 1: {
                            this.finished = true;
                            this.z.inflateEnd();
                            return;
                        }
                        case 0: {
                            continue block12;
                        }
                        case -5: {
                            if (this.z.avail_in > 0) continue block12;
                            return;
                        }
                    }
                    ZlibUtil.fail(this.z, "decompression failure", n5);
                }
            }
            finally {
                byteBuf.skipBytes(this.z.next_in_index - n3);
                if (((ByteBuf)object).isReadable()) {
                    list.add(object);
                } else {
                    object.release();
                }
            }
        }
        finally {
            this.z.next_in = null;
            this.z.next_out = null;
        }
    }
}

