/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.compression;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.JZlibEncoder$1;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.JZlibEncoder$2;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.JZlibEncoder$3;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.ZlibEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.ZlibUtil;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.ZlibWrapper;
import com.aliyun.openservices.shade.io.netty.util.concurrent.EventExecutor;
import com.aliyun.openservices.shade.io.netty.util.internal.EmptyArrays;
import com.jcraft.jzlib.Deflater;
import com.jcraft.jzlib.JZlib;
import java.util.concurrent.TimeUnit;

public class JZlibEncoder
extends ZlibEncoder {
    private final int wrapperOverhead;
    private final Deflater z = new Deflater();
    private volatile boolean finished;
    private volatile ChannelHandlerContext ctx;

    public JZlibEncoder() {
        this(6);
    }

    public JZlibEncoder(int n2) {
        this(ZlibWrapper.ZLIB, n2);
    }

    public JZlibEncoder(ZlibWrapper zlibWrapper) {
        this(zlibWrapper, 6);
    }

    public JZlibEncoder(ZlibWrapper zlibWrapper, int n2) {
        this(zlibWrapper, n2, 15, 8);
    }

    public JZlibEncoder(ZlibWrapper zlibWrapper, int n2, int n3, int n4) {
        if (n2 < 0 || n2 > 9) {
            throw new IllegalArgumentException("compressionLevel: " + n2 + " (expected: 0-9)");
        }
        if (n3 < 9 || n3 > 15) {
            throw new IllegalArgumentException("windowBits: " + n3 + " (expected: 9-15)");
        }
        if (n4 <= 0 || n4 > 9) {
            throw new IllegalArgumentException("memLevel: " + n4 + " (expected: 1-9)");
        }
        if (zlibWrapper == null) {
            throw new NullPointerException("wrapper");
        }
        if (zlibWrapper == ZlibWrapper.ZLIB_OR_NONE) {
            throw new IllegalArgumentException("wrapper '" + (Object)((Object)ZlibWrapper.ZLIB_OR_NONE) + "' is not allowed for compression.");
        }
        if ((n2 = this.z.init(n2, n3, n4, ZlibUtil.convertWrapperType(zlibWrapper))) != 0) {
            ZlibUtil.fail(this.z, "initialization failure", n2);
        }
        this.wrapperOverhead = ZlibUtil.wrapperOverhead(zlibWrapper);
    }

    public JZlibEncoder(byte[] byArray) {
        this(6, byArray);
    }

    public JZlibEncoder(int n2, byte[] byArray) {
        this(n2, 15, 8, byArray);
    }

    public JZlibEncoder(int n2, int n3, int n4, byte[] byArray) {
        if (n2 < 0 || n2 > 9) {
            throw new IllegalArgumentException("compressionLevel: " + n2 + " (expected: 0-9)");
        }
        if (n3 < 9 || n3 > 15) {
            throw new IllegalArgumentException("windowBits: " + n3 + " (expected: 9-15)");
        }
        if (n4 <= 0 || n4 > 9) {
            throw new IllegalArgumentException("memLevel: " + n4 + " (expected: 1-9)");
        }
        if (byArray == null) {
            throw new NullPointerException("dictionary");
        }
        if ((n2 = this.z.deflateInit(n2, n3, n4, JZlib.W_ZLIB)) != 0) {
            ZlibUtil.fail(this.z, "initialization failure", n2);
        } else {
            n2 = this.z.deflateSetDictionary(byArray, byArray.length);
            if (n2 != 0) {
                ZlibUtil.fail(this.z, "failed to set the dictionary", n2);
            }
        }
        this.wrapperOverhead = ZlibUtil.wrapperOverhead(ZlibWrapper.ZLIB);
    }

    @Override
    public ChannelFuture close() {
        JZlibEncoder jZlibEncoder = this;
        return ((ZlibEncoder)jZlibEncoder).close(jZlibEncoder.ctx().channel().newPromise());
    }

    @Override
    public ChannelFuture close(ChannelPromise channelPromise) {
        Object object = this.ctx();
        EventExecutor eventExecutor = object.executor();
        if (eventExecutor.inEventLoop()) {
            return this.finishEncode((ChannelHandlerContext)object, channelPromise);
        }
        object = object.newPromise();
        eventExecutor.execute(new JZlibEncoder$1(this, (ChannelPromise)object, channelPromise));
        return object;
    }

    private ChannelHandlerContext ctx() {
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            throw new IllegalStateException("not added to a pipeline");
        }
        return channelHandlerContext;
    }

    @Override
    public boolean isClosed() {
        return this.finished;
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) {
        if (this.finished) {
            byteBuf2.writeBytes(byteBuf);
            return;
        }
        int n2 = byteBuf.readableBytes();
        if (n2 == 0) {
            return;
        }
        try {
            int n3;
            int n4 = byteBuf.hasArray();
            this.z.avail_in = n2;
            if (n4 != 0) {
                this.z.next_in = byteBuf.array();
                this.z.next_in_index = byteBuf.arrayOffset() + byteBuf.readerIndex();
            } else {
                byte[] byArray = new byte[n2];
                ByteBuf byteBuf3 = byteBuf;
                byteBuf3.getBytes(byteBuf3.readerIndex(), byArray);
                this.z.next_in = byArray;
                this.z.next_in_index = 0;
            }
            n4 = this.z.next_in_index;
            n2 = (int)Math.ceil((double)n2 * 1.001) + 12 + this.wrapperOverhead;
            byteBuf2.ensureWritable(n2);
            this.z.avail_out = n2;
            this.z.next_out = byteBuf2.array();
            n2 = this.z.next_out_index = byteBuf2.arrayOffset() + byteBuf2.writerIndex();
            try {
                n3 = this.z.deflate(2);
            }
            finally {
                byteBuf.skipBytes(this.z.next_in_index - n4);
            }
            if (n3 != 0) {
                ZlibUtil.fail(this.z, "compression failure", n3);
            }
            if ((n2 = this.z.next_out_index - n2) > 0) {
                ByteBuf byteBuf4 = byteBuf2;
                byteBuf4.writerIndex(byteBuf4.writerIndex() + n2);
            }
            return;
        }
        finally {
            this.z.next_in = null;
            this.z.next_out = null;
        }
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        ChannelHandlerContext channelHandlerContext2 = channelHandlerContext;
        ChannelFuture channelFuture = this.finishEncode(channelHandlerContext2, channelHandlerContext2.newPromise());
        channelFuture.addListener(new JZlibEncoder$2(this, channelHandlerContext, channelPromise));
        if (!channelFuture.isDone()) {
            channelHandlerContext.executor().schedule(new JZlibEncoder$3(this, channelHandlerContext, channelPromise), 10L, TimeUnit.SECONDS);
        }
    }

    private ChannelFuture finishEncode(ChannelHandlerContext object, ChannelPromise channelPromise) {
        Object object2;
        if (this.finished) {
            channelPromise.setSuccess();
            return channelPromise;
        }
        this.finished = true;
        try {
            this.z.next_in = EmptyArrays.EMPTY_BYTES;
            this.z.next_in_index = 0;
            this.z.avail_in = 0;
            object2 = new byte[32];
            this.z.next_out = object2;
            this.z.next_out_index = 0;
            this.z.avail_out = ((byte[])object2).length;
            int n2 = this.z.deflate(4);
            if (n2 != 0 && n2 != 1) {
                channelPromise.setFailure(ZlibUtil.deflaterException(this.z, "compression failure", n2));
                object = channelPromise;
                return object;
            }
            object2 = this.z.next_out_index != 0 ? (Object)Unpooled.wrappedBuffer((byte[])object2, 0, this.z.next_out_index) : (Object)Unpooled.EMPTY_BUFFER;
        }
        finally {
            this.z.deflateEnd();
            this.z.next_in = null;
            this.z.next_out = null;
        }
        return object.writeAndFlush(object2, channelPromise);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
    }

    static /* synthetic */ ChannelHandlerContext access$000(JZlibEncoder jZlibEncoder) {
        return jZlibEncoder.ctx();
    }

    static /* synthetic */ ChannelFuture access$100(JZlibEncoder jZlibEncoder, ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        return jZlibEncoder.finishEncode(channelHandlerContext, channelPromise);
    }
}

