/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.compression;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.DecompressionException;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.JdkZlibDecoder$GzipState;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.ZlibDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.ZlibWrapper;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class JdkZlibDecoder
extends ZlibDecoder {
    private static final int FHCRC = 2;
    private static final int FEXTRA = 4;
    private static final int FNAME = 8;
    private static final int FCOMMENT = 16;
    private static final int FRESERVED = 224;
    private Inflater inflater;
    private final byte[] dictionary;
    private final CRC32 crc;
    private JdkZlibDecoder$GzipState gzipState = JdkZlibDecoder$GzipState.HEADER_START;
    private int flags = -1;
    private int xlen = -1;
    private volatile boolean finished;
    private boolean decideZlibOrNone;

    public JdkZlibDecoder() {
        this(ZlibWrapper.ZLIB, null);
    }

    public JdkZlibDecoder(byte[] byArray) {
        this(ZlibWrapper.ZLIB, byArray);
    }

    public JdkZlibDecoder(ZlibWrapper zlibWrapper) {
        this(zlibWrapper, null);
    }

    private JdkZlibDecoder(ZlibWrapper zlibWrapper, byte[] byArray) {
        if (zlibWrapper == null) {
            throw new NullPointerException("wrapper");
        }
        switch (zlibWrapper) {
            case GZIP: {
                this.inflater = new Inflater(true);
                this.crc = new CRC32();
                break;
            }
            case NONE: {
                this.inflater = new Inflater(true);
                this.crc = null;
                break;
            }
            case ZLIB: {
                this.inflater = new Inflater();
                this.crc = null;
                break;
            }
            case ZLIB_OR_NONE: {
                this.decideZlibOrNone = true;
                this.crc = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only GZIP or ZLIB is supported, but you used " + (Object)((Object)zlibWrapper));
            }
        }
        this.dictionary = byArray;
    }

    @Override
    public boolean isClosed() {
        return this.finished;
    }

    @Override
    public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        ByteBuf byteBuf2;
        block28: {
            int n2;
            if (this.finished) {
                ByteBuf byteBuf3 = byteBuf;
                byteBuf3.skipBytes(byteBuf3.readableBytes());
                return;
            }
            int n3 = byteBuf.readableBytes();
            if (n3 == 0) {
                return;
            }
            if (this.decideZlibOrNone) {
                if (n3 < 2) {
                    return;
                }
                ByteBuf byteBuf4 = byteBuf;
                n2 = !JdkZlibDecoder.looksLikeZlib(byteBuf4.getShort(byteBuf4.readerIndex())) ? 1 : 0;
                this.inflater = new Inflater(n2 != 0);
                this.decideZlibOrNone = false;
            }
            if (this.crc != null) {
                switch (this.gzipState) {
                    case FOOTER_START: {
                        if (this.readGZIPFooter(byteBuf)) {
                            this.finished = true;
                        }
                        return;
                    }
                }
                if (this.gzipState != JdkZlibDecoder$GzipState.HEADER_END && !this.readGZIPHeader(byteBuf)) {
                    return;
                }
                n3 = byteBuf.readableBytes();
            }
            if (byteBuf.hasArray()) {
                this.inflater.setInput(byteBuf.array(), byteBuf.arrayOffset() + byteBuf.readerIndex(), n3);
            } else {
                byte[] byArray = new byte[n3];
                ByteBuf byteBuf5 = byteBuf;
                byteBuf5.getBytes(byteBuf5.readerIndex(), byArray);
                this.inflater.setInput(byArray);
            }
            n2 = this.inflater.getRemaining() << 1;
            byteBuf2 = channelHandlerContext.alloc().heapBuffer(n2);
            try {
                boolean bl = false;
                byte[] byArray = byteBuf2.array();
                while (!this.inflater.needsInput()) {
                    int n4 = byteBuf2.writerIndex();
                    int n5 = byteBuf2.arrayOffset() + n4;
                    int n6 = byteBuf2.writableBytes();
                    if (n6 == 0) {
                        list.add(byteBuf2);
                        byteBuf2 = channelHandlerContext.alloc().heapBuffer(n2);
                        byArray = byteBuf2.array();
                        continue;
                    }
                    if ((n6 = this.inflater.inflate(byArray, n5, n6)) > 0) {
                        byteBuf2.writerIndex(n4 + n6);
                        if (this.crc != null) {
                            this.crc.update(byArray, n5, n6);
                        }
                    } else if (this.inflater.needsDictionary()) {
                        if (this.dictionary == null) {
                            throw new DecompressionException("decompression failure, unable to set dictionary as non was specified");
                        }
                        this.inflater.setDictionary(this.dictionary);
                    }
                    if (!this.inflater.finished()) continue;
                    if (this.crc == null) {
                        this.finished = true;
                        break;
                    }
                    bl = true;
                    break;
                }
                byteBuf.skipBytes(n3 - this.inflater.getRemaining());
                if (bl) {
                    this.gzipState = JdkZlibDecoder$GzipState.FOOTER_START;
                    if (this.readGZIPFooter(byteBuf)) {
                        this.finished = true;
                    }
                }
                if (!byteBuf2.isReadable()) break block28;
                list.add(byteBuf2);
            }
            catch (DataFormatException dataFormatException) {
                try {
                    throw new DecompressionException("decompression failure", dataFormatException);
                }
                catch (Throwable throwable) {
                    if (byteBuf2.isReadable()) {
                        list.add(byteBuf2);
                    } else {
                        byteBuf2.release();
                    }
                    throw throwable;
                }
            }
            return;
        }
        byteBuf2.release();
        return;
    }

    @Override
    public void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
        super.handlerRemoved0(channelHandlerContext);
        if (this.inflater != null) {
            this.inflater.end();
        }
    }

    private boolean readGZIPHeader(ByteBuf byteBuf) {
        switch (this.gzipState) {
            case HEADER_START: {
                if (byteBuf.readableBytes() < 10) {
                    return false;
                }
                short s2 = byteBuf.readByte();
                short s3 = byteBuf.readByte();
                if (s2 != 31) {
                    throw new DecompressionException("Input is not in the GZIP format");
                }
                this.crc.update(s2);
                this.crc.update(s3);
                s2 = byteBuf.readUnsignedByte();
                if (s2 != 8) {
                    throw new DecompressionException("Unsupported compression method " + s2 + " in the GZIP header");
                }
                this.crc.update(s2);
                this.flags = byteBuf.readUnsignedByte();
                this.crc.update(this.flags);
                if ((this.flags & 0xE0) != 0) {
                    throw new DecompressionException("Reserved flags are set in the GZIP header");
                }
                this.crc.update(byteBuf.readByte());
                this.crc.update(byteBuf.readByte());
                this.crc.update(byteBuf.readByte());
                this.crc.update(byteBuf.readByte());
                this.crc.update(byteBuf.readUnsignedByte());
                this.crc.update(byteBuf.readUnsignedByte());
                this.gzipState = JdkZlibDecoder$GzipState.FLG_READ;
            }
            case FLG_READ: {
                short s3;
                short s2;
                if ((this.flags & 4) != 0) {
                    if (byteBuf.readableBytes() < 2) {
                        return false;
                    }
                    s2 = byteBuf.readUnsignedByte();
                    s3 = byteBuf.readUnsignedByte();
                    this.crc.update(s2);
                    this.crc.update(s3);
                    this.xlen |= s2 << 8 | s3;
                }
                this.gzipState = JdkZlibDecoder$GzipState.XLEN_READ;
            }
            case XLEN_READ: {
                if (this.xlen != -1) {
                    if (byteBuf.readableBytes() < this.xlen) {
                        return false;
                    }
                    byte[] byArray = new byte[this.xlen];
                    byteBuf.readBytes(byArray);
                    this.crc.update(byArray);
                }
                this.gzipState = JdkZlibDecoder$GzipState.SKIP_FNAME;
            }
            case SKIP_FNAME: {
                if ((this.flags & 8) != 0) {
                    short s4;
                    if (!byteBuf.isReadable()) {
                        return false;
                    }
                    do {
                        s4 = byteBuf.readUnsignedByte();
                        this.crc.update(s4);
                    } while (s4 != 0 && byteBuf.isReadable());
                }
                this.gzipState = JdkZlibDecoder$GzipState.SKIP_COMMENT;
            }
            case SKIP_COMMENT: {
                if ((this.flags & 0x10) != 0) {
                    short s5;
                    if (!byteBuf.isReadable()) {
                        return false;
                    }
                    do {
                        s5 = byteBuf.readUnsignedByte();
                        this.crc.update(s5);
                    } while (s5 != 0 && byteBuf.isReadable());
                }
                this.gzipState = JdkZlibDecoder$GzipState.PROCESS_FHCRC;
            }
            case PROCESS_FHCRC: {
                if ((this.flags & 2) != 0) {
                    if (byteBuf.readableBytes() < 4) {
                        return false;
                    }
                    this.verifyCrc(byteBuf);
                }
                this.crc.reset();
                this.gzipState = JdkZlibDecoder$GzipState.HEADER_END;
            }
            case HEADER_END: {
                return true;
            }
        }
        throw new IllegalStateException();
    }

    private boolean readGZIPFooter(ByteBuf byteBuf) {
        int n2;
        if (byteBuf.readableBytes() < 8) {
            return false;
        }
        this.verifyCrc(byteBuf);
        int n3 = 0;
        for (n2 = 0; n2 < 4; ++n2) {
            n3 |= byteBuf.readUnsignedByte() << (n2 << 3);
        }
        n2 = this.inflater.getTotalOut();
        if (n3 != n2) {
            throw new DecompressionException("Number of bytes mismatch. Expected: " + n3 + ", Got: " + n2);
        }
        return true;
    }

    private void verifyCrc(ByteBuf byteBuf) {
        long l2 = 0L;
        for (int i2 = 0; i2 < 4; ++i2) {
            l2 |= (long)byteBuf.readUnsignedByte() << (i2 << 3);
        }
        long l3 = this.crc.getValue();
        if (l2 != l3) {
            throw new DecompressionException("CRC value missmatch. Expected: " + l2 + ", Got: " + l3);
        }
    }

    private static boolean looksLikeZlib(short s2) {
        return (s2 & 0x7800) == 30720 && s2 % 31 == 0;
    }
}

