/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.compression;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.JdkZlibEncoder$1;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.JdkZlibEncoder$2;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.JdkZlibEncoder$3;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.ZlibEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.ZlibWrapper;
import com.aliyun.openservices.shade.io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.TimeUnit;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public class JdkZlibEncoder
extends ZlibEncoder {
    private final ZlibWrapper wrapper;
    private final Deflater deflater;
    private volatile boolean finished;
    private volatile ChannelHandlerContext ctx;
    private final CRC32 crc = new CRC32();
    private static final byte[] gzipHeader = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};
    private boolean writeHeader = true;

    public JdkZlibEncoder() {
        this(6);
    }

    public JdkZlibEncoder(int n2) {
        this(ZlibWrapper.ZLIB, n2);
    }

    public JdkZlibEncoder(ZlibWrapper zlibWrapper) {
        this(zlibWrapper, 6);
    }

    public JdkZlibEncoder(ZlibWrapper zlibWrapper, int n2) {
        if (n2 < 0 || n2 > 9) {
            throw new IllegalArgumentException("compressionLevel: " + n2 + " (expected: 0-9)");
        }
        if (zlibWrapper == null) {
            throw new NullPointerException("wrapper");
        }
        if (zlibWrapper == ZlibWrapper.ZLIB_OR_NONE) {
            throw new IllegalArgumentException("wrapper '" + (Object)((Object)ZlibWrapper.ZLIB_OR_NONE) + "' is not allowed for compression.");
        }
        this.wrapper = zlibWrapper;
        this.deflater = new Deflater(n2, zlibWrapper != ZlibWrapper.ZLIB);
    }

    public JdkZlibEncoder(byte[] byArray) {
        this(6, byArray);
    }

    public JdkZlibEncoder(int n2, byte[] byArray) {
        if (n2 < 0 || n2 > 9) {
            throw new IllegalArgumentException("compressionLevel: " + n2 + " (expected: 0-9)");
        }
        if (byArray == null) {
            throw new NullPointerException("dictionary");
        }
        this.wrapper = ZlibWrapper.ZLIB;
        this.deflater = new Deflater(n2);
        this.deflater.setDictionary(byArray);
    }

    @Override
    public ChannelFuture close() {
        JdkZlibEncoder jdkZlibEncoder = this;
        return ((ZlibEncoder)jdkZlibEncoder).close(jdkZlibEncoder.ctx().newPromise());
    }

    @Override
    public ChannelFuture close(ChannelPromise channelPromise) {
        Object object = this.ctx();
        EventExecutor eventExecutor = object.executor();
        if (eventExecutor.inEventLoop()) {
            return this.finishEncode((ChannelHandlerContext)object, channelPromise);
        }
        object = object.newPromise();
        eventExecutor.execute(new JdkZlibEncoder$1(this, (ChannelPromise)object, channelPromise));
        return object;
    }

    private ChannelHandlerContext ctx() {
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            throw new IllegalStateException("not added to a pipeline");
        }
        return channelHandlerContext;
    }

    @Override
    public boolean isClosed() {
        return this.finished;
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n2;
        byte[] byArray;
        if (this.finished) {
            byteBuf2.writeBytes(byteBuf);
            return;
        }
        int n3 = byteBuf.readableBytes();
        if (n3 == 0) {
            return;
        }
        if (byteBuf.hasArray()) {
            byArray = byteBuf.array();
            n2 = byteBuf.arrayOffset() + byteBuf.readerIndex();
            byteBuf.skipBytes(n3);
        } else {
            byArray = new byte[n3];
            byteBuf.readBytes(byArray);
            n2 = 0;
        }
        if (this.writeHeader) {
            this.writeHeader = false;
            if (this.wrapper == ZlibWrapper.GZIP) {
                byteBuf2.writeBytes(gzipHeader);
            }
        }
        if (this.wrapper == ZlibWrapper.GZIP) {
            this.crc.update(byArray, n2, n3);
        }
        this.deflater.setInput(byArray, n2, n3);
        while (!this.deflater.needsInput()) {
            this.deflate(byteBuf2);
        }
    }

    @Override
    protected final ByteBuf allocateBuffer(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, boolean bl) {
        int n2 = (int)Math.ceil((double)byteBuf.readableBytes() * 1.001) + 12;
        if (this.writeHeader) {
            switch (this.wrapper) {
                case GZIP: {
                    n2 += gzipHeader.length;
                    break;
                }
                case ZLIB: {
                    n2 += 2;
                }
            }
        }
        return channelHandlerContext.alloc().heapBuffer(n2);
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        ChannelHandlerContext channelHandlerContext2 = channelHandlerContext;
        ChannelFuture channelFuture = this.finishEncode(channelHandlerContext2, channelHandlerContext2.newPromise());
        channelFuture.addListener(new JdkZlibEncoder$2(this, channelHandlerContext, channelPromise));
        if (!channelFuture.isDone()) {
            channelHandlerContext.executor().schedule(new JdkZlibEncoder$3(this, channelHandlerContext, channelPromise), 10L, TimeUnit.SECONDS);
        }
    }

    private ChannelFuture finishEncode(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        if (this.finished) {
            channelPromise.setSuccess();
            return channelPromise;
        }
        this.finished = true;
        ByteBuf byteBuf = channelHandlerContext.alloc().heapBuffer();
        if (this.writeHeader && this.wrapper == ZlibWrapper.GZIP) {
            this.writeHeader = false;
            byteBuf.writeBytes(gzipHeader);
        }
        this.deflater.finish();
        while (!this.deflater.finished()) {
            this.deflate(byteBuf);
            if (byteBuf.isWritable()) continue;
            channelHandlerContext.write(byteBuf);
            byteBuf = channelHandlerContext.alloc().heapBuffer();
        }
        if (this.wrapper == ZlibWrapper.GZIP) {
            int n2 = (int)this.crc.getValue();
            int n3 = this.deflater.getTotalIn();
            byteBuf.writeByte(n2);
            byteBuf.writeByte(n2 >>> 8);
            byteBuf.writeByte(n2 >>> 16);
            byteBuf.writeByte(n2 >>> 24);
            byteBuf.writeByte(n3);
            byteBuf.writeByte(n3 >>> 8);
            byteBuf.writeByte(n3 >>> 16);
            byteBuf.writeByte(n3 >>> 24);
        }
        this.deflater.end();
        return channelHandlerContext.writeAndFlush(byteBuf, channelPromise);
    }

    private void deflate(ByteBuf byteBuf) {
        int n2;
        do {
            int n3 = byteBuf.writerIndex();
            n2 = this.deflater.deflate(byteBuf.array(), byteBuf.arrayOffset() + n3, byteBuf.writableBytes(), 2);
            byteBuf.writerIndex(n3 + n2);
        } while (n2 > 0);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
    }

    static /* synthetic */ ChannelHandlerContext access$000(JdkZlibEncoder jdkZlibEncoder) {
        return jdkZlibEncoder.ctx();
    }

    static /* synthetic */ ChannelFuture access$100(JdkZlibEncoder jdkZlibEncoder, ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        return jdkZlibEncoder.finishEncode(channelHandlerContext, channelPromise);
    }
}

