/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.compression;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufUtil;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.ByteToMessageDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.DecompressionException;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.Snappy;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.SnappyFramedDecoder$1;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.SnappyFramedDecoder$ChunkType;
import java.util.Arrays;
import java.util.List;

public class SnappyFramedDecoder
extends ByteToMessageDecoder {
    private static final byte[] SNAPPY = new byte[]{115, 78, 97, 80, 112, 89};
    private static final int MAX_UNCOMPRESSED_DATA_SIZE = 65540;
    private final Snappy snappy = new Snappy();
    private final boolean validateChecksums;
    private boolean started;
    private boolean corrupted;

    public SnappyFramedDecoder() {
        this(false);
    }

    public SnappyFramedDecoder(boolean bl) {
        this.validateChecksums = bl;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void decode(ChannelHandlerContext var1_1, ByteBuf var2_3, List<Object> var3_4) {
        if (this.corrupted) {
            v0 = var2_3;
            v0.skipBytes(v0.readableBytes());
            return;
        }
        try {
            var4_5 = var2_3.readerIndex();
            var5_7 = var2_3.readableBytes();
            if (var5_7 < 4) {
                return;
            }
            var6_8 = var2_3.getUnsignedByte(var4_5);
            var7_9 = SnappyFramedDecoder.mapChunkType((byte)var6_8);
            var4_5 = ByteBufUtil.swapMedium(var2_3.getUnsignedMedium(var4_5 + 1));
            switch (SnappyFramedDecoder$1.$SwitchMap$io$netty$handler$codec$compression$SnappyFramedDecoder$ChunkType[var7_9.ordinal()]) {
                case 1: {
                    if (var4_5 != SnappyFramedDecoder.SNAPPY.length) {
                        throw new DecompressionException("Unexpected length of stream identifier: " + var4_5);
                    }
                    if (var5_7 >= 4 + SnappyFramedDecoder.SNAPPY.length) {
                        var1_1 = new byte[var4_5];
                        var2_3.skipBytes(4).readBytes((byte[])var1_1);
                        if (!Arrays.equals((byte[])var1_1, SnappyFramedDecoder.SNAPPY)) {
                            throw new DecompressionException("Unexpected stream identifier contents. Mismatched snappy protocol version?");
                        }
                        this.started = true;
                        break;
                    }
                    ** GOTO lbl83
                }
                case 2: {
                    if (!this.started) {
                        throw new DecompressionException("Received RESERVED_SKIPPABLE tag before STREAM_IDENTIFIER");
                    }
                    if (var5_7 < var4_5 + 4) {
                        return;
                    }
                    var2_3.skipBytes(var4_5 + 4);
                    break;
                }
                case 3: {
                    throw new DecompressionException("Found reserved unskippable chunk type: 0x" + Integer.toHexString(var6_8));
                }
                case 4: {
                    if (!this.started) {
                        throw new DecompressionException("Received UNCOMPRESSED_DATA tag before STREAM_IDENTIFIER");
                    }
                    if (var4_5 > 65540) {
                        throw new DecompressionException("Received UNCOMPRESSED_DATA larger than 65540 bytes");
                    }
                    if (var5_7 < var4_5 + 4) {
                        return;
                    }
                    var2_3.skipBytes(4);
                    if (this.validateChecksums) {
                        var5_7 = ByteBufUtil.swapInt(var2_3.readInt());
                        v1 = var2_3;
                        Snappy.validateChecksum(var5_7, v1, v1.readerIndex(), var4_5 - 4);
                    } else {
                        var2_3.skipBytes(4);
                    }
                    var3_4.add(var2_3.readSlice(var4_5 - 4).retain());
                    break;
                }
                case 5: {
                    if (!this.started) {
                        throw new DecompressionException("Received COMPRESSED_DATA tag before STREAM_IDENTIFIER");
                    }
                    if (var5_7 < var4_5 + 4) {
                        return;
                    }
                    var2_3.skipBytes(4);
                    var5_7 = ByteBufUtil.swapInt(var2_3.readInt());
                    var1_1 = var1_1.alloc().buffer(0);
                    if (!this.validateChecksums) ** GOTO lbl79
                    var6_8 = var2_3.writerIndex();
                    try {
                        v2 = var2_3;
                        v2.writerIndex(v2.readerIndex() + var4_5 - 4);
                        this.snappy.decode(var2_3, (ByteBuf)var1_1);
                    }
                    finally {
                        var2_3.writerIndex(var6_8);
                    }
                    Snappy.validateChecksum(var5_7, (ByteBuf)var1_1, 0, var1_1.writerIndex());
                    ** GOTO lbl80
lbl79:
                    // 1 sources

                    this.snappy.decode(var2_3.readSlice(var4_5 - 4), (ByteBuf)var1_1);
lbl80:
                    // 2 sources

                    var3_4.add(var1_1);
                    this.snappy.reset();
                }
lbl83:
                // 3 sources

                default: {
                    return;
                }
            }
        }
        catch (Exception var4_6) {
            this.corrupted = true;
            throw var4_6;
        }
    }

    private static SnappyFramedDecoder$ChunkType mapChunkType(byte by) {
        if (by == 0) {
            return SnappyFramedDecoder$ChunkType.COMPRESSED_DATA;
        }
        if (by == 1) {
            return SnappyFramedDecoder$ChunkType.UNCOMPRESSED_DATA;
        }
        if (by == -1) {
            return SnappyFramedDecoder$ChunkType.STREAM_IDENTIFIER;
        }
        if ((by & 0x80) == 128) {
            return SnappyFramedDecoder$ChunkType.RESERVED_SKIPPABLE;
        }
        return SnappyFramedDecoder$ChunkType.RESERVED_UNSKIPPABLE;
    }
}

