/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.compression;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufUtil;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.MessageToByteEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.CompressionException;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.Snappy;

public class SnappyFramedEncoder
extends MessageToByteEncoder<ByteBuf> {
    private static final int MIN_COMPRESSIBLE_LENGTH = 18;
    private static final byte[] STREAM_START = new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89};
    private final Snappy snappy = new Snappy();
    private boolean started;

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n2;
        if (!byteBuf.isReadable()) {
            return;
        }
        if (!this.started) {
            this.started = true;
            byteBuf2.writeBytes(STREAM_START);
        }
        if ((n2 = byteBuf.readableBytes()) > 18) {
            ByteBuf byteBuf3;
            int n3;
            while (true) {
                n3 = byteBuf2.writerIndex() + 1;
                if (n2 < 18) {
                    byteBuf3 = byteBuf.readSlice(n2);
                    SnappyFramedEncoder.writeUnencodedChunk(byteBuf3, byteBuf2, n2);
                    return;
                }
                byteBuf2.writeInt(0);
                if (n2 <= Short.MAX_VALUE) break;
                byteBuf3 = byteBuf.readSlice(Short.MAX_VALUE);
                SnappyFramedEncoder.calculateAndWriteChecksum(byteBuf3, byteBuf2);
                this.snappy.encode(byteBuf3, byteBuf2, Short.MAX_VALUE);
                SnappyFramedEncoder.setChunkLength(byteBuf2, n3);
                n2 -= Short.MAX_VALUE;
            }
            byteBuf3 = byteBuf.readSlice(n2);
            SnappyFramedEncoder.calculateAndWriteChecksum(byteBuf3, byteBuf2);
            this.snappy.encode(byteBuf3, byteBuf2, n2);
            SnappyFramedEncoder.setChunkLength(byteBuf2, n3);
            return;
        }
        SnappyFramedEncoder.writeUnencodedChunk(byteBuf, byteBuf2, n2);
    }

    private static void writeUnencodedChunk(ByteBuf byteBuf, ByteBuf byteBuf2, int n2) {
        byteBuf2.writeByte(1);
        SnappyFramedEncoder.writeChunkLength(byteBuf2, n2 + 4);
        SnappyFramedEncoder.calculateAndWriteChecksum(byteBuf, byteBuf2);
        byteBuf2.writeBytes(byteBuf, n2);
    }

    private static void setChunkLength(ByteBuf byteBuf, int n2) {
        int n3 = byteBuf.writerIndex() - n2 - 3;
        if (n3 >>> 24 != 0) {
            throw new CompressionException("compressed data too large: " + n3);
        }
        byteBuf.setMedium(n2, ByteBufUtil.swapMedium(n3));
    }

    private static void writeChunkLength(ByteBuf byteBuf, int n2) {
        byteBuf.writeMedium(ByteBufUtil.swapMedium(n2));
    }

    private static void calculateAndWriteChecksum(ByteBuf byteBuf, ByteBuf byteBuf2) {
        byteBuf2.writeInt(ByteBufUtil.swapInt(Snappy.calculateChecksum(byteBuf)));
    }
}

