/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.compression;

import com.aliyun.openservices.shade.io.netty.handler.codec.compression.JZlibDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.JZlibEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.JdkZlibDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.JdkZlibEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.ZlibDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.ZlibEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.ZlibWrapper;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.SystemPropertyUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;

public final class ZlibCodecFactory {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ZlibCodecFactory.class);
    private static final int DEFAULT_JDK_WINDOW_SIZE = 15;
    private static final int DEFAULT_JDK_MEM_LEVEL = 8;
    private static final boolean noJdkZlibDecoder = SystemPropertyUtil.getBoolean("com.aliyun.openservices.shade.io.netty.noJdkZlibDecoder", PlatformDependent.javaVersion() < 7);
    private static final boolean noJdkZlibEncoder;

    public static ZlibEncoder newZlibEncoder(int n2) {
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibEncoder) {
            return new JZlibEncoder(n2);
        }
        return new JdkZlibEncoder(n2);
    }

    public static ZlibEncoder newZlibEncoder(ZlibWrapper zlibWrapper) {
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibEncoder) {
            return new JZlibEncoder(zlibWrapper);
        }
        return new JdkZlibEncoder(zlibWrapper);
    }

    public static ZlibEncoder newZlibEncoder(ZlibWrapper zlibWrapper, int n2) {
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibEncoder) {
            return new JZlibEncoder(zlibWrapper, n2);
        }
        return new JdkZlibEncoder(zlibWrapper, n2);
    }

    public static ZlibEncoder newZlibEncoder(ZlibWrapper zlibWrapper, int n2, int n3, int n4) {
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibEncoder || n3 != 15 || n4 != 8) {
            return new JZlibEncoder(zlibWrapper, n2, n3, n4);
        }
        return new JdkZlibEncoder(zlibWrapper, n2);
    }

    public static ZlibEncoder newZlibEncoder(byte[] byArray) {
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibEncoder) {
            return new JZlibEncoder(byArray);
        }
        return new JdkZlibEncoder(byArray);
    }

    public static ZlibEncoder newZlibEncoder(int n2, byte[] byArray) {
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibEncoder) {
            return new JZlibEncoder(n2, byArray);
        }
        return new JdkZlibEncoder(n2, byArray);
    }

    public static ZlibEncoder newZlibEncoder(int n2, int n3, int n4, byte[] byArray) {
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibEncoder || n3 != 15 || n4 != 8) {
            return new JZlibEncoder(n2, n3, n4, byArray);
        }
        return new JdkZlibEncoder(n2, byArray);
    }

    public static ZlibDecoder newZlibDecoder() {
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibDecoder) {
            return new JZlibDecoder();
        }
        return new JdkZlibDecoder();
    }

    public static ZlibDecoder newZlibDecoder(ZlibWrapper zlibWrapper) {
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibDecoder) {
            return new JZlibDecoder(zlibWrapper);
        }
        return new JdkZlibDecoder(zlibWrapper);
    }

    public static ZlibDecoder newZlibDecoder(byte[] byArray) {
        if (PlatformDependent.javaVersion() < 7 || noJdkZlibDecoder) {
            return new JZlibDecoder(byArray);
        }
        return new JdkZlibDecoder(byArray);
    }

    private ZlibCodecFactory() {
    }

    static {
        logger.debug("-Dio.netty.noJdkZlibDecoder: {}", (Object)noJdkZlibDecoder);
        noJdkZlibEncoder = SystemPropertyUtil.getBoolean("com.aliyun.openservices.shade.io.netty.noJdkZlibEncoder", false);
        logger.debug("-Dio.netty.noJdkZlibEncoder: {}", (Object)noJdkZlibEncoder);
    }
}

