/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.haproxy;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufProcessor;
import com.aliyun.openservices.shade.io.netty.handler.codec.haproxy.HAProxyCommand;
import com.aliyun.openservices.shade.io.netty.handler.codec.haproxy.HAProxyProtocolException;
import com.aliyun.openservices.shade.io.netty.handler.codec.haproxy.HAProxyProtocolVersion;
import com.aliyun.openservices.shade.io.netty.handler.codec.haproxy.HAProxyProxiedProtocol;
import com.aliyun.openservices.shade.io.netty.handler.codec.haproxy.HAProxyProxiedProtocol$AddressFamily;
import com.aliyun.openservices.shade.io.netty.util.CharsetUtil;
import com.aliyun.openservices.shade.io.netty.util.NetUtil;

public final class HAProxyMessage {
    private static final HAProxyMessage V1_UNKNOWN_MSG = new HAProxyMessage(HAProxyProtocolVersion.V1, HAProxyCommand.PROXY, HAProxyProxiedProtocol.UNKNOWN, null, null, 0, 0);
    private static final HAProxyMessage V2_UNKNOWN_MSG = new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, HAProxyProxiedProtocol.UNKNOWN, null, null, 0, 0);
    private static final HAProxyMessage V2_LOCAL_MSG = new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.LOCAL, HAProxyProxiedProtocol.UNKNOWN, null, null, 0, 0);
    private final HAProxyProtocolVersion protocolVersion;
    private final HAProxyCommand command;
    private final HAProxyProxiedProtocol proxiedProtocol;
    private final String sourceAddress;
    private final String destinationAddress;
    private final int sourcePort;
    private final int destinationPort;

    private HAProxyMessage(HAProxyProtocolVersion hAProxyProtocolVersion, HAProxyCommand hAProxyCommand, HAProxyProxiedProtocol hAProxyProxiedProtocol, String string, String string2, String string3, String string4) {
        this(hAProxyProtocolVersion, hAProxyCommand, hAProxyProxiedProtocol, string, string2, HAProxyMessage.portStringToInt(string3), HAProxyMessage.portStringToInt(string4));
    }

    private HAProxyMessage(HAProxyProtocolVersion hAProxyProtocolVersion, HAProxyCommand hAProxyCommand, HAProxyProxiedProtocol hAProxyProxiedProtocol, String string, String string2, int n2, int n3) {
        if (hAProxyProxiedProtocol == null) {
            throw new NullPointerException("proxiedProtocol");
        }
        HAProxyProxiedProtocol$AddressFamily hAProxyProxiedProtocol$AddressFamily = hAProxyProxiedProtocol.addressFamily();
        HAProxyMessage.checkAddress(string, hAProxyProxiedProtocol$AddressFamily);
        HAProxyMessage.checkAddress(string2, hAProxyProxiedProtocol$AddressFamily);
        HAProxyMessage.checkPort(n2);
        HAProxyMessage.checkPort(n3);
        this.protocolVersion = hAProxyProtocolVersion;
        this.command = hAProxyCommand;
        this.proxiedProtocol = hAProxyProxiedProtocol;
        this.sourceAddress = string;
        this.destinationAddress = string2;
        this.sourcePort = n2;
        this.destinationPort = n3;
    }

    static HAProxyMessage decodeHeader(ByteBuf byteBuf) {
        String string;
        String string2;
        HAProxyProxiedProtocol hAProxyProxiedProtocol;
        HAProxyCommand hAProxyCommand;
        HAProxyProtocolVersion hAProxyProtocolVersion;
        if (byteBuf == null) {
            throw new NullPointerException("header");
        }
        if (byteBuf.readableBytes() < 16) {
            throw new HAProxyProtocolException("incomplete header: " + byteBuf.readableBytes() + " bytes (expected: 16+ bytes)");
        }
        byteBuf.skipBytes(12);
        byte by = byteBuf.readByte();
        try {
            hAProxyProtocolVersion = HAProxyProtocolVersion.valueOf(by);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HAProxyProtocolException(illegalArgumentException);
        }
        if (hAProxyProtocolVersion != HAProxyProtocolVersion.V2) {
            throw new HAProxyProtocolException("version 1 unsupported: 0x" + Integer.toHexString(by));
        }
        try {
            hAProxyCommand = HAProxyCommand.valueOf(by);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HAProxyProtocolException(illegalArgumentException);
        }
        if (hAProxyCommand == HAProxyCommand.LOCAL) {
            return V2_LOCAL_MSG;
        }
        try {
            hAProxyProxiedProtocol = HAProxyProxiedProtocol.valueOf(byteBuf.readByte());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HAProxyProtocolException(illegalArgumentException);
        }
        if (hAProxyProxiedProtocol == HAProxyProxiedProtocol.UNKNOWN) {
            return V2_UNKNOWN_MSG;
        }
        int n2 = byteBuf.readUnsignedShort();
        int n3 = 0;
        int n4 = 0;
        HAProxyProxiedProtocol$AddressFamily hAProxyProxiedProtocol$AddressFamily = hAProxyProxiedProtocol.addressFamily();
        if (hAProxyProxiedProtocol$AddressFamily == HAProxyProxiedProtocol$AddressFamily.AF_UNIX) {
            if (n2 < 216 || byteBuf.readableBytes() < 216) {
                throw new HAProxyProtocolException("incomplete UNIX socket address information: " + Math.min(n2, byteBuf.readableBytes()) + " bytes (expected: 216+ bytes)");
            }
            n2 = byteBuf.readerIndex();
            int n5 = byteBuf.forEachByte(n2, 108, ByteBufProcessor.FIND_NUL);
            n5 = n5 == -1 ? 108 : (n5 -= n2);
            string2 = byteBuf.toString(n2, n5, CharsetUtil.US_ASCII);
            n5 = byteBuf.forEachByte(n2 += 108, 108, ByteBufProcessor.FIND_NUL);
            n5 = n5 == -1 ? 108 : (n5 -= n2);
            string = byteBuf.toString(n2, n5, CharsetUtil.US_ASCII);
            byteBuf.readerIndex(n2 + 108);
        } else {
            int n6;
            if (hAProxyProxiedProtocol$AddressFamily == HAProxyProxiedProtocol$AddressFamily.AF_IPv4) {
                if (n2 < 12 || byteBuf.readableBytes() < 12) {
                    throw new HAProxyProtocolException("incomplete IPv4 address information: " + Math.min(n2, byteBuf.readableBytes()) + " bytes (expected: 12+ bytes)");
                }
                n6 = 4;
            } else if (hAProxyProxiedProtocol$AddressFamily == HAProxyProxiedProtocol$AddressFamily.AF_IPv6) {
                if (n2 < 36 || byteBuf.readableBytes() < 36) {
                    throw new HAProxyProtocolException("incomplete IPv6 address information: " + Math.min(n2, byteBuf.readableBytes()) + " bytes (expected: 36+ bytes)");
                }
                n6 = 16;
            } else {
                throw new HAProxyProtocolException("unable to parse address information (unkown address family: " + (Object)((Object)hAProxyProxiedProtocol$AddressFamily) + ')');
            }
            string2 = HAProxyMessage.ipBytestoString(byteBuf, n6);
            string = HAProxyMessage.ipBytestoString(byteBuf, n6);
            n3 = byteBuf.readUnsignedShort();
            n4 = byteBuf.readUnsignedShort();
        }
        return new HAProxyMessage(hAProxyProtocolVersion, hAProxyCommand, hAProxyProxiedProtocol, string2, string, n3, n4);
    }

    static HAProxyMessage decodeHeader(String string) {
        HAProxyProxiedProtocol hAProxyProxiedProtocol;
        if (string == null) {
            throw new HAProxyProtocolException("header");
        }
        String[] stringArray = string.split(" ");
        int n2 = stringArray.length;
        if (n2 < 2) {
            throw new HAProxyProtocolException("invalid header: " + string + " (expected: 'PROXY' and proxied protocol values)");
        }
        if (!"PROXY".equals(stringArray[0])) {
            throw new HAProxyProtocolException("unknown identifier: " + stringArray[0]);
        }
        try {
            hAProxyProxiedProtocol = HAProxyProxiedProtocol.valueOf(stringArray[1]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HAProxyProtocolException(illegalArgumentException);
        }
        if (hAProxyProxiedProtocol != HAProxyProxiedProtocol.TCP4 && hAProxyProxiedProtocol != HAProxyProxiedProtocol.TCP6 && hAProxyProxiedProtocol != HAProxyProxiedProtocol.UNKNOWN) {
            throw new HAProxyProtocolException("unsupported v1 proxied protocol: " + stringArray[1]);
        }
        if (hAProxyProxiedProtocol == HAProxyProxiedProtocol.UNKNOWN) {
            return V1_UNKNOWN_MSG;
        }
        if (n2 != 6) {
            throw new HAProxyProtocolException("invalid TCP4/6 header: " + string + " (expected: 6 parts)");
        }
        return new HAProxyMessage(HAProxyProtocolVersion.V1, HAProxyCommand.PROXY, hAProxyProxiedProtocol, stringArray[2], stringArray[3], stringArray[4], stringArray[5]);
    }

    private static String ipBytestoString(ByteBuf byteBuf, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 == 4) {
            stringBuilder.append(byteBuf.readByte() & 0xFF);
            stringBuilder.append('.');
            stringBuilder.append(byteBuf.readByte() & 0xFF);
            stringBuilder.append('.');
            stringBuilder.append(byteBuf.readByte() & 0xFF);
            stringBuilder.append('.');
            stringBuilder.append(byteBuf.readByte() & 0xFF);
        } else {
            stringBuilder.append(Integer.toHexString(byteBuf.readUnsignedShort()));
            stringBuilder.append(':');
            stringBuilder.append(Integer.toHexString(byteBuf.readUnsignedShort()));
            stringBuilder.append(':');
            stringBuilder.append(Integer.toHexString(byteBuf.readUnsignedShort()));
            stringBuilder.append(':');
            stringBuilder.append(Integer.toHexString(byteBuf.readUnsignedShort()));
            stringBuilder.append(':');
            stringBuilder.append(Integer.toHexString(byteBuf.readUnsignedShort()));
            stringBuilder.append(':');
            stringBuilder.append(Integer.toHexString(byteBuf.readUnsignedShort()));
            stringBuilder.append(':');
            stringBuilder.append(Integer.toHexString(byteBuf.readUnsignedShort()));
            stringBuilder.append(':');
            stringBuilder.append(Integer.toHexString(byteBuf.readUnsignedShort()));
        }
        return stringBuilder.toString();
    }

    private static int portStringToInt(String string) {
        int n2;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new HAProxyProtocolException("invalid port: " + string, numberFormatException);
        }
        if (n2 <= 0 || n2 > 65535) {
            throw new HAProxyProtocolException("invalid port: " + string + " (expected: 1 ~ 65535)");
        }
        return n2;
    }

    private static void checkAddress(String string, HAProxyProxiedProtocol$AddressFamily hAProxyProxiedProtocol$AddressFamily) {
        if (hAProxyProxiedProtocol$AddressFamily == null) {
            throw new NullPointerException("addrFamily");
        }
        switch (hAProxyProxiedProtocol$AddressFamily) {
            case AF_UNSPEC: {
                if (string != null) {
                    throw new HAProxyProtocolException("unable to validate an AF_UNSPEC address: " + string);
                }
                return;
            }
            case AF_UNIX: {
                return;
            }
        }
        if (string == null) {
            throw new NullPointerException("address");
        }
        switch (hAProxyProxiedProtocol$AddressFamily) {
            case AF_IPv4: {
                if (NetUtil.isValidIpV4Address(string)) break;
                throw new HAProxyProtocolException("invalid IPv4 address: " + string);
            }
            case AF_IPv6: {
                if (NetUtil.isValidIpV6Address(string)) break;
                throw new HAProxyProtocolException("invalid IPv6 address: " + string);
            }
            default: {
                throw new Error();
            }
        }
    }

    private static void checkPort(int n2) {
        if (n2 < 0 || n2 > 65535) {
            throw new HAProxyProtocolException("invalid port: " + n2 + " (expected: 1 ~ 65535)");
        }
    }

    public final HAProxyProtocolVersion protocolVersion() {
        return this.protocolVersion;
    }

    public final HAProxyCommand command() {
        return this.command;
    }

    public final HAProxyProxiedProtocol proxiedProtocol() {
        return this.proxiedProtocol;
    }

    public final String sourceAddress() {
        return this.sourceAddress;
    }

    public final String destinationAddress() {
        return this.destinationAddress;
    }

    public final int sourcePort() {
        return this.sourcePort;
    }

    public final int destinationPort() {
        return this.destinationPort;
    }
}

