/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.haproxy;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.ByteToMessageDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.ProtocolDetectionResult;
import com.aliyun.openservices.shade.io.netty.handler.codec.haproxy.HAProxyMessage;
import com.aliyun.openservices.shade.io.netty.handler.codec.haproxy.HAProxyProtocolException;
import com.aliyun.openservices.shade.io.netty.handler.codec.haproxy.HAProxyProtocolVersion;
import com.aliyun.openservices.shade.io.netty.util.CharsetUtil;
import java.util.List;

public class HAProxyMessageDecoder
extends ByteToMessageDecoder {
    private static final int V1_MAX_LENGTH = 108;
    private static final int V2_MAX_LENGTH = 65551;
    private static final int V2_MIN_LENGTH = 232;
    private static final int V2_MAX_TLV = 65319;
    private static final int DELIMITER_LENGTH = 2;
    private static final byte[] BINARY_PREFIX = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10};
    private static final byte[] TEXT_PREFIX = new byte[]{80, 82, 79, 88, 89};
    private static final int BINARY_PREFIX_LENGTH = BINARY_PREFIX.length;
    private static final ProtocolDetectionResult<HAProxyProtocolVersion> DETECTION_RESULT_V1 = ProtocolDetectionResult.detected(HAProxyProtocolVersion.V1);
    private static final ProtocolDetectionResult<HAProxyProtocolVersion> DETECTION_RESULT_V2 = ProtocolDetectionResult.detected(HAProxyProtocolVersion.V2);
    private boolean discarding;
    private int discardedBytes;
    private boolean finished;
    private int version = -1;
    private final int v2MaxHeaderSize;

    public HAProxyMessageDecoder() {
        this.v2MaxHeaderSize = 65551;
    }

    public HAProxyMessageDecoder(int n2) {
        if (n2 <= 0) {
            this.v2MaxHeaderSize = 232;
            return;
        }
        if (n2 > 65319) {
            this.v2MaxHeaderSize = 65551;
            return;
        }
        if ((n2 += 232) > 65551) {
            this.v2MaxHeaderSize = 65551;
            return;
        }
        this.v2MaxHeaderSize = n2;
    }

    private static int findVersion(ByteBuf byteBuf) {
        int n2 = byteBuf.readableBytes();
        if (n2 < 13) {
            return -1;
        }
        n2 = byteBuf.readerIndex();
        if (HAProxyMessageDecoder.match(BINARY_PREFIX, byteBuf, n2)) {
            return byteBuf.getByte(n2 + BINARY_PREFIX_LENGTH);
        }
        return 1;
    }

    private static int findEndOfHeader(ByteBuf byteBuf) {
        int n2 = byteBuf.readableBytes();
        if (n2 < 16) {
            return -1;
        }
        int n3 = byteBuf.readerIndex() + 14;
        int n4 = 16 + byteBuf.getUnsignedShort(n3);
        if (n2 >= n4) {
            return n4;
        }
        return -1;
    }

    private static int findEndOfLine(ByteBuf byteBuf) {
        int n2 = byteBuf.writerIndex();
        for (int i2 = byteBuf.readerIndex(); i2 < n2; ++i2) {
            byte by = byteBuf.getByte(i2);
            if (by != 13 || i2 >= n2 - 1 || byteBuf.getByte(i2 + 1) != 10) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public boolean isSingleDecode() {
        return true;
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        super.channelRead(channelHandlerContext, object);
        if (this.finished) {
            channelHandlerContext.pipeline().remove(this);
        }
    }

    @Override
    public final void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (this.version == -1 && (this.version = HAProxyMessageDecoder.findVersion(byteBuf)) == -1) {
            return;
        }
        byteBuf = this.version == 1 ? this.decodeLine(channelHandlerContext, byteBuf) : this.decodeStruct(channelHandlerContext, byteBuf);
        if (byteBuf != null) {
            this.finished = true;
            try {
                if (this.version != 1) {
                    list.add(HAProxyMessage.decodeHeader(byteBuf));
                    return;
                }
                list.add(HAProxyMessage.decodeHeader(byteBuf.toString(CharsetUtil.US_ASCII)));
            }
            catch (HAProxyProtocolException hAProxyProtocolException) {
                this.fail(channelHandlerContext, null, hAProxyProtocolException);
            }
        }
    }

    private ByteBuf decodeStruct(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        int n2 = HAProxyMessageDecoder.findEndOfHeader(byteBuf);
        if (!this.discarding) {
            if (n2 >= 0) {
                int n3 = n2 - byteBuf.readerIndex();
                if (n3 > this.v2MaxHeaderSize) {
                    byteBuf.readerIndex(n2);
                    this.failOverLimit(channelHandlerContext, n3);
                    return null;
                }
                return byteBuf.readSlice(n3);
            }
            int n4 = byteBuf.readableBytes();
            if (n4 > this.v2MaxHeaderSize) {
                this.discardedBytes = n4;
                byteBuf.skipBytes(n4);
                this.discarding = true;
                this.failOverLimit(channelHandlerContext, "over " + this.discardedBytes);
            }
            return null;
        }
        if (n2 >= 0) {
            byteBuf.readerIndex(n2);
            this.discardedBytes = 0;
            this.discarding = false;
        } else {
            this.discardedBytes = byteBuf.readableBytes();
            byteBuf.skipBytes(this.discardedBytes);
        }
        return null;
    }

    private ByteBuf decodeLine(ChannelHandlerContext object, ByteBuf byteBuf) {
        int n2 = HAProxyMessageDecoder.findEndOfLine(byteBuf);
        if (!this.discarding) {
            if (n2 >= 0) {
                int n3 = n2 - byteBuf.readerIndex();
                if (n3 > 108) {
                    byteBuf.readerIndex(n2 + 2);
                    this.failOverLimit((ChannelHandlerContext)object, n3);
                    return null;
                }
                object = byteBuf.readSlice(n3);
                byteBuf.skipBytes(2);
                return object;
            }
            int n4 = byteBuf.readableBytes();
            if (n4 > 108) {
                this.discardedBytes = n4;
                byteBuf.skipBytes(n4);
                this.discarding = true;
                this.failOverLimit((ChannelHandlerContext)object, "over " + this.discardedBytes);
            }
            return null;
        }
        if (n2 >= 0) {
            int n5 = byteBuf.getByte(n2) == 13 ? 2 : 1;
            byteBuf.readerIndex(n2 + n5);
            this.discardedBytes = 0;
            this.discarding = false;
        } else {
            this.discardedBytes = byteBuf.readableBytes();
            byteBuf.skipBytes(this.discardedBytes);
        }
        return null;
    }

    private void failOverLimit(ChannelHandlerContext channelHandlerContext, int n2) {
        this.failOverLimit(channelHandlerContext, String.valueOf(n2));
    }

    private void failOverLimit(ChannelHandlerContext channelHandlerContext, String string) {
        int n2 = this.version == 1 ? 108 : this.v2MaxHeaderSize;
        this.fail(channelHandlerContext, "header length (" + string + ") exceeds the allowed maximum (" + n2 + ')', null);
    }

    private void fail(ChannelHandlerContext object, String string, Throwable throwable) {
        this.finished = true;
        object.close();
        object = string != null && throwable != null ? new HAProxyProtocolException(string, throwable) : (string != null ? new HAProxyProtocolException(string) : (throwable != null ? new HAProxyProtocolException(throwable) : new HAProxyProtocolException()));
        throw object;
    }

    public static ProtocolDetectionResult<HAProxyProtocolVersion> detectProtocol(ByteBuf byteBuf) {
        if (byteBuf.readableBytes() < 12) {
            return ProtocolDetectionResult.needsMoreData();
        }
        int n2 = byteBuf.readerIndex();
        if (HAProxyMessageDecoder.match(BINARY_PREFIX, byteBuf, n2)) {
            return DETECTION_RESULT_V2;
        }
        if (HAProxyMessageDecoder.match(TEXT_PREFIX, byteBuf, n2)) {
            return DETECTION_RESULT_V1;
        }
        return ProtocolDetectionResult.invalid();
    }

    private static boolean match(byte[] byArray, ByteBuf byteBuf, int n2) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byte by = byteBuf.getByte(n2 + i2);
            if (by == byArray[i2]) continue;
            return false;
        }
        return true;
    }
}

