/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.DefaultHttpHeaders$HeaderEntry;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.DefaultHttpHeaders$HeaderIterator;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpHeaderDateFormat;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpHeaders;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultHttpHeaders
extends HttpHeaders {
    private static final int BUCKET_SIZE = 17;
    private final DefaultHttpHeaders$HeaderEntry[] entries = new DefaultHttpHeaders$HeaderEntry[17];
    private final DefaultHttpHeaders$HeaderEntry head = new DefaultHttpHeaders$HeaderEntry(this);
    protected final boolean validate;

    private static int index(int n2) {
        return n2 % 17;
    }

    public DefaultHttpHeaders() {
        this(true);
    }

    public DefaultHttpHeaders(boolean bl) {
        this.validate = bl;
        this.head.before = this.head.after = this.head;
    }

    void validateHeaderName0(CharSequence charSequence) {
        DefaultHttpHeaders.validateHeaderName(charSequence);
    }

    @Override
    public HttpHeaders add(HttpHeaders httpHeaders) {
        if (httpHeaders instanceof DefaultHttpHeaders) {
            if (httpHeaders == this) {
                throw new IllegalArgumentException("can't add to itself.");
            }
            httpHeaders = (DefaultHttpHeaders)httpHeaders;
            DefaultHttpHeaders$HeaderEntry defaultHttpHeaders$HeaderEntry = ((DefaultHttpHeaders)httpHeaders).head.after;
            while (defaultHttpHeaders$HeaderEntry != ((DefaultHttpHeaders)httpHeaders).head) {
                ((HttpHeaders)this).add(defaultHttpHeaders$HeaderEntry.key, (Object)defaultHttpHeaders$HeaderEntry.value);
                defaultHttpHeaders$HeaderEntry = defaultHttpHeaders$HeaderEntry.after;
            }
            return this;
        }
        return super.add(httpHeaders);
    }

    @Override
    public HttpHeaders set(HttpHeaders httpHeaders) {
        if (httpHeaders instanceof DefaultHttpHeaders) {
            if (httpHeaders != this) {
                ((HttpHeaders)this).clear();
                httpHeaders = (DefaultHttpHeaders)httpHeaders;
                DefaultHttpHeaders$HeaderEntry defaultHttpHeaders$HeaderEntry = ((DefaultHttpHeaders)httpHeaders).head.after;
                while (defaultHttpHeaders$HeaderEntry != ((DefaultHttpHeaders)httpHeaders).head) {
                    ((HttpHeaders)this).add(defaultHttpHeaders$HeaderEntry.key, (Object)defaultHttpHeaders$HeaderEntry.value);
                    defaultHttpHeaders$HeaderEntry = defaultHttpHeaders$HeaderEntry.after;
                }
            }
            return this;
        }
        return super.set(httpHeaders);
    }

    @Override
    public HttpHeaders add(String string, Object object) {
        return ((HttpHeaders)this).add((CharSequence)string, object);
    }

    @Override
    public HttpHeaders add(CharSequence charSequence, Object object) {
        if (this.validate) {
            this.validateHeaderName0(charSequence);
            object = DefaultHttpHeaders.toCharSequence(object);
            DefaultHttpHeaders.validateHeaderValue((CharSequence)object);
        } else {
            object = DefaultHttpHeaders.toCharSequence(object);
        }
        int n2 = DefaultHttpHeaders.hash(charSequence);
        int n3 = DefaultHttpHeaders.index(n2);
        this.add0(n2, n3, charSequence, (CharSequence)object);
        return this;
    }

    @Override
    public HttpHeaders add(String string, Iterable<?> iterable) {
        return ((HttpHeaders)this).add((CharSequence)string, iterable);
    }

    @Override
    public HttpHeaders add(CharSequence charSequence, Iterable<?> object) {
        if (this.validate) {
            this.validateHeaderName0(charSequence);
        }
        int n2 = DefaultHttpHeaders.hash(charSequence);
        int n3 = DefaultHttpHeaders.index(n2);
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = DefaultHttpHeaders.toCharSequence(object2);
            if (this.validate) {
                DefaultHttpHeaders.validateHeaderValue(object2);
            }
            this.add0(n2, n3, charSequence, (CharSequence)object2);
        }
        return this;
    }

    private void add0(int n2, int n3, CharSequence charSequence, CharSequence charSequence2) {
        DefaultHttpHeaders$HeaderEntry defaultHttpHeaders$HeaderEntry;
        DefaultHttpHeaders$HeaderEntry defaultHttpHeaders$HeaderEntry2 = this.entries[n3];
        this.entries[n3] = defaultHttpHeaders$HeaderEntry = new DefaultHttpHeaders$HeaderEntry(this, n2, charSequence, charSequence2);
        defaultHttpHeaders$HeaderEntry.next = defaultHttpHeaders$HeaderEntry2;
        defaultHttpHeaders$HeaderEntry.addBefore(this.head);
    }

    @Override
    public HttpHeaders remove(String string) {
        return ((HttpHeaders)this).remove((CharSequence)string);
    }

    @Override
    public HttpHeaders remove(CharSequence charSequence) {
        if (charSequence == null) {
            throw new NullPointerException("name");
        }
        int n2 = DefaultHttpHeaders.hash(charSequence);
        int n3 = DefaultHttpHeaders.index(n2);
        this.remove0(n2, n3, charSequence);
        return this;
    }

    private void remove0(int n2, int n3, CharSequence charSequence) {
        DefaultHttpHeaders$HeaderEntry defaultHttpHeaders$HeaderEntry;
        DefaultHttpHeaders$HeaderEntry defaultHttpHeaders$HeaderEntry2 = this.entries[n3];
        if (defaultHttpHeaders$HeaderEntry2 == null) {
            return;
        }
        while (defaultHttpHeaders$HeaderEntry2.hash == n2 && DefaultHttpHeaders.equalsIgnoreCase(charSequence, defaultHttpHeaders$HeaderEntry2.key)) {
            defaultHttpHeaders$HeaderEntry2.remove();
            defaultHttpHeaders$HeaderEntry = defaultHttpHeaders$HeaderEntry2.next;
            if (defaultHttpHeaders$HeaderEntry != null) {
                this.entries[n3] = defaultHttpHeaders$HeaderEntry;
                defaultHttpHeaders$HeaderEntry2 = defaultHttpHeaders$HeaderEntry;
                continue;
            }
            this.entries[n3] = null;
            return;
        }
        while ((defaultHttpHeaders$HeaderEntry = defaultHttpHeaders$HeaderEntry2.next) != null) {
            if (defaultHttpHeaders$HeaderEntry.hash == n2 && DefaultHttpHeaders.equalsIgnoreCase(charSequence, defaultHttpHeaders$HeaderEntry.key)) {
                defaultHttpHeaders$HeaderEntry2.next = defaultHttpHeaders$HeaderEntry.next;
                defaultHttpHeaders$HeaderEntry.remove();
                continue;
            }
            defaultHttpHeaders$HeaderEntry2 = defaultHttpHeaders$HeaderEntry;
        }
    }

    @Override
    public HttpHeaders set(String string, Object object) {
        return ((HttpHeaders)this).set((CharSequence)string, object);
    }

    @Override
    public HttpHeaders set(CharSequence charSequence, Object object) {
        if (this.validate) {
            this.validateHeaderName0(charSequence);
            object = DefaultHttpHeaders.toCharSequence(object);
            DefaultHttpHeaders.validateHeaderValue((CharSequence)object);
        } else {
            object = DefaultHttpHeaders.toCharSequence(object);
        }
        int n2 = DefaultHttpHeaders.hash(charSequence);
        int n3 = DefaultHttpHeaders.index(n2);
        this.remove0(n2, n3, charSequence);
        this.add0(n2, n3, charSequence, (CharSequence)object);
        return this;
    }

    @Override
    public HttpHeaders set(String string, Iterable<?> iterable) {
        return ((HttpHeaders)this).set((CharSequence)string, iterable);
    }

    @Override
    public HttpHeaders set(CharSequence charSequence, Iterable<?> object) {
        Object object2;
        if (object == null) {
            throw new NullPointerException("values");
        }
        if (this.validate) {
            this.validateHeaderName0(charSequence);
        }
        int n2 = DefaultHttpHeaders.hash(charSequence);
        int n3 = DefaultHttpHeaders.index(n2);
        this.remove0(n2, n3, charSequence);
        object = object.iterator();
        while (object.hasNext() && (object2 = object.next()) != null) {
            object2 = DefaultHttpHeaders.toCharSequence(object2);
            if (this.validate) {
                DefaultHttpHeaders.validateHeaderValue(object2);
            }
            this.add0(n2, n3, charSequence, (CharSequence)object2);
        }
        return this;
    }

    @Override
    public HttpHeaders clear() {
        Arrays.fill(this.entries, null);
        this.head.before = this.head.after = this.head;
        return this;
    }

    @Override
    public String get(String string) {
        return ((HttpHeaders)this).get((CharSequence)string);
    }

    @Override
    public String get(CharSequence charSequence) {
        if (charSequence == null) {
            throw new NullPointerException("name");
        }
        int n2 = DefaultHttpHeaders.hash(charSequence);
        int n3 = DefaultHttpHeaders.index(n2);
        DefaultHttpHeaders$HeaderEntry defaultHttpHeaders$HeaderEntry = this.entries[n3];
        CharSequence charSequence2 = null;
        while (defaultHttpHeaders$HeaderEntry != null) {
            if (defaultHttpHeaders$HeaderEntry.hash == n2 && DefaultHttpHeaders.equalsIgnoreCase(charSequence, defaultHttpHeaders$HeaderEntry.key)) {
                charSequence2 = defaultHttpHeaders$HeaderEntry.value;
            }
            defaultHttpHeaders$HeaderEntry = defaultHttpHeaders$HeaderEntry.next;
        }
        if (charSequence2 == null) {
            return null;
        }
        return charSequence2.toString();
    }

    @Override
    public List<String> getAll(String string) {
        return ((HttpHeaders)this).getAll((CharSequence)string);
    }

    @Override
    public List<String> getAll(CharSequence charSequence) {
        if (charSequence == null) {
            throw new NullPointerException("name");
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        int n2 = DefaultHttpHeaders.hash(charSequence);
        int n3 = DefaultHttpHeaders.index(n2);
        DefaultHttpHeaders$HeaderEntry defaultHttpHeaders$HeaderEntry = this.entries[n3];
        while (defaultHttpHeaders$HeaderEntry != null) {
            if (defaultHttpHeaders$HeaderEntry.hash == n2 && DefaultHttpHeaders.equalsIgnoreCase(charSequence, defaultHttpHeaders$HeaderEntry.key)) {
                linkedList.addFirst(defaultHttpHeaders$HeaderEntry.getValue());
            }
            defaultHttpHeaders$HeaderEntry = defaultHttpHeaders$HeaderEntry.next;
        }
        return linkedList;
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        LinkedList<Map.Entry<String, String>> linkedList = new LinkedList<Map.Entry<String, String>>();
        DefaultHttpHeaders$HeaderEntry defaultHttpHeaders$HeaderEntry = this.head.after;
        while (defaultHttpHeaders$HeaderEntry != this.head) {
            linkedList.add(defaultHttpHeaders$HeaderEntry);
            defaultHttpHeaders$HeaderEntry = defaultHttpHeaders$HeaderEntry.after;
        }
        return linkedList;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return new DefaultHttpHeaders$HeaderIterator(this, null);
    }

    @Override
    public boolean contains(String string) {
        return ((HttpHeaders)this).get(string) != null;
    }

    @Override
    public boolean contains(CharSequence charSequence) {
        return ((HttpHeaders)this).get(charSequence) != null;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.head.after;
    }

    @Override
    public boolean contains(String string, String string2, boolean bl) {
        return ((HttpHeaders)this).contains((CharSequence)string, (CharSequence)string2, bl);
    }

    @Override
    public boolean contains(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        if (charSequence == null) {
            throw new NullPointerException("name");
        }
        int n2 = DefaultHttpHeaders.hash(charSequence);
        int n3 = DefaultHttpHeaders.index(n2);
        DefaultHttpHeaders$HeaderEntry defaultHttpHeaders$HeaderEntry = this.entries[n3];
        while (defaultHttpHeaders$HeaderEntry != null) {
            if (defaultHttpHeaders$HeaderEntry.hash == n2 && DefaultHttpHeaders.equalsIgnoreCase(charSequence, defaultHttpHeaders$HeaderEntry.key) && (bl ? DefaultHttpHeaders.equalsIgnoreCase(defaultHttpHeaders$HeaderEntry.value, charSequence2) : defaultHttpHeaders$HeaderEntry.value.equals(charSequence2))) {
                return true;
            }
            defaultHttpHeaders$HeaderEntry = defaultHttpHeaders$HeaderEntry.next;
        }
        return false;
    }

    @Override
    public Set<String> names() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        DefaultHttpHeaders$HeaderEntry defaultHttpHeaders$HeaderEntry = this.head.after;
        while (defaultHttpHeaders$HeaderEntry != this.head) {
            linkedHashSet.add(defaultHttpHeaders$HeaderEntry.getKey());
            defaultHttpHeaders$HeaderEntry = defaultHttpHeaders$HeaderEntry.after;
        }
        return linkedHashSet;
    }

    private static CharSequence toCharSequence(Object object) {
        ObjectUtil.checkNotNull(object, "value");
        if (object instanceof CharSequence) {
            return (CharSequence)object;
        }
        if (object instanceof Number) {
            return object.toString();
        }
        if (object instanceof Date) {
            return HttpHeaderDateFormat.get().format((Date)object);
        }
        if (object instanceof Calendar) {
            return HttpHeaderDateFormat.get().format(((Calendar)object).getTime());
        }
        return object.toString();
    }

    void encode(ByteBuf byteBuf) {
        DefaultHttpHeaders$HeaderEntry defaultHttpHeaders$HeaderEntry = this.head.after;
        while (defaultHttpHeaders$HeaderEntry != this.head) {
            defaultHttpHeaders$HeaderEntry.encode(byteBuf);
            defaultHttpHeaders$HeaderEntry = defaultHttpHeaders$HeaderEntry.after;
        }
    }

    static /* synthetic */ DefaultHttpHeaders$HeaderEntry access$100(DefaultHttpHeaders defaultHttpHeaders) {
        return defaultHttpHeaders.head;
    }
}

