/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http;

import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.embedded.EmbeddedChannel;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.ZlibCodecFactory;
import com.aliyun.openservices.shade.io.netty.handler.codec.compression.ZlibWrapper;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpContentCompressor$1;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpContentEncoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpContentEncoder$Result;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpResponse;

public class HttpContentCompressor
extends HttpContentEncoder {
    private final int compressionLevel;
    private final int windowBits;
    private final int memLevel;
    private ChannelHandlerContext ctx;

    public HttpContentCompressor() {
        this(6);
    }

    public HttpContentCompressor(int n2) {
        this(n2, 15, 8);
    }

    public HttpContentCompressor(int n2, int n3, int n4) {
        if (n2 < 0 || n2 > 9) {
            throw new IllegalArgumentException("compressionLevel: " + n2 + " (expected: 0-9)");
        }
        if (n3 < 9 || n3 > 15) {
            throw new IllegalArgumentException("windowBits: " + n3 + " (expected: 9-15)");
        }
        if (n4 <= 0 || n4 > 9) {
            throw new IllegalArgumentException("memLevel: " + n4 + " (expected: 1-9)");
        }
        this.compressionLevel = n2;
        this.windowBits = n3;
        this.memLevel = n4;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
    }

    @Override
    protected HttpContentEncoder$Result beginEncode(HttpResponse object, String string) {
        if ((object = object.headers().get("Content-Encoding")) != null && !"identity".equalsIgnoreCase((String)object)) {
            return null;
        }
        object = this.determineWrapper(string);
        if (object == null) {
            return null;
        }
        switch (HttpContentCompressor$1.$SwitchMap$io$netty$handler$codec$compression$ZlibWrapper[((Enum)object).ordinal()]) {
            case 1: {
                string = "gzip";
                break;
            }
            case 2: {
                string = "deflate";
                break;
            }
            default: {
                throw new Error();
            }
        }
        return new HttpContentEncoder$Result(string, new EmbeddedChannel(this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), ZlibCodecFactory.newZlibEncoder((ZlibWrapper)((Object)object), this.compressionLevel, this.windowBits, this.memLevel)));
    }

    protected ZlibWrapper determineWrapper(String stringArray) {
        float f2 = -1.0f;
        float f3 = -1.0f;
        float f4 = -1.0f;
        for (String string : stringArray.split(",")) {
            float f5 = 1.0f;
            int n2 = string.indexOf(61);
            if (n2 != -1) {
                try {
                    f5 = Float.parseFloat(string.substring(n2 + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    f5 = 0.0f;
                }
            }
            if (string.contains("*")) {
                f2 = f5;
                continue;
            }
            if (string.contains("gzip") && f5 > f3) {
                f3 = f5;
                continue;
            }
            if (!string.contains("deflate") || !(f5 > f4)) continue;
            f4 = f5;
        }
        if (f3 > 0.0f || f4 > 0.0f) {
            if (f3 >= f4) {
                return ZlibWrapper.GZIP;
            }
            return ZlibWrapper.ZLIB;
        }
        if (f2 > 0.0f) {
            if (f3 == -1.0f) {
                return ZlibWrapper.GZIP;
            }
            if (f4 == -1.0f) {
                return ZlibWrapper.ZLIB;
            }
        }
        return null;
    }
}

