/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.embedded.EmbeddedChannel;
import com.aliyun.openservices.shade.io.netty.handler.codec.CodecException;
import com.aliyun.openservices.shade.io.netty.handler.codec.MessageToMessageDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.ComposedLastHttpContent;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.DefaultHttpContent;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.DefaultHttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.DefaultHttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpContent;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpMessage;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpObject;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.LastHttpContent;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCountUtil;
import java.util.List;

public abstract class HttpContentDecoder
extends MessageToMessageDecoder<HttpObject> {
    protected ChannelHandlerContext ctx;
    private EmbeddedChannel decoder;
    private boolean continueResponse;

    @Override
    protected void decode(ChannelHandlerContext object, HttpObject httpObject, List<Object> list) {
        if (httpObject instanceof HttpResponse && ((HttpResponse)httpObject).getStatus().code() == 100) {
            if (!(httpObject instanceof LastHttpContent)) {
                this.continueResponse = true;
            }
            list.add(ReferenceCountUtil.retain(httpObject));
            return;
        }
        if (this.continueResponse) {
            if (httpObject instanceof LastHttpContent) {
                this.continueResponse = false;
            }
            list.add(ReferenceCountUtil.retain(httpObject));
            return;
        }
        if (httpObject instanceof HttpMessage) {
            this.cleanup();
            object = (HttpMessage)httpObject;
            Object object2 = object.headers();
            String string = ((HttpHeaders)object2).get("Content-Encoding");
            string = string != null ? string.trim() : "identity";
            this.decoder = this.newContentDecoder(string);
            if (this.decoder == null) {
                if (object instanceof HttpContent) {
                    ((HttpContent)object).retain();
                }
                list.add(object);
                return;
            }
            ((HttpHeaders)object2).remove("Content-Length");
            ((HttpHeaders)object2).set("Transfer-Encoding", (Object)"chunked");
            string = this.getTargetContentEncoding(string);
            if ("identity".equals(string)) {
                ((HttpHeaders)object2).remove("Content-Encoding");
            } else {
                ((HttpHeaders)object2).set("Content-Encoding", (Object)string);
            }
            if (object instanceof HttpContent) {
                if (object instanceof HttpRequest) {
                    object2 = (HttpRequest)object;
                    object2 = new DefaultHttpRequest(object2.getProtocolVersion(), object2.getMethod(), object2.getUri());
                } else if (object instanceof HttpResponse) {
                    object2 = (HttpResponse)object;
                    object2 = new DefaultHttpResponse(object2.getProtocolVersion(), object2.getStatus());
                } else {
                    throw new CodecException("Object of class " + object.getClass().getName() + " is not a HttpRequest or HttpResponse");
                }
                object2.headers().set(object.headers());
                object2.setDecoderResult(object.getDecoderResult());
                list.add(object2);
            } else {
                list.add(object);
            }
        }
        if (httpObject instanceof HttpContent) {
            object = (HttpContent)httpObject;
            if (this.decoder == null) {
                list.add(object.retain());
                return;
            }
            this.decodeContent((HttpContent)object, list);
        }
    }

    private void decodeContent(HttpContent object, List<Object> list) {
        ByteBuf byteBuf = object.content();
        this.decode(byteBuf, list);
        if (object instanceof LastHttpContent) {
            this.finishDecode(list);
            object = (LastHttpContent)object;
            object = object.trailingHeaders();
            if (((HttpHeaders)object).isEmpty()) {
                list.add(LastHttpContent.EMPTY_LAST_CONTENT);
                return;
            }
            list.add(new ComposedLastHttpContent((HttpHeaders)object));
        }
    }

    protected abstract EmbeddedChannel newContentDecoder(String var1);

    protected String getTargetContentEncoding(String string) {
        return "identity";
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.cleanup();
        super.handlerRemoved(channelHandlerContext);
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.cleanup();
        super.channelInactive(channelHandlerContext);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
        super.handlerAdded(channelHandlerContext);
    }

    private void cleanup() {
        if (this.decoder != null) {
            if (this.decoder.finish()) {
                ByteBuf byteBuf;
                while ((byteBuf = (ByteBuf)this.decoder.readInbound()) != null) {
                    byteBuf.release();
                }
            }
            this.decoder = null;
        }
    }

    private void decode(ByteBuf byteBuf, List<Object> list) {
        this.decoder.writeInbound(byteBuf.retain());
        this.fetchDecoderOutput(list);
    }

    private void finishDecode(List<Object> list) {
        if (this.decoder.finish()) {
            this.fetchDecoderOutput(list);
        }
        this.decoder = null;
    }

    private void fetchDecoderOutput(List<Object> list) {
        ByteBuf byteBuf;
        while ((byteBuf = (ByteBuf)this.decoder.readInbound()) != null) {
            if (!byteBuf.isReadable()) {
                byteBuf.release();
                continue;
            }
            list.add(new DefaultHttpContent(byteBuf));
        }
    }
}

