/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufHolder;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.embedded.EmbeddedChannel;
import com.aliyun.openservices.shade.io.netty.handler.codec.MessageToMessageCodec;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.ComposedLastHttpContent;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.DefaultHttpContent;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.DefaultHttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpContent;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpContentEncoder$Result;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpContentEncoder$State;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpMethod;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpObject;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpResponseStatus;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpVersion;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.LastHttpContent;
import com.aliyun.openservices.shade.io.netty.util.ReferenceCountUtil;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;

public abstract class HttpContentEncoder
extends MessageToMessageCodec<HttpRequest, HttpObject> {
    private static final CharSequence ZERO_LENGTH_HEAD = "HEAD";
    private static final CharSequence ZERO_LENGTH_CONNECT = "CONNECT";
    private static final int CONTINUE_CODE = HttpResponseStatus.CONTINUE.code();
    private final Queue<CharSequence> acceptEncodingQueue = new ArrayDeque<CharSequence>();
    private CharSequence acceptEncoding;
    private EmbeddedChannel encoder;
    private HttpContentEncoder$State state = HttpContentEncoder$State.AWAIT_HEADERS;

    @Override
    public boolean acceptOutboundMessage(Object object) {
        return object instanceof HttpContent || object instanceof HttpResponse;
    }

    @Override
    protected void decode(ChannelHandlerContext object, HttpRequest httpRequest, List<Object> list) {
        HttpMethod httpMethod;
        object = httpRequest.headers().get("Accept-Encoding");
        if (object == null) {
            object = "identity";
        }
        if ((httpMethod = httpRequest.getMethod()) == HttpMethod.HEAD) {
            object = ZERO_LENGTH_HEAD;
        } else if (httpMethod == HttpMethod.CONNECT) {
            object = ZERO_LENGTH_CONNECT;
        }
        this.acceptEncodingQueue.add((CharSequence)object);
        list.add(ReferenceCountUtil.retain(httpRequest));
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, HttpObject httpObject, List<Object> list) {
        boolean bl = httpObject instanceof HttpResponse && httpObject instanceof LastHttpContent;
        switch (this.state) {
            case AWAIT_HEADERS: {
                HttpContentEncoder.ensureHeaders(httpObject);
                assert (this.encoder == null);
                HttpResponse httpResponse = (HttpResponse)httpObject;
                int n2 = httpResponse.getStatus().code();
                if (n2 == CONTINUE_CODE) {
                    this.acceptEncoding = null;
                } else {
                    this.acceptEncoding = this.acceptEncodingQueue.poll();
                    if (this.acceptEncoding == null) {
                        throw new IllegalStateException("cannot send more responses than requests");
                    }
                }
                if (HttpContentEncoder.isPassthru(httpResponse.getProtocolVersion(), n2, this.acceptEncoding)) {
                    if (bl) {
                        list.add(ReferenceCountUtil.retain(httpResponse));
                        return;
                    }
                    list.add(httpResponse);
                    this.state = HttpContentEncoder$State.PASS_THROUGH;
                    return;
                }
                if (bl && !((ByteBufHolder)((Object)httpResponse)).content().isReadable()) {
                    list.add(ReferenceCountUtil.retain(httpResponse));
                    return;
                }
                HttpContentEncoder$Result httpContentEncoder$Result = this.beginEncode(httpResponse, this.acceptEncoding.toString());
                if (httpContentEncoder$Result == null) {
                    if (bl) {
                        list.add(ReferenceCountUtil.retain(httpResponse));
                        return;
                    }
                    list.add(httpResponse);
                    this.state = HttpContentEncoder$State.PASS_THROUGH;
                    return;
                }
                this.encoder = httpContentEncoder$Result.contentEncoder();
                httpResponse.headers().set("Content-Encoding", (Object)httpContentEncoder$Result.targetContentEncoding());
                httpResponse.headers().remove("Content-Length");
                httpResponse.headers().set("Transfer-Encoding", (Object)"chunked");
                if (bl) {
                    DefaultHttpResponse defaultHttpResponse = new DefaultHttpResponse(httpResponse.getProtocolVersion(), httpResponse.getStatus());
                    defaultHttpResponse.headers().set(httpResponse.headers());
                    list.add(defaultHttpResponse);
                } else {
                    list.add(httpResponse);
                    this.state = HttpContentEncoder$State.AWAIT_CONTENT;
                    if (!(httpObject instanceof HttpContent)) break;
                }
            }
            case AWAIT_CONTENT: {
                HttpContentEncoder.ensureContent(httpObject);
                if (!this.encodeContent((HttpContent)httpObject, list)) break;
                this.state = HttpContentEncoder$State.AWAIT_HEADERS;
                return;
            }
            case PASS_THROUGH: {
                HttpContentEncoder.ensureContent(httpObject);
                list.add(ReferenceCountUtil.retain(httpObject));
                if (!(httpObject instanceof LastHttpContent)) break;
                this.state = HttpContentEncoder$State.AWAIT_HEADERS;
            }
        }
    }

    private static boolean isPassthru(HttpVersion httpVersion, int n2, CharSequence charSequence) {
        return n2 < 200 || n2 == 204 || n2 == 304 || charSequence == ZERO_LENGTH_HEAD || charSequence == ZERO_LENGTH_CONNECT && n2 == 200 || httpVersion == HttpVersion.HTTP_1_0;
    }

    private static void ensureHeaders(HttpObject httpObject) {
        if (!(httpObject instanceof HttpResponse)) {
            throw new IllegalStateException("unexpected message type: " + httpObject.getClass().getName() + " (expected: " + HttpResponse.class.getSimpleName() + ')');
        }
    }

    private static void ensureContent(HttpObject httpObject) {
        if (!(httpObject instanceof HttpContent)) {
            throw new IllegalStateException("unexpected message type: " + httpObject.getClass().getName() + " (expected: " + HttpContent.class.getSimpleName() + ')');
        }
    }

    private boolean encodeContent(HttpContent object, List<Object> list) {
        ByteBuf byteBuf = object.content();
        this.encode(byteBuf, list);
        if (object instanceof LastHttpContent) {
            this.finishEncode(list);
            object = (LastHttpContent)object;
            object = object.trailingHeaders();
            if (((HttpHeaders)object).isEmpty()) {
                list.add(LastHttpContent.EMPTY_LAST_CONTENT);
            } else {
                list.add(new ComposedLastHttpContent((HttpHeaders)object));
            }
            return true;
        }
        return false;
    }

    protected abstract HttpContentEncoder$Result beginEncode(HttpResponse var1, String var2);

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.cleanup();
        super.handlerRemoved(channelHandlerContext);
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.cleanup();
        super.channelInactive(channelHandlerContext);
    }

    private void cleanup() {
        if (this.encoder != null) {
            if (this.encoder.finish()) {
                ByteBuf byteBuf;
                while ((byteBuf = (ByteBuf)this.encoder.readOutbound()) != null) {
                    byteBuf.release();
                }
            }
            this.encoder = null;
        }
    }

    private void encode(ByteBuf byteBuf, List<Object> list) {
        this.encoder.writeOutbound(byteBuf.retain());
        this.fetchEncoderOutput(list);
    }

    private void finishEncode(List<Object> list) {
        if (this.encoder.finish()) {
            this.fetchEncoderOutput(list);
        }
        this.encoder = null;
    }

    private void fetchEncoderOutput(List<Object> list) {
        ByteBuf byteBuf;
        while ((byteBuf = (ByteBuf)this.encoder.readOutbound()) != null) {
            if (!byteBuf.isReadable()) {
                byteBuf.release();
                continue;
            }
            list.add(new DefaultHttpContent(byteBuf));
        }
    }
}

