/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpHeaders;
import com.aliyun.openservices.shade.io.netty.util.CharsetUtil;

final class HttpHeaderEntity
implements CharSequence {
    private final String name;
    private final int hash;
    private final byte[] bytes;
    private final int separatorLen;

    public HttpHeaderEntity(String string) {
        this(string, null);
    }

    public HttpHeaderEntity(String object, byte[] byArray) {
        this.name = object;
        this.hash = HttpHeaders.hash((CharSequence)object);
        object = ((String)object).getBytes(CharsetUtil.US_ASCII);
        if (byArray == null) {
            this.bytes = (byte[])object;
            this.separatorLen = 0;
            return;
        }
        this.separatorLen = byArray.length;
        this.bytes = new byte[((Object)object).length + byArray.length];
        System.arraycopy(object, 0, this.bytes, 0, ((Object)object).length);
        System.arraycopy(byArray, 0, this.bytes, ((Object)object).length, byArray.length);
    }

    final int hash() {
        return this.hash;
    }

    @Override
    public final int length() {
        return this.bytes.length - this.separatorLen;
    }

    @Override
    public final char charAt(int n2) {
        if (this.bytes.length - this.separatorLen <= n2) {
            throw new IndexOutOfBoundsException();
        }
        return (char)this.bytes[n2];
    }

    @Override
    public final CharSequence subSequence(int n2, int n3) {
        return new HttpHeaderEntity(this.name.substring(n2, n3));
    }

    @Override
    public final String toString() {
        return this.name;
    }

    final boolean encode(ByteBuf byteBuf) {
        byteBuf.writeBytes(this.bytes);
        return this.separatorLen > 0;
    }
}

