/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http;

import com.aliyun.openservices.shade.io.netty.handler.codec.http.FullHttpMessage;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.FullHttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.FullHttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpMessage;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpResponse;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import java.util.Map;

final class HttpMessageUtil {
    static StringBuilder appendRequest(StringBuilder stringBuilder, HttpRequest httpRequest) {
        HttpMessageUtil.appendCommon(stringBuilder, httpRequest);
        HttpMessageUtil.appendInitialLine(stringBuilder, httpRequest);
        HttpMessageUtil.appendHeaders(stringBuilder, httpRequest.headers());
        HttpMessageUtil.removeLastNewLine(stringBuilder);
        return stringBuilder;
    }

    static StringBuilder appendResponse(StringBuilder stringBuilder, HttpResponse httpResponse) {
        HttpMessageUtil.appendCommon(stringBuilder, httpResponse);
        HttpMessageUtil.appendInitialLine(stringBuilder, httpResponse);
        HttpMessageUtil.appendHeaders(stringBuilder, httpResponse.headers());
        HttpMessageUtil.removeLastNewLine(stringBuilder);
        return stringBuilder;
    }

    private static void appendCommon(StringBuilder stringBuilder, HttpMessage httpMessage) {
        stringBuilder.append(StringUtil.simpleClassName(httpMessage));
        stringBuilder.append("(decodeResult: ");
        stringBuilder.append(httpMessage.getDecoderResult());
        stringBuilder.append(", version: ");
        stringBuilder.append(httpMessage.getProtocolVersion());
        stringBuilder.append(')');
        stringBuilder.append(StringUtil.NEWLINE);
    }

    static StringBuilder appendFullRequest(StringBuilder stringBuilder, FullHttpRequest fullHttpRequest) {
        HttpMessageUtil.appendFullCommon(stringBuilder, fullHttpRequest);
        HttpMessageUtil.appendInitialLine(stringBuilder, fullHttpRequest);
        HttpMessageUtil.appendHeaders(stringBuilder, fullHttpRequest.headers());
        HttpMessageUtil.appendHeaders(stringBuilder, fullHttpRequest.trailingHeaders());
        HttpMessageUtil.removeLastNewLine(stringBuilder);
        return stringBuilder;
    }

    static StringBuilder appendFullResponse(StringBuilder stringBuilder, FullHttpResponse fullHttpResponse) {
        HttpMessageUtil.appendFullCommon(stringBuilder, fullHttpResponse);
        HttpMessageUtil.appendInitialLine(stringBuilder, fullHttpResponse);
        HttpMessageUtil.appendHeaders(stringBuilder, fullHttpResponse.headers());
        HttpMessageUtil.appendHeaders(stringBuilder, fullHttpResponse.trailingHeaders());
        HttpMessageUtil.removeLastNewLine(stringBuilder);
        return stringBuilder;
    }

    private static void appendFullCommon(StringBuilder stringBuilder, FullHttpMessage fullHttpMessage) {
        stringBuilder.append(StringUtil.simpleClassName(fullHttpMessage));
        stringBuilder.append("(decodeResult: ");
        stringBuilder.append(fullHttpMessage.getDecoderResult());
        stringBuilder.append(", version: ");
        stringBuilder.append(fullHttpMessage.getProtocolVersion());
        stringBuilder.append(", content: ");
        stringBuilder.append(fullHttpMessage.content());
        stringBuilder.append(')');
        stringBuilder.append(StringUtil.NEWLINE);
    }

    private static void appendInitialLine(StringBuilder stringBuilder, HttpRequest httpRequest) {
        stringBuilder.append(httpRequest.getMethod());
        stringBuilder.append(' ');
        stringBuilder.append(httpRequest.getUri());
        stringBuilder.append(' ');
        stringBuilder.append(httpRequest.getProtocolVersion());
        stringBuilder.append(StringUtil.NEWLINE);
    }

    private static void appendInitialLine(StringBuilder stringBuilder, HttpResponse httpResponse) {
        stringBuilder.append(httpResponse.getProtocolVersion());
        stringBuilder.append(' ');
        stringBuilder.append(httpResponse.getStatus());
        stringBuilder.append(StringUtil.NEWLINE);
    }

    private static void appendHeaders(StringBuilder stringBuilder, HttpHeaders object) {
        object = object.iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            stringBuilder.append((String)entry.getKey());
            stringBuilder.append(": ");
            stringBuilder.append((String)entry.getValue());
            stringBuilder.append(StringUtil.NEWLINE);
        }
    }

    private static void removeLastNewLine(StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.setLength(stringBuilder2.length() - StringUtil.NEWLINE.length());
    }

    private HttpMessageUtil() {
    }
}

