/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.CompositeByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFutureListener;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.DecoderResult;
import com.aliyun.openservices.shade.io.netty.handler.codec.MessageToMessageDecoder;
import com.aliyun.openservices.shade.io.netty.handler.codec.TooLongFrameException;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.DefaultFullHttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.DefaultHttpHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.FullHttpMessage;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.FullHttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpContent;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpExpectationFailedEvent;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpMessage;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpObject;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpObjectAggregator$1;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpObjectAggregator$2;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpObjectAggregator$AggregatedFullHttpMessage;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpObjectAggregator$AggregatedFullHttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpObjectAggregator$AggregatedFullHttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpResponseStatus;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpVersion;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.LastHttpContent;
import java.util.List;

public class HttpObjectAggregator
extends MessageToMessageDecoder<HttpObject> {
    public static final int DEFAULT_MAX_COMPOSITEBUFFER_COMPONENTS = 1024;
    private static final FullHttpResponse CONTINUE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);
    private static final FullHttpResponse EXPECTATION_FAILED = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.EXPECTATION_FAILED, Unpooled.EMPTY_BUFFER);
    private final int maxContentLength;
    private HttpObjectAggregator$AggregatedFullHttpMessage currentMessage;
    private final boolean closeOnExpectationFailed;
    private int maxCumulationBufferComponents = 1024;
    private ChannelHandlerContext ctx;

    public HttpObjectAggregator(int n2) {
        this(n2, false);
    }

    public HttpObjectAggregator(int n2, boolean bl) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxContentLength must be a positive integer: " + n2);
        }
        this.maxContentLength = n2;
        this.closeOnExpectationFailed = bl;
    }

    public final int getMaxCumulationBufferComponents() {
        return this.maxCumulationBufferComponents;
    }

    public final void setMaxCumulationBufferComponents(int n2) {
        if (n2 < 2) {
            throw new IllegalArgumentException("maxCumulationBufferComponents: " + n2 + " (expected: >= 2)");
        }
        if (this.ctx == null) {
            this.maxCumulationBufferComponents = n2;
            return;
        }
        throw new IllegalStateException("decoder properties cannot be changed once the decoder is added to a pipeline.");
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, HttpObject object, List<Object> list) {
        if (object instanceof HttpMessage) {
            if (this.currentMessage != null) {
                this.currentMessage.release();
                this.currentMessage = null;
                throw new IllegalStateException("Start of new message received before existing message completed.");
            }
            HttpMessage httpMessage = (HttpMessage)object;
            if (HttpHeaders.is100ContinueExpected(httpMessage)) {
                if (HttpHeaders.getContentLength(httpMessage, 0L) > (long)this.maxContentLength) {
                    object = channelHandlerContext.writeAndFlush(EXPECTATION_FAILED.duplicate().retain());
                    object.addListener(new HttpObjectAggregator$1(this, channelHandlerContext));
                    if (this.closeOnExpectationFailed) {
                        object.addListener(ChannelFutureListener.CLOSE);
                    }
                    channelHandlerContext.pipeline().fireUserEventTriggered(HttpExpectationFailedEvent.INSTANCE);
                    return;
                }
                channelHandlerContext.writeAndFlush(CONTINUE.duplicate().retain()).addListener(new HttpObjectAggregator$2(this, channelHandlerContext));
            }
            if (!httpMessage.getDecoderResult().isSuccess()) {
                HttpHeaders.removeTransferEncodingChunked(httpMessage);
                list.add(HttpObjectAggregator.toFullMessage(httpMessage));
                return;
            }
            if (object instanceof HttpRequest) {
                object = (HttpRequest)object;
                this.currentMessage = new HttpObjectAggregator$AggregatedFullHttpRequest((HttpRequest)object, (ByteBuf)channelHandlerContext.alloc().compositeBuffer(this.maxCumulationBufferComponents), null);
            } else if (object instanceof HttpResponse) {
                object = (HttpResponse)object;
                this.currentMessage = new HttpObjectAggregator$AggregatedFullHttpResponse((HttpResponse)object, (ByteBuf)channelHandlerContext.alloc().compositeBuffer(this.maxCumulationBufferComponents), null);
            } else {
                throw new Error();
            }
            HttpHeaders.removeTransferEncodingChunked(this.currentMessage);
            return;
        }
        if (object instanceof HttpContent) {
            boolean bl;
            if (this.currentMessage == null) {
                return;
            }
            HttpContent httpContent = (HttpContent)object;
            object = (CompositeByteBuf)this.currentMessage.content();
            if (((ByteBuf)object).readableBytes() > this.maxContentLength - httpContent.content().readableBytes()) {
                this.currentMessage.release();
                this.currentMessage = null;
                throw new TooLongFrameException("HTTP content length exceeded " + this.maxContentLength + " bytes.");
            }
            if (httpContent.content().isReadable()) {
                ((CompositeByteBuf)object).addComponent(true, httpContent.content().retain());
            }
            if (!httpContent.getDecoderResult().isSuccess()) {
                this.currentMessage.setDecoderResult(DecoderResult.failure(httpContent.getDecoderResult().cause()));
                bl = true;
            } else {
                bl = httpContent instanceof LastHttpContent;
            }
            if (bl) {
                if (httpContent instanceof LastHttpContent) {
                    LastHttpContent lastHttpContent = (LastHttpContent)httpContent;
                    this.currentMessage.setTrailingHeaders(lastHttpContent.trailingHeaders());
                } else {
                    this.currentMessage.setTrailingHeaders(new DefaultHttpHeaders());
                }
                if (!HttpHeaders.isContentLengthSet(this.currentMessage)) {
                    this.currentMessage.headers().set("Content-Length", (Object)String.valueOf(((ByteBuf)object).readableBytes()));
                }
                HttpObjectAggregator$AggregatedFullHttpMessage httpObjectAggregator$AggregatedFullHttpMessage = this.currentMessage;
                this.currentMessage = null;
                list.add(httpObjectAggregator$AggregatedFullHttpMessage);
            }
            return;
        }
        throw new Error();
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        try {
            super.channelInactive(channelHandlerContext);
            return;
        }
        finally {
            this.releaseCurrentMessage();
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        try {
            super.handlerRemoved(channelHandlerContext);
            return;
        }
        finally {
            this.releaseCurrentMessage();
        }
    }

    private void releaseCurrentMessage() {
        if (this.currentMessage != null) {
            this.currentMessage.release();
            this.currentMessage = null;
        }
    }

    private static FullHttpMessage toFullMessage(HttpMessage httpMessage) {
        if (httpMessage instanceof FullHttpMessage) {
            return ((FullHttpMessage)httpMessage).retain();
        }
        if (httpMessage instanceof HttpRequest) {
            httpMessage = new HttpObjectAggregator$AggregatedFullHttpRequest((HttpRequest)httpMessage, Unpooled.EMPTY_BUFFER, (HttpHeaders)new DefaultHttpHeaders());
        } else if (httpMessage instanceof HttpResponse) {
            httpMessage = new HttpObjectAggregator$AggregatedFullHttpResponse((HttpResponse)httpMessage, Unpooled.EMPTY_BUFFER, (HttpHeaders)new DefaultHttpHeaders());
        } else {
            throw new IllegalStateException();
        }
        return httpMessage;
    }

    static {
        HttpHeaders.setContentLength(EXPECTATION_FAILED, 0L);
    }
}

