/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.handler.codec.http;

import com.aliyun.openservices.shade.io.netty.channel.ChannelDuplexHandler;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFutureListener;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpHeaders;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpRequest;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.HttpResponse;
import com.aliyun.openservices.shade.io.netty.handler.codec.http.LastHttpContent;

public class HttpServerKeepAliveHandler
extends ChannelDuplexHandler {
    private static final String MULTIPART_PREFIX = "multipart";
    private boolean persistentConnection = true;
    private int pendingResponses;

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)object;
            if (this.persistentConnection) {
                ++this.pendingResponses;
                this.persistentConnection = HttpHeaders.isKeepAlive(httpRequest);
            }
        }
        super.channelRead(channelHandlerContext, object);
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        if (object instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)object;
            this.trackResponse(httpResponse);
            if (!HttpHeaders.isKeepAlive(httpResponse) || !HttpServerKeepAliveHandler.isSelfDefinedMessageLength(httpResponse)) {
                this.pendingResponses = 0;
                this.persistentConnection = false;
            }
            if (!this.shouldKeepAlive()) {
                HttpHeaders.setKeepAlive(httpResponse, false);
            }
        }
        if (object instanceof LastHttpContent && !this.shouldKeepAlive()) {
            channelPromise.addListener(ChannelFutureListener.CLOSE);
        }
        super.write(channelHandlerContext, object, channelPromise);
    }

    private void trackResponse(HttpResponse httpResponse) {
        if (!HttpServerKeepAliveHandler.isInformational(httpResponse)) {
            --this.pendingResponses;
        }
    }

    private boolean shouldKeepAlive() {
        return this.pendingResponses != 0 || this.persistentConnection;
    }

    private static boolean isSelfDefinedMessageLength(HttpResponse httpResponse) {
        return HttpHeaders.isContentLengthSet(httpResponse) || HttpHeaders.isTransferEncodingChunked(httpResponse) || HttpServerKeepAliveHandler.isMultipart(httpResponse) || HttpServerKeepAliveHandler.isInformational(httpResponse);
    }

    private static boolean isInformational(HttpResponse httpResponse) {
        int n2 = httpResponse.getStatus().code();
        return n2 >= 100 && n2 <= 199;
    }

    private static boolean isMultipart(HttpResponse object) {
        return (object = object.headers().get("Content-Type")) != null && ((String)object).regionMatches(true, 0, MULTIPART_PREFIX, 0, 9);
    }
}

